/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.beanutils.converters;

import java.util.List;
import oadd.org.apache.commons.beanutils.ConversionException;
import oadd.org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class FloatArrayConverter
extends AbstractArrayConverter {
    private static float[] model = new float[0];

    public FloatArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public FloatArrayConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == value.getClass()) {
            return value;
        }
        if (AbstractArrayConverter.strings.getClass() == value.getClass()) {
            try {
                String[] values = (String[])value;
                float[] results = new float[values.length];
                int i = 0;
                while (i < values.length) {
                    results[i] = Float.parseFloat(values[i]);
                    ++i;
                }
                return results;
            }
            catch (Exception e) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(value.toString(), e);
            }
        }
        try {
            List list = this.parseElements(value.toString());
            float[] results = new float[list.size()];
            int i = 0;
            while (i < results.length) {
                results[i] = Float.parseFloat((String)list.get(i));
                ++i;
            }
            return results;
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(value.toString(), e);
        }
    }
}

