/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.bcel.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.BitSet;
import oadd.org.apache.bcel.Constants;
import oadd.org.apache.bcel.classfile.Attribute;
import oadd.org.apache.bcel.classfile.Code;
import oadd.org.apache.bcel.classfile.CodeException;
import oadd.org.apache.bcel.classfile.ConstantFieldref;
import oadd.org.apache.bcel.classfile.ConstantInterfaceMethodref;
import oadd.org.apache.bcel.classfile.ConstantMethodref;
import oadd.org.apache.bcel.classfile.ConstantNameAndType;
import oadd.org.apache.bcel.classfile.ConstantPool;
import oadd.org.apache.bcel.classfile.LocalVariable;
import oadd.org.apache.bcel.classfile.LocalVariableTable;
import oadd.org.apache.bcel.classfile.Method;
import oadd.org.apache.bcel.classfile.Utility;
import oadd.org.apache.bcel.util.ByteSequence;
import oadd.org.apache.bcel.util.Class2HTML;
import oadd.org.apache.bcel.util.ConstantHTML;

final class CodeHTML
implements Constants {
    private String class_name;
    private Method[] methods;
    private PrintWriter file;
    private BitSet goto_set;
    private ConstantPool constant_pool;
    private ConstantHTML constant_html;
    private static boolean wide = false;

    CodeHTML(String dir, String class_name, Method[] methods, ConstantPool constant_pool, ConstantHTML constant_html) throws IOException {
        this.class_name = class_name;
        this.methods = methods;
        this.constant_pool = constant_pool;
        this.constant_html = constant_html;
        this.file = new PrintWriter(new FileOutputStream(dir + class_name + "_code.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\">");
        int i = 0;
        while (i < methods.length) {
            this.writeMethod(methods[i], i);
            ++i;
        }
        this.file.println("</BODY></HTML>");
        this.file.close();
    }

    private final String codeToHTML(ByteSequence bytes, int method_number) throws IOException {
        int i;
        short opcode = (short)bytes.readUnsignedByte();
        int default_offset = 0;
        int no_pad_bytes = 0;
        StringBuffer buf = new StringBuffer("<TT>" + Constants.OPCODE_NAMES[opcode] + "</TT></TD><TD>");
        if (opcode == 170 || opcode == 171) {
            int remainder = bytes.getIndex() % 4;
            no_pad_bytes = remainder == 0 ? 0 : 4 - remainder;
            i = 0;
            while (i < no_pad_bytes) {
                bytes.readByte();
                ++i;
            }
            default_offset = bytes.readInt();
        }
        switch (opcode) {
            case 170: {
                int low = bytes.readInt();
                int high = bytes.readInt();
                int offset = bytes.getIndex() - 12 - no_pad_bytes - 1;
                default_offset += offset;
                buf.append("<TABLE BORDER=1><TR>");
                int[] jump_table = new int[high - low + 1];
                int i2 = 0;
                while (i2 < jump_table.length) {
                    jump_table[i2] = offset + bytes.readInt();
                    buf.append("<TH>" + (low + i2) + "</TH>");
                    ++i2;
                }
                buf.append("<TH>default</TH></TR>\n<TR>");
                i = 0;
                while (i < jump_table.length) {
                    buf.append("<TD><A HREF=\"#code" + method_number + "@" + jump_table[i] + "\">" + jump_table[i] + "</A></TD>");
                    ++i;
                }
                buf.append("<TD><A HREF=\"#code" + method_number + "@" + default_offset + "\">" + default_offset + "</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 171: {
                int npairs = bytes.readInt();
                int offset = bytes.getIndex() - 8 - no_pad_bytes - 1;
                int[] jump_table = new int[npairs];
                default_offset += offset;
                buf.append("<TABLE BORDER=1><TR>");
                int i3 = 0;
                while (i3 < npairs) {
                    int match = bytes.readInt();
                    jump_table[i3] = offset + bytes.readInt();
                    buf.append("<TH>" + match + "</TH>");
                    ++i3;
                }
                buf.append("<TH>default</TH></TR>\n<TR>");
                int i4 = 0;
                while (i4 < npairs) {
                    buf.append("<TD><A HREF=\"#code" + method_number + "@" + jump_table[i4] + "\">" + jump_table[i4] + "</A></TD>");
                    ++i4;
                }
                buf.append("<TD><A HREF=\"#code" + method_number + "@" + default_offset + "\">" + default_offset + "</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                int index = bytes.getIndex() + bytes.readShort() - 1;
                buf.append("<A HREF=\"#code" + method_number + "@" + index + "\">" + index + "</A>");
                break;
            }
            case 200: 
            case 201: {
                int windex = bytes.getIndex() + bytes.readInt() - 1;
                buf.append("<A HREF=\"#code" + method_number + "@" + windex + "\">" + windex + "</A>");
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int vindex;
                if (wide) {
                    vindex = bytes.readShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                }
                buf.append("%" + vindex);
                break;
            }
            case 196: {
                wide = true;
                buf.append("(wide)");
                break;
            }
            case 188: {
                buf.append("<FONT COLOR=\"#00FF00\">" + Constants.TYPE_NAMES[bytes.readByte()] + "</FONT>");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int index = bytes.readShort();
                ConstantFieldref c1 = (ConstantFieldref)this.constant_pool.getConstant(index, (byte)9);
                int class_index = c1.getClassIndex();
                String name = this.constant_pool.getConstantString(class_index, (byte)7);
                name = Utility.compactClassName(name, false);
                index = c1.getNameAndTypeIndex();
                String field_name = this.constant_pool.constantToString(index, (byte)12);
                if (name.equals(this.class_name)) {
                    buf.append("<A HREF=\"" + this.class_name + "_methods.html#field" + field_name + "\" TARGET=Methods>" + field_name + "</A>\n");
                    break;
                }
                buf.append(this.constant_html.referenceConstant(class_index) + "." + field_name);
                break;
            }
            case 187: 
            case 192: 
            case 193: {
                short index = bytes.readShort();
                buf.append(this.constant_html.referenceConstant(index));
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                int index;
                String str;
                int class_index;
                short m_index = bytes.readShort();
                if (opcode == 185) {
                    int nargs = bytes.readUnsignedByte();
                    int reserved = bytes.readUnsignedByte();
                    ConstantInterfaceMethodref c = (ConstantInterfaceMethodref)this.constant_pool.getConstant(m_index, (byte)11);
                    class_index = c.getClassIndex();
                    str = this.constant_pool.constantToString(c);
                    index = c.getNameAndTypeIndex();
                } else {
                    ConstantMethodref c = (ConstantMethodref)this.constant_pool.getConstant(m_index, (byte)10);
                    class_index = c.getClassIndex();
                    str = this.constant_pool.constantToString(c);
                    index = c.getNameAndTypeIndex();
                }
                String name = Class2HTML.referenceClass(class_index);
                str = Class2HTML.toHTML(this.constant_pool.constantToString(this.constant_pool.getConstant(index, (byte)12)));
                ConstantNameAndType c2 = (ConstantNameAndType)this.constant_pool.getConstant(index, (byte)12);
                String signature = this.constant_pool.constantToString(c2.getSignatureIndex(), (byte)1);
                String[] args = Utility.methodSignatureArgumentTypes(signature, false);
                String type = Utility.methodSignatureReturnType(signature, false);
                buf.append(name + ".<A HREF=\"" + this.class_name + "_cp.html#cp" + m_index + "\" TARGET=ConstantPool>" + str + "</A>" + "(");
                int i5 = 0;
                while (i5 < args.length) {
                    buf.append(Class2HTML.referenceType(args[i5]));
                    if (i5 < args.length - 1) {
                        buf.append(", ");
                    }
                    ++i5;
                }
                buf.append("):" + Class2HTML.referenceType(type));
                break;
            }
            case 19: 
            case 20: {
                short index = bytes.readShort();
                buf.append("<A HREF=\"" + this.class_name + "_cp.html#cp" + index + "\" TARGET=\"ConstantPool\">" + Class2HTML.toHTML(this.constant_pool.constantToString(index, this.constant_pool.getConstant(index).getTag())) + "</a>");
                break;
            }
            case 18: {
                int index = bytes.readUnsignedByte();
                buf.append("<A HREF=\"" + this.class_name + "_cp.html#cp" + index + "\" TARGET=\"ConstantPool\">" + Class2HTML.toHTML(this.constant_pool.constantToString(index, this.constant_pool.getConstant(index).getTag())) + "</a>");
                break;
            }
            case 189: {
                short index = bytes.readShort();
                buf.append(this.constant_html.referenceConstant(index));
                break;
            }
            case 197: {
                short index = bytes.readShort();
                byte dimensions = bytes.readByte();
                buf.append(this.constant_html.referenceConstant(index) + ":" + dimensions + "-dimensional");
                break;
            }
            case 132: {
                short constant;
                int vindex;
                if (wide) {
                    vindex = bytes.readShort();
                    constant = bytes.readShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                    constant = bytes.readByte();
                }
                buf.append("%" + vindex + " " + constant);
                break;
            }
            default: {
                if (Constants.NO_OF_OPERANDS[opcode] <= 0) break;
                int i6 = 0;
                while (i6 < Constants.TYPE_OF_OPERANDS[opcode].length) {
                    switch (Constants.TYPE_OF_OPERANDS[opcode][i6]) {
                        case 8: {
                            buf.append(bytes.readUnsignedByte());
                            break;
                        }
                        case 9: {
                            buf.append(bytes.readShort());
                            break;
                        }
                        case 10: {
                            buf.append(bytes.readInt());
                            break;
                        }
                        default: {
                            System.err.println("Unreachable default case reached!");
                            System.exit(-1);
                        }
                    }
                    buf.append("&nbsp;");
                    ++i6;
                }
                break block0;
            }
        }
        buf.append("</TD>");
        return buf.toString();
    }

    private final void findGotos(ByteSequence bytes, Method method, Code code) throws IOException {
        this.goto_set = new BitSet(bytes.available());
        if (code != null) {
            CodeException[] ce = code.getExceptionTable();
            int len = ce.length;
            int i = 0;
            while (i < len) {
                this.goto_set.set(ce[i].getStartPC());
                this.goto_set.set(ce[i].getEndPC());
                this.goto_set.set(ce[i].getHandlerPC());
                ++i;
            }
            Attribute[] attributes = code.getAttributes();
            int i2 = 0;
            while (i2 < attributes.length) {
                if (attributes[i2].getTag() == 5) {
                    LocalVariable[] vars = ((LocalVariableTable)attributes[i2]).getLocalVariableTable();
                    int j = 0;
                    while (j < vars.length) {
                        int start = vars[j].getStartPC();
                        int end = start + vars[j].getLength();
                        this.goto_set.set(start);
                        this.goto_set.set(end);
                        ++j;
                    }
                    break;
                }
                ++i2;
            }
        }
        int i = 0;
        while (bytes.available() > 0) {
            int opcode = bytes.readUnsignedByte();
            switch (opcode) {
                case 170: 
                case 171: {
                    int index;
                    int offset;
                    int remainder = bytes.getIndex() % 4;
                    int no_pad_bytes = remainder == 0 ? 0 : 4 - remainder;
                    int j = 0;
                    while (j < no_pad_bytes) {
                        bytes.readByte();
                        ++j;
                    }
                    int default_offset = bytes.readInt();
                    if (opcode == 170) {
                        int low = bytes.readInt();
                        int high = bytes.readInt();
                        offset = bytes.getIndex() - 12 - no_pad_bytes - 1;
                        this.goto_set.set(default_offset += offset);
                        int j2 = 0;
                        while (j2 < high - low + 1) {
                            index = offset + bytes.readInt();
                            this.goto_set.set(index);
                            ++j2;
                        }
                    } else {
                        int npairs = bytes.readInt();
                        offset = bytes.getIndex() - 8 - no_pad_bytes - 1;
                        this.goto_set.set(default_offset += offset);
                        int j3 = 0;
                        while (j3 < npairs) {
                            int match = bytes.readInt();
                            index = offset + bytes.readInt();
                            this.goto_set.set(index);
                            ++j3;
                        }
                    }
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    int index = bytes.getIndex() + bytes.readShort() - 1;
                    this.goto_set.set(index);
                    break;
                }
                case 200: 
                case 201: {
                    int index = bytes.getIndex() + bytes.readInt() - 1;
                    this.goto_set.set(index);
                    break;
                }
                default: {
                    bytes.unreadByte();
                    this.codeToHTML(bytes, 0);
                }
            }
            ++i;
        }
    }

    private void writeMethod(Method method, int method_number) throws IOException {
        String signature = method.getSignature();
        String[] args = Utility.methodSignatureArgumentTypes(signature, false);
        String type = Utility.methodSignatureReturnType(signature, false);
        String name = method.getName();
        String html_name = Class2HTML.toHTML(name);
        String access = Utility.accessToString(method.getAccessFlags());
        access = Utility.replace(access, " ", "&nbsp;");
        Attribute[] attributes = method.getAttributes();
        this.file.print("<P><B><FONT COLOR=\"#FF0000\">" + access + "</FONT>&nbsp;" + "<A NAME=method" + method_number + ">" + Class2HTML.referenceType(type) + "</A>&nbsp<A HREF=\"" + this.class_name + "_methods.html#method" + method_number + "\" TARGET=Methods>" + html_name + "</A>(");
        int i = 0;
        while (i < args.length) {
            this.file.print(Class2HTML.referenceType(args[i]));
            if (i < args.length - 1) {
                this.file.print(",&nbsp;");
            }
            ++i;
        }
        this.file.println(")</B></P>");
        Code c = null;
        byte[] code = null;
        if (attributes.length > 0) {
            this.file.print("<H4>Attributes</H4><UL>\n");
            int i2 = 0;
            while (i2 < attributes.length) {
                byte tag = attributes[i2].getTag();
                if (tag != -1) {
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#method" + method_number + "@" + i2 + "\" TARGET=Attributes>" + Constants.ATTRIBUTE_NAMES[tag] + "</A></LI>\n");
                } else {
                    this.file.print("<LI>" + attributes[i2] + "</LI>");
                }
                if (tag == 2) {
                    c = (Code)attributes[i2];
                    Attribute[] attributes2 = c.getAttributes();
                    code = c.getCode();
                    this.file.print("<UL>");
                    int j = 0;
                    while (j < attributes2.length) {
                        tag = attributes2[j].getTag();
                        this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#" + "method" + method_number + "@" + i2 + "@" + j + "\" TARGET=Attributes>" + Constants.ATTRIBUTE_NAMES[tag] + "</A></LI>\n");
                        ++j;
                    }
                    this.file.print("</UL>");
                }
                ++i2;
            }
            this.file.println("</UL>");
        }
        if (code != null) {
            ByteSequence stream = new ByteSequence(code);
            stream.mark(stream.available());
            this.findGotos(stream, method, c);
            stream.reset();
            this.file.println("<TABLE BORDER=0><TR><TH ALIGN=LEFT>Byte<BR>offset</TH><TH ALIGN=LEFT>Instruction</TH><TH ALIGN=LEFT>Argument</TH>");
            int i3 = 0;
            while (stream.available() > 0) {
                int offset = stream.getIndex();
                String str = this.codeToHTML(stream, method_number);
                String anchor = "";
                if (this.goto_set.get(offset)) {
                    anchor = "<A NAME=code" + method_number + "@" + offset + "></A>";
                }
                String anchor2 = stream.getIndex() == code.length ? "<A NAME=code" + method_number + "@" + code.length + ">" + offset + "</A>" : "" + offset;
                this.file.println("<TR VALIGN=TOP><TD>" + anchor2 + "</TD><TD>" + anchor + str + "</TR>");
                ++i3;
            }
            this.file.println("<TR><TD> </A></TD></TR>");
            this.file.println("</TABLE>");
        }
    }
}

