/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.bcel.classfile;

import java.util.Stack;
import oadd.org.apache.bcel.classfile.Attribute;
import oadd.org.apache.bcel.classfile.Code;
import oadd.org.apache.bcel.classfile.CodeException;
import oadd.org.apache.bcel.classfile.Constant;
import oadd.org.apache.bcel.classfile.ConstantClass;
import oadd.org.apache.bcel.classfile.ConstantDouble;
import oadd.org.apache.bcel.classfile.ConstantFieldref;
import oadd.org.apache.bcel.classfile.ConstantFloat;
import oadd.org.apache.bcel.classfile.ConstantInteger;
import oadd.org.apache.bcel.classfile.ConstantInterfaceMethodref;
import oadd.org.apache.bcel.classfile.ConstantLong;
import oadd.org.apache.bcel.classfile.ConstantMethodref;
import oadd.org.apache.bcel.classfile.ConstantNameAndType;
import oadd.org.apache.bcel.classfile.ConstantPool;
import oadd.org.apache.bcel.classfile.ConstantString;
import oadd.org.apache.bcel.classfile.ConstantUtf8;
import oadd.org.apache.bcel.classfile.ConstantValue;
import oadd.org.apache.bcel.classfile.Deprecated;
import oadd.org.apache.bcel.classfile.ExceptionTable;
import oadd.org.apache.bcel.classfile.Field;
import oadd.org.apache.bcel.classfile.InnerClass;
import oadd.org.apache.bcel.classfile.InnerClasses;
import oadd.org.apache.bcel.classfile.JavaClass;
import oadd.org.apache.bcel.classfile.LineNumber;
import oadd.org.apache.bcel.classfile.LineNumberTable;
import oadd.org.apache.bcel.classfile.LocalVariable;
import oadd.org.apache.bcel.classfile.LocalVariableTable;
import oadd.org.apache.bcel.classfile.Method;
import oadd.org.apache.bcel.classfile.SourceFile;
import oadd.org.apache.bcel.classfile.StackMap;
import oadd.org.apache.bcel.classfile.StackMapEntry;
import oadd.org.apache.bcel.classfile.Synthetic;
import oadd.org.apache.bcel.classfile.Unknown;
import oadd.org.apache.bcel.classfile.Visitor;

public class DescendingVisitor
implements Visitor {
    private JavaClass clazz;
    private Visitor visitor;
    private Stack stack = new Stack();

    public Object predecessor() {
        return this.predecessor(0);
    }

    public Object predecessor(int level) {
        int size = this.stack.size();
        if (size < 2 || level < 0) {
            return null;
        }
        return this.stack.elementAt(size - (level + 2));
    }

    public Object current() {
        return this.stack.peek();
    }

    public DescendingVisitor(JavaClass clazz, Visitor visitor) {
        this.clazz = clazz;
        this.visitor = visitor;
    }

    public void visit() {
        this.clazz.accept(this);
    }

    public void visitJavaClass(JavaClass clazz) {
        this.stack.push(clazz);
        clazz.accept(this.visitor);
        Field[] fields = clazz.getFields();
        int i = 0;
        while (i < fields.length) {
            fields[i].accept(this);
            ++i;
        }
        Method[] methods = clazz.getMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            methods[i2].accept(this);
            ++i2;
        }
        Attribute[] attributes = clazz.getAttributes();
        int i3 = 0;
        while (i3 < attributes.length) {
            attributes[i3].accept(this);
            ++i3;
        }
        clazz.getConstantPool().accept(this);
        this.stack.pop();
    }

    public void visitField(Field field) {
        this.stack.push(field);
        field.accept(this.visitor);
        Attribute[] attributes = field.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            attributes[i].accept(this);
            ++i;
        }
        this.stack.pop();
    }

    public void visitConstantValue(ConstantValue cv) {
        this.stack.push(cv);
        cv.accept(this.visitor);
        this.stack.pop();
    }

    public void visitMethod(Method method) {
        this.stack.push(method);
        method.accept(this.visitor);
        Attribute[] attributes = method.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            attributes[i].accept(this);
            ++i;
        }
        this.stack.pop();
    }

    public void visitExceptionTable(ExceptionTable table) {
        this.stack.push(table);
        table.accept(this.visitor);
        this.stack.pop();
    }

    public void visitCode(Code code) {
        this.stack.push(code);
        code.accept(this.visitor);
        CodeException[] table = code.getExceptionTable();
        int i = 0;
        while (i < table.length) {
            table[i].accept(this);
            ++i;
        }
        Attribute[] attributes = code.getAttributes();
        int i2 = 0;
        while (i2 < attributes.length) {
            attributes[i2].accept(this);
            ++i2;
        }
        this.stack.pop();
    }

    public void visitCodeException(CodeException ce) {
        this.stack.push(ce);
        ce.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLineNumberTable(LineNumberTable table) {
        this.stack.push(table);
        table.accept(this.visitor);
        LineNumber[] numbers = table.getLineNumberTable();
        int i = 0;
        while (i < numbers.length) {
            numbers[i].accept(this);
            ++i;
        }
        this.stack.pop();
    }

    public void visitLineNumber(LineNumber number) {
        this.stack.push(number);
        number.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLocalVariableTable(LocalVariableTable table) {
        this.stack.push(table);
        table.accept(this.visitor);
        LocalVariable[] vars = table.getLocalVariableTable();
        int i = 0;
        while (i < vars.length) {
            vars[i].accept(this);
            ++i;
        }
        this.stack.pop();
    }

    public void visitStackMap(StackMap table) {
        this.stack.push(table);
        table.accept(this.visitor);
        StackMapEntry[] vars = table.getStackMap();
        int i = 0;
        while (i < vars.length) {
            vars[i].accept(this);
            ++i;
        }
        this.stack.pop();
    }

    public void visitStackMapEntry(StackMapEntry var) {
        this.stack.push(var);
        var.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLocalVariable(LocalVariable var) {
        this.stack.push(var);
        var.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantPool(ConstantPool cp) {
        this.stack.push(cp);
        cp.accept(this.visitor);
        Constant[] constants = cp.getConstantPool();
        int i = 1;
        while (i < constants.length) {
            if (constants[i] != null) {
                constants[i].accept(this);
            }
            ++i;
        }
        this.stack.pop();
    }

    public void visitConstantClass(ConstantClass constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantDouble(ConstantDouble constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantFieldref(ConstantFieldref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantFloat(ConstantFloat constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantInteger(ConstantInteger constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantLong(ConstantLong constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantMethodref(ConstantMethodref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantNameAndType(ConstantNameAndType constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantString(ConstantString constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantUtf8(ConstantUtf8 constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitInnerClasses(InnerClasses ic) {
        this.stack.push(ic);
        ic.accept(this.visitor);
        InnerClass[] ics = ic.getInnerClasses();
        int i = 0;
        while (i < ics.length) {
            ics[i].accept(this);
            ++i;
        }
        this.stack.pop();
    }

    public void visitInnerClass(InnerClass inner) {
        this.stack.push(inner);
        inner.accept(this.visitor);
        this.stack.pop();
    }

    public void visitDeprecated(Deprecated attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitSourceFile(SourceFile attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitSynthetic(Synthetic attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitUnknown(Unknown attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }
}

