/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.netty.buffer;

import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicLong;
import oadd.io.netty.buffer.AbstractByteBuf;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.LargeBuffer;
import oadd.io.netty.buffer.PooledUnsafeDirectByteBuf;
import oadd.io.netty.buffer.SlicedByteBuf;
import oadd.io.netty.buffer.WrappedByteBuf;
import oadd.io.netty.util.internal.PlatformDependent;
import oadd.org.apache.drill.exec.util.AssertionUtil;

public final class UnsafeDirectLittleEndian
extends WrappedByteBuf {
    private static final boolean NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private final AbstractByteBuf wrapped;
    private final long memoryAddress;
    private AtomicLong bufferCount;
    private AtomicLong bufferSize;
    private long initCap = -1L;

    UnsafeDirectLittleEndian(LargeBuffer buf) {
        this(buf, true);
    }

    UnsafeDirectLittleEndian(PooledUnsafeDirectByteBuf buf, AtomicLong bufferCount, AtomicLong bufferSize) {
        this(buf, true);
        this.bufferCount = bufferCount;
        this.bufferSize = bufferSize;
        this.initCap = AssertionUtil.ASSERT_ENABLED ? (long)this.capacity() : -1L;
    }

    private UnsafeDirectLittleEndian(AbstractByteBuf buf, boolean fake) {
        super(buf);
        if (!NATIVE_ORDER || buf.order() != ByteOrder.BIG_ENDIAN) {
            throw new IllegalStateException("Drill only runs on LittleEndian systems.");
        }
        this.wrapped = buf;
        this.memoryAddress = buf.memoryAddress();
    }

    private long addr(int index) {
        return this.memoryAddress + (long)index;
    }

    @Override
    public long getLong(int index) {
        long v = PlatformDependent.getLong(this.addr(index));
        return v;
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    @Override
    public ByteBuf slice() {
        return this.slice(this.readerIndex(), this.readableBytes());
    }

    @Override
    public ByteBuf slice(int index, int length) {
        return new SlicedByteBuf(this, index, length);
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    public ByteBuf order(ByteOrder endianness) {
        return this;
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    @Override
    public char getChar(int index) {
        return (char)this.getShort(index);
    }

    @Override
    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    @Override
    public int getInt(int index) {
        int v = PlatformDependent.getInt(this.addr(index));
        return v;
    }

    @Override
    public int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    @Override
    public short getShort(int index) {
        short v = PlatformDependent.getShort(this.addr(index));
        return v;
    }

    @Override
    public ByteBuf setShort(int index, int value) {
        this.wrapped.checkIndex(index, 2);
        this._setShort(index, value);
        return this;
    }

    @Override
    public ByteBuf setInt(int index, int value) {
        this.wrapped.checkIndex(index, 4);
        this._setInt(index, value);
        return this;
    }

    @Override
    public ByteBuf setLong(int index, long value) {
        this.wrapped.checkIndex(index, 8);
        this._setLong(index, value);
        return this;
    }

    @Override
    public ByteBuf setChar(int index, int value) {
        this.setShort(index, value);
        return this;
    }

    @Override
    public ByteBuf setFloat(int index, float value) {
        this.setInt(index, Float.floatToRawIntBits(value));
        return this;
    }

    @Override
    public ByteBuf setDouble(int index, double value) {
        this.setLong(index, Double.doubleToRawLongBits(value));
        return this;
    }

    @Override
    public ByteBuf writeShort(int value) {
        this.wrapped.ensureWritable(2);
        this._setShort(this.wrapped.writerIndex, value);
        this.wrapped.writerIndex += 2;
        return this;
    }

    @Override
    public ByteBuf writeInt(int value) {
        this.wrapped.ensureWritable(4);
        this._setInt(this.wrapped.writerIndex, value);
        this.wrapped.writerIndex += 4;
        return this;
    }

    @Override
    public ByteBuf writeLong(long value) {
        this.wrapped.ensureWritable(8);
        this._setLong(this.wrapped.writerIndex, value);
        this.wrapped.writerIndex += 8;
        return this;
    }

    @Override
    public ByteBuf writeChar(int value) {
        this.writeShort(value);
        return this;
    }

    @Override
    public ByteBuf writeFloat(float value) {
        this.writeInt(Float.floatToRawIntBits(value));
        return this;
    }

    @Override
    public ByteBuf writeDouble(double value) {
        this.writeLong(Double.doubleToRawLongBits(value));
        return this;
    }

    private void _setShort(int index, int value) {
        PlatformDependent.putShort(this.addr(index), (short)value);
    }

    private void _setInt(int index, int value) {
        PlatformDependent.putInt(this.addr(index), value);
    }

    private void _setLong(int index, long value) {
        PlatformDependent.putLong(this.addr(index), value);
    }

    @Override
    public byte getByte(int index) {
        return PlatformDependent.getByte(this.addr(index));
    }

    @Override
    public ByteBuf setByte(int index, int value) {
        PlatformDependent.putByte(this.addr(index), (byte)value);
        return this;
    }

    @Override
    public boolean release() {
        return this.release(1);
    }

    @Override
    public boolean release(int decrement) {
        boolean released = super.release(decrement);
        if (released && this.initCap != -1L) {
            this.bufferCount.decrementAndGet();
            this.bufferSize.addAndGet(-this.initCap);
        }
        return released;
    }
}

