/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicLong;
import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.buffer.AbstractByteBuf;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.ByteBufAllocator;
import oadd.io.netty.buffer.ByteBufUtil;
import oadd.io.netty.buffer.EmptyByteBuf;
import oadd.io.netty.buffer.UnsafeDirectLittleEndian;
import oadd.io.netty.util.internal.PlatformDependent;
import oadd.org.apache.drill.exec.memory.Accountor;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.ops.BufferManager;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.ops.OperatorContext;
import oadd.org.apache.drill.exec.util.AssertionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DrillBuf
extends AbstractByteBuf
implements AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger(DrillBuf.class);
    private static final boolean BOUNDS_CHECKING_ENABLED = AssertionUtil.BOUNDS_CHECKING_ENABLED;
    private final ByteBuf b;
    private final long addr;
    private final int offset;
    private final boolean rootBuffer;
    private final AtomicLong rootRefCnt = new AtomicLong(1L);
    private volatile BufferAllocator allocator;
    private volatile Accountor acct;
    private volatile int length;
    private OperatorContext context;
    private FragmentContext fContext;
    private BufferManager bufManager;

    public DrillBuf(BufferAllocator allocator, Accountor a, UnsafeDirectLittleEndian b) {
        super(b.maxCapacity());
        this.b = b;
        this.addr = b.memoryAddress();
        this.acct = a;
        this.length = b.capacity();
        this.offset = 0;
        this.rootBuffer = true;
        this.allocator = allocator;
    }

    private DrillBuf(BufferAllocator allocator, Accountor a) {
        super(0);
        this.b = new EmptyByteBuf(allocator.getUnderlyingAllocator()).order(ByteOrder.LITTLE_ENDIAN);
        this.allocator = allocator;
        this.acct = a;
        this.length = 0;
        this.addr = 0L;
        this.rootBuffer = false;
        this.offset = 0;
    }

    public DrillBuf(BufferAllocator allocator, Accountor a, DrillBuf b) {
        this(allocator, a, DrillBuf.getUnderlying(b), b, 0, b.length, true);
        assert (b.unwrap().unwrap() instanceof UnsafeDirectLittleEndian);
        b.unwrap().unwrap().retain();
    }

    private DrillBuf(DrillBuf buffer, int index, int length) {
        this(buffer.allocator, null, buffer, buffer, index, length, false);
    }

    private static ByteBuf getUnderlying(DrillBuf b) {
        ByteBuf underlying = b.unwrap().unwrap();
        return underlying.slice((int)(b.memoryAddress() - underlying.memoryAddress()), b.length);
    }

    private DrillBuf(BufferAllocator allocator, Accountor a, ByteBuf replacement, DrillBuf buffer, int index, int length, boolean root) {
        super(length);
        if (index < 0 || index > buffer.capacity() - length) {
            throw new IndexOutOfBoundsException(buffer.toString() + ".slice(" + index + ", " + length + ')');
        }
        this.length = length;
        this.writerIndex(length);
        this.b = replacement;
        this.addr = buffer.memoryAddress() + (long)index;
        this.offset = index;
        this.acct = a;
        this.length = length;
        this.rootBuffer = root;
        this.allocator = allocator;
    }

    public void setOperatorContext(OperatorContext c) {
        this.context = c;
    }

    public void setFragmentContext(FragmentContext c) {
        this.fContext = c;
    }

    public void setBufferManager(BufferManager bufManager) {
        this.bufManager = bufManager;
    }

    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    public DrillBuf reallocIfNeeded(int size) {
        if (this.capacity() >= size) {
            return this;
        }
        if (this.context != null) {
            return this.context.replace(this, size);
        }
        if (this.fContext != null) {
            return this.fContext.replace(this, size);
        }
        if (this.bufManager != null) {
            return this.bufManager.replace(this, size);
        }
        throw new UnsupportedOperationException("Realloc is only available in the context of an operator's UDFs");
    }

    @Override
    public int refCnt() {
        if (this.rootBuffer) {
            return (int)this.rootRefCnt.get();
        }
        return this.b.refCnt();
    }

    private long addr(int index) {
        return this.addr + (long)index;
    }

    private final void checkIndexD(int index) {
        this.ensureAccessible();
        if (index < 0 || index >= this.capacity()) {
            throw new IndexOutOfBoundsException(String.format("index: %d (expected: range(0, %d))", index, this.capacity()));
        }
    }

    private final void checkIndexD(int index, int fieldLength) {
        this.ensureAccessible();
        if (fieldLength < 0) {
            throw new IllegalArgumentException("length: " + fieldLength + " (expected: >= 0)");
        }
        if (index < 0 || index > this.capacity() - fieldLength) {
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", index, fieldLength, this.capacity()));
        }
    }

    public void checkBytes(int start, int end) {
        if (BOUNDS_CHECKING_ENABLED) {
            this.checkIndexD(start, end - start);
        }
    }

    private void chk(int index, int width) {
        if (BOUNDS_CHECKING_ENABLED) {
            this.checkIndexD(index, width);
        }
    }

    private void chk(int index) {
        if (BOUNDS_CHECKING_ENABLED) {
            this.checkIndexD(index);
        }
    }

    private void ensure(int width) {
        if (BOUNDS_CHECKING_ENABLED) {
            this.ensureWritable(width);
        }
    }

    public boolean transferAccounting(Accountor target) {
        if (this.rootBuffer) {
            boolean outcome = this.acct.transferTo(target, this, this.length);
            this.acct = target;
            return outcome;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean release() {
        return this.release(1);
    }

    @Override
    public synchronized boolean release(int decrement) {
        if (this.rootBuffer) {
            long newRefCnt = this.rootRefCnt.addAndGet(-decrement);
            Preconditions.checkArgument(newRefCnt > -1L, "Buffer has negative reference count.");
            if (newRefCnt == 0L) {
                this.b.release(decrement);
                this.acct.release(this, this.length);
                return true;
            }
            return false;
        }
        return this.b.release(decrement);
    }

    @Override
    public int capacity() {
        return this.length;
    }

    @Override
    public synchronized ByteBuf capacity(int newCapacity) {
        if (this.rootBuffer) {
            if (newCapacity == this.length) {
                return this;
            }
            if (newCapacity < this.length) {
                this.b.capacity(newCapacity);
                int diff = this.length - this.b.capacity();
                this.acct.releasePartial(this, diff);
                this.length -= diff;
                return this;
            }
            throw new UnsupportedOperationException("Accounting byte buf doesn't support increasing allocations.");
        }
        throw new UnsupportedOperationException("Non root bufs doen't support changing allocations.");
    }

    @Override
    public int maxCapacity() {
        return this.length;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.b.alloc();
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    public ByteBuf order(ByteOrder endianness) {
        return this;
    }

    @Override
    public ByteBuf unwrap() {
        return this.b;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public ByteBuf readBytes(int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf readSlice(int length) {
        DrillBuf slice = this.slice(this.readerIndex(), length);
        this.readerIndex(this.readerIndex() + length);
        return slice;
    }

    @Override
    public ByteBuf copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf copy(int index, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf slice() {
        return this.slice(this.readerIndex(), this.readableBytes());
    }

    @Override
    public DrillBuf slice(int index, int length) {
        DrillBuf buf = new DrillBuf(this, index, length);
        buf.writerIndex = length;
        return buf;
    }

    @Override
    public DrillBuf duplicate() {
        return new DrillBuf(this, 0, this.length);
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer nioBuffer() {
        return this.nioBuffer(this.readerIndex(), this.readableBytes());
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        return this.b.nioBuffer(this.offset + index, length);
    }

    @Override
    public ByteBuffer internalNioBuffer(int index, int length) {
        return this.b.internalNioBuffer(this.offset + index, length);
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        return new ByteBuffer[]{this.nioBuffer()};
    }

    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        return new ByteBuffer[]{this.nioBuffer(index, length)};
    }

    @Override
    public boolean hasArray() {
        return this.b.hasArray();
    }

    @Override
    public byte[] array() {
        return this.b.array();
    }

    @Override
    public int arrayOffset() {
        return this.b.arrayOffset();
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        return this.addr;
    }

    @Override
    public String toString(Charset charset) {
        return this.toString(this.readerIndex, this.readableBytes(), charset);
    }

    @Override
    public String toString(int index, int length, Charset charset) {
        ByteBuffer nioBuffer;
        if (length == 0) {
            return "";
        }
        if (this.nioBufferCount() == 1) {
            nioBuffer = this.nioBuffer(index, length);
        } else {
            nioBuffer = ByteBuffer.allocate(length);
            this.getBytes(index, nioBuffer);
            nioBuffer.flip();
        }
        return ByteBufUtil.decodeString(nioBuffer, charset);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public ByteBuf retain(int increment) {
        if (this.rootBuffer) {
            this.rootRefCnt.addAndGet(increment);
        } else {
            this.b.retain(increment);
        }
        return this;
    }

    @Override
    public ByteBuf retain() {
        return this.retain(1);
    }

    @Override
    public long getLong(int index) {
        this.chk(index, 8);
        long v = PlatformDependent.getLong(this.addr(index));
        return v;
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    @Override
    public char getChar(int index) {
        return (char)this.getShort(index);
    }

    @Override
    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    @Override
    public int getInt(int index) {
        this.chk(index, 4);
        int v = PlatformDependent.getInt(this.addr(index));
        return v;
    }

    @Override
    public int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    @Override
    public short getShort(int index) {
        this.chk(index, 2);
        short v = PlatformDependent.getShort(this.addr(index));
        return v;
    }

    @Override
    public ByteBuf setShort(int index, int value) {
        this.chk(index, 2);
        PlatformDependent.putShort(this.addr(index), (short)value);
        return this;
    }

    @Override
    public ByteBuf setInt(int index, int value) {
        this.chk(index, 4);
        PlatformDependent.putInt(this.addr(index), value);
        return this;
    }

    @Override
    public ByteBuf setLong(int index, long value) {
        this.chk(index, 8);
        PlatformDependent.putLong(this.addr(index), value);
        return this;
    }

    @Override
    public ByteBuf setChar(int index, int value) {
        this.chk(index, 2);
        PlatformDependent.putShort(this.addr(index), (short)value);
        return this;
    }

    @Override
    public ByteBuf setFloat(int index, float value) {
        this.chk(index, 4);
        PlatformDependent.putInt(this.addr(index), Float.floatToRawIntBits(value));
        return this;
    }

    @Override
    public ByteBuf setDouble(int index, double value) {
        this.chk(index, 8);
        PlatformDependent.putLong(this.addr(index), Double.doubleToRawLongBits(value));
        return this;
    }

    @Override
    public ByteBuf writeShort(int value) {
        this.ensure(2);
        PlatformDependent.putShort(this.addr(this.writerIndex), (short)value);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public ByteBuf writeInt(int value) {
        this.ensure(4);
        PlatformDependent.putInt(this.addr(this.writerIndex), value);
        this.writerIndex += 4;
        return this;
    }

    @Override
    public ByteBuf writeLong(long value) {
        this.ensure(8);
        PlatformDependent.putLong(this.addr(this.writerIndex), value);
        this.writerIndex += 8;
        return this;
    }

    @Override
    public ByteBuf writeChar(int value) {
        this.ensure(2);
        PlatformDependent.putShort(this.addr(this.writerIndex), (short)value);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public ByteBuf writeFloat(float value) {
        this.ensure(4);
        PlatformDependent.putInt(this.addr(this.writerIndex), Float.floatToRawIntBits(value));
        this.writerIndex += 4;
        return this;
    }

    @Override
    public ByteBuf writeDouble(double value) {
        this.ensure(8);
        PlatformDependent.putLong(this.addr(this.writerIndex), Double.doubleToRawLongBits(value));
        this.writerIndex += 8;
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.b.getBytes(index + this.offset, dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        this.b.getBytes(index + this.offset, dst);
        return this;
    }

    @Override
    public ByteBuf setByte(int index, int value) {
        this.chk(index, 1);
        PlatformDependent.putByte(this.addr(index), (byte)value);
        return this;
    }

    public void setByte(int index, byte b) {
        this.chk(index, 1);
        PlatformDependent.putByte(this.addr(index), b);
    }

    public void writeByteUnsafe(byte b) {
        PlatformDependent.putByte(this.addr(this.readerIndex), b);
        ++this.readerIndex;
    }

    @Override
    protected byte _getByte(int index) {
        return this.getByte(index);
    }

    @Override
    protected short _getShort(int index) {
        return this.getShort(index);
    }

    @Override
    protected int _getInt(int index) {
        return this.getInt(index);
    }

    @Override
    protected long _getLong(int index) {
        return this.getLong(index);
    }

    @Override
    protected void _setByte(int index, int value) {
        this.setByte(index, value);
    }

    @Override
    protected void _setShort(int index, int value) {
        this.setShort(index, value);
    }

    @Override
    protected void _setMedium(int index, int value) {
        this.setMedium(index, value);
    }

    @Override
    protected void _setInt(int index, int value) {
        this.setInt(index, value);
    }

    @Override
    protected void _setLong(int index, long value) {
        this.setLong(index, value);
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.b.getBytes(index + this.offset, dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.b.getBytes(index + this.offset, out, length);
        return this;
    }

    @Override
    protected int _getUnsignedMedium(int index) {
        long addr = this.addr(index);
        return (PlatformDependent.getByte(addr) & 0xFF) << 16 | (PlatformDependent.getByte(addr + 1L) & 0xFF) << 8 | PlatformDependent.getByte(addr + 2L) & 0xFF;
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        return this.b.getBytes(index + this.offset, out, length);
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.b.setBytes(index + this.offset, src, srcIndex, length);
        return this;
    }

    public ByteBuf setBytes(int index, ByteBuffer src, int srcIndex, int length) {
        if (src.isDirect()) {
            this.checkIndex(index, length);
            PlatformDependent.copyMemory(PlatformDependent.directBufferAddress(src) + (long)srcIndex, this.memoryAddress() + (long)index, length);
        } else if (srcIndex == 0 && src.capacity() == length) {
            this.b.setBytes(index + this.offset, src);
        } else {
            ByteBuffer newBuf = src.duplicate();
            newBuf.position(srcIndex);
            newBuf.limit(srcIndex + length);
            this.b.setBytes(index + this.offset, src);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.b.setBytes(index + this.offset, src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        this.b.setBytes(index + this.offset, src);
        return this;
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        return this.b.setBytes(index + this.offset, in, length);
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        return this.b.setBytes(index + this.offset, in, length);
    }

    @Override
    public byte getByte(int index) {
        this.chk(index, 1);
        return PlatformDependent.getByte(this.addr(index));
    }

    public static DrillBuf getEmpty(BufferAllocator allocator, Accountor a) {
        return new DrillBuf(allocator, a);
    }

    public boolean isRootBuffer() {
        return this.rootBuffer;
    }

    @Override
    public void close() {
        this.release();
    }
}

