/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.module.afterburner.ser;

import java.util.logging.Level;
import java.util.logging.Logger;
import oadd.com.fasterxml.jackson.core.JsonGenerator;
import oadd.com.fasterxml.jackson.databind.JsonSerializer;
import oadd.com.fasterxml.jackson.databind.SerializerProvider;
import oadd.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import oadd.com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;

abstract class OptimizedBeanPropertyWriter<T extends OptimizedBeanPropertyWriter<T>>
extends BeanPropertyWriter {
    protected final BeanPropertyAccessor _propertyAccessor;
    protected final int _propertyIndex;
    private final BeanPropertyWriter fallbackWriter;
    private boolean broken = false;

    protected OptimizedBeanPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor propertyAccessor, int propertyIndex, JsonSerializer<Object> ser) {
        super(src);
        this.fallbackWriter = this.unwrapFallbackWriter(src);
        this._serializer = ser;
        this._propertyAccessor = propertyAccessor;
        this._propertyIndex = propertyIndex;
    }

    private BeanPropertyWriter unwrapFallbackWriter(BeanPropertyWriter srcIn) {
        while (srcIn instanceof OptimizedBeanPropertyWriter) {
            srcIn = ((OptimizedBeanPropertyWriter)srcIn).fallbackWriter;
        }
        return srcIn;
    }

    public abstract T withAccessor(BeanPropertyAccessor var1);

    public abstract BeanPropertyWriter withSerializer(JsonSerializer<Object> var1);

    @Override
    public final void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean, jgen, prov);
            return;
        }
        try {
            this.unsafeSerializeAsField(bean, jgen, prov);
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, e);
            this.fallbackWriter.serializeAsField(bean, jgen, prov);
        }
        catch (SecurityException e) {
            this._reportProblem(bean, e);
            this.fallbackWriter.serializeAsField(bean, jgen, prov);
        }
    }

    public abstract void unsafeSerializeAsField(Object var1, JsonGenerator var2, SerializerProvider var3) throws Exception;

    protected void _reportProblem(Object bean, Throwable e) {
        this.broken = true;
        String msg = String.format("Disabling Afterburner serialization for type %s, field #%d, due to access error (type %s, message=%s)%n", bean.getClass(), this._propertyIndex, e.getClass().getName(), e.getMessage());
        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, msg, e);
    }
}

