/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.module.afterburner.ser;

import oadd.com.fasterxml.jackson.core.JsonGenerator;
import oadd.com.fasterxml.jackson.databind.JsonSerializer;
import oadd.com.fasterxml.jackson.databind.SerializerProvider;
import oadd.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import oadd.com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import oadd.com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class LongMethodPropertyWriter
extends OptimizedBeanPropertyWriter<LongMethodPropertyWriter> {
    private final long _suppressableLong;
    private final boolean _suppressableLongSet;

    public LongMethodPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, JsonSerializer<Object> ser) {
        super(src, acc, index, ser);
        if (MARKER_FOR_EMPTY == this._suppressableValue) {
            this._suppressableLong = 0L;
            this._suppressableLongSet = true;
        } else if (this._suppressableValue instanceof Long) {
            this._suppressableLong = (Long)this._suppressableValue;
            this._suppressableLongSet = true;
        } else {
            this._suppressableLong = 0L;
            this._suppressableLongSet = false;
        }
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new LongMethodPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public LongMethodPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new LongMethodPropertyWriter(this, acc, this._propertyIndex, this._serializer);
    }

    @Override
    public void unsafeSerializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        long value = this._propertyAccessor.longGetter(bean, this._propertyIndex);
        if (!this._suppressableLongSet || this._suppressableLong != value) {
            jgen.writeFieldName(this._name);
            jgen.writeNumber(value);
        }
    }
}

