/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.module.afterburner.ser;

import oadd.com.fasterxml.jackson.core.JsonGenerator;
import oadd.com.fasterxml.jackson.databind.JsonSerializer;
import oadd.com.fasterxml.jackson.databind.SerializerProvider;
import oadd.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import oadd.com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import oadd.com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class IntFieldPropertyWriter
extends OptimizedBeanPropertyWriter<IntFieldPropertyWriter> {
    private final int _suppressableInt;
    private final boolean _suppressableIntSet;

    public IntFieldPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, JsonSerializer<Object> ser) {
        super(src, acc, index, ser);
        if (MARKER_FOR_EMPTY == this._suppressableValue) {
            this._suppressableInt = 0;
            this._suppressableIntSet = true;
        } else if (this._suppressableValue instanceof Integer) {
            this._suppressableInt = (Integer)this._suppressableValue;
            this._suppressableIntSet = true;
        } else {
            this._suppressableInt = 0;
            this._suppressableIntSet = false;
        }
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new IntFieldPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public IntFieldPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new IntFieldPropertyWriter(this, acc, this._propertyIndex, this._serializer);
    }

    @Override
    public final void unsafeSerializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        int value = this._propertyAccessor.intField(bean, this._propertyIndex);
        if (!this._suppressableIntSet || this._suppressableInt != value) {
            jgen.writeFieldName(this._name);
            jgen.writeNumber(value);
        }
    }
}

