/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import oadd.com.carrotsearch.hppc.AbstractIterator;
import oadd.com.carrotsearch.hppc.AbstractLongCollection;
import oadd.com.carrotsearch.hppc.AbstractShortCollection;
import oadd.com.carrotsearch.hppc.BitUtil;
import oadd.com.carrotsearch.hppc.Internals;
import oadd.com.carrotsearch.hppc.LongContainer;
import oadd.com.carrotsearch.hppc.ShortContainer;
import oadd.com.carrotsearch.hppc.ShortLongAssociativeContainer;
import oadd.com.carrotsearch.hppc.ShortLongMap;
import oadd.com.carrotsearch.hppc.ShortLookupContainer;
import oadd.com.carrotsearch.hppc.cursors.LongCursor;
import oadd.com.carrotsearch.hppc.cursors.ShortCursor;
import oadd.com.carrotsearch.hppc.cursors.ShortLongCursor;
import oadd.com.carrotsearch.hppc.predicates.LongPredicate;
import oadd.com.carrotsearch.hppc.predicates.ShortPredicate;
import oadd.com.carrotsearch.hppc.procedures.LongProcedure;
import oadd.com.carrotsearch.hppc.procedures.ShortLongProcedure;
import oadd.com.carrotsearch.hppc.procedures.ShortProcedure;

public class ShortLongOpenHashMap
implements ShortLongMap,
Cloneable {
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public short[] keys;
    public long[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;

    public ShortLongOpenHashMap() {
        this(16);
    }

    public ShortLongOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ShortLongOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public ShortLongOpenHashMap(ShortLongAssociativeContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public long put(short key, long value) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                long oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = key;
        this.values[slot] = value;
        return 0L;
    }

    @Override
    public final int putAll(ShortLongAssociativeContainer container) {
        int count = this.assigned;
        for (ShortLongCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    @Override
    public final int putAll(Iterable<? extends ShortLongCursor> iterable) {
        int count = this.assigned;
        for (ShortLongCursor shortLongCursor : iterable) {
            this.put(shortLongCursor.key, shortLongCursor.value);
        }
        return this.assigned - count;
    }

    public final boolean putIfAbsent(short key, long value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    public final long putOrAdd(short key, long putValue, long additionValue) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                int n = slot;
                long l = this.values[n] + additionValue;
                this.values[n] = l;
                return l;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = key;
        long v = this.values[slot] = putValue;
        return v;
    }

    private void expandAndRehash() {
        short[] oldKeys = this.keys;
        long[] oldValues = this.values;
        boolean[] oldStates = this.allocated;
        assert (this.assigned >= this.resizeThreshold);
        this.allocateBuffers(this.nextCapacity(this.keys.length));
        int mask = this.allocated.length - 1;
        for (int i = 0; i < oldStates.length; ++i) {
            if (!oldStates[i]) continue;
            short key = oldKeys[i];
            long value = oldValues[i];
            int slot = Internals.rehash(key) & mask;
            while (this.allocated[slot] && key != this.keys[slot]) {
                slot = slot + 1 & mask;
            }
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value;
        }
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = new short[capacity];
        this.values = new long[capacity];
        this.allocated = new boolean[capacity];
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
    }

    @Override
    public long remove(short key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                long v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            slot = slot + 1 & mask;
        }
        return 0L;
    }

    protected final void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr]) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    @Override
    public final int removeAll(ShortContainer container) {
        int before = this.assigned;
        for (ShortCursor cursor : container) {
            this.remove(cursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public final int removeAll(ShortPredicate predicate) {
        int before = this.assigned;
        short[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public long get(short key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0L;
    }

    public long lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public long lset(long key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        long previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    @Override
    public boolean containsKey(short key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    protected int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (ShortLongCursor c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            ShortLongMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof ShortLongMap && (other = (ShortLongMap)obj).size() == this.size()) {
                for (ShortLongCursor c : this) {
                    long v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<ShortLongCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ShortLongProcedure> T forEach(T procedure) {
        short[] keys = this.keys;
        long[] values = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public LongContainer values() {
        return new ValuesContainer();
    }

    public ShortLongOpenHashMap clone() {
        try {
            ShortLongOpenHashMap cloned = (ShortLongOpenHashMap)super.clone();
            cloned.keys = (short[])this.keys.clone();
            cloned.values = (long[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ShortLongCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static ShortLongOpenHashMap from(short[] keys, long[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortLongOpenHashMap map = new ShortLongOpenHashMap();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static ShortLongOpenHashMap from(ShortLongAssociativeContainer container) {
        return new ShortLongOpenHashMap(container);
    }

    public static ShortLongOpenHashMap newInstance() {
        return new ShortLongOpenHashMap();
    }

    public static ShortLongOpenHashMap newInstance(int initialCapacity, float loadFactor) {
        return new ShortLongOpenHashMap(initialCapacity, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected LongCursor fetch() {
            int i;
            int max = ShortLongOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !ShortLongOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (LongCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ShortLongOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractLongCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return ShortLongOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ShortLongOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(long value) {
            boolean[] allocated = ShortLongOpenHashMap.this.allocated;
            long[] values = ShortLongOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            boolean[] allocated = ShortLongOpenHashMap.this.allocated;
            long[] values = ShortLongOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values[i]);
            }
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            boolean[] allocated = ShortLongOpenHashMap.this.allocated;
            long[] values = ShortLongOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(long e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ShortCursor fetch() {
            int i;
            int max = ShortLongOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !ShortLongOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ShortCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ShortLongOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final ShortLongOpenHashMap owner;

        public KeysContainer() {
            this.owner = ShortLongOpenHashMap.this;
        }

        @Override
        public boolean contains(short e) {
            return ShortLongOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            short[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            short[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(short e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<ShortLongCursor> {
        private final ShortLongCursor cursor = new ShortLongCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ShortLongCursor fetch() {
            int i;
            int max = ShortLongOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !ShortLongOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ShortLongCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = ShortLongOpenHashMap.this.keys[i];
            this.cursor.value = ShortLongOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

