/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import oadd.com.carrotsearch.hppc.AbstractFloatCollection;
import oadd.com.carrotsearch.hppc.AbstractIterator;
import oadd.com.carrotsearch.hppc.AbstractObjectCollection;
import oadd.com.carrotsearch.hppc.BitUtil;
import oadd.com.carrotsearch.hppc.FloatContainer;
import oadd.com.carrotsearch.hppc.FloatLookupContainer;
import oadd.com.carrotsearch.hppc.FloatObjectAssociativeContainer;
import oadd.com.carrotsearch.hppc.FloatObjectMap;
import oadd.com.carrotsearch.hppc.Internals;
import oadd.com.carrotsearch.hppc.ObjectContainer;
import oadd.com.carrotsearch.hppc.cursors.FloatCursor;
import oadd.com.carrotsearch.hppc.cursors.FloatObjectCursor;
import oadd.com.carrotsearch.hppc.cursors.ObjectCursor;
import oadd.com.carrotsearch.hppc.predicates.FloatPredicate;
import oadd.com.carrotsearch.hppc.predicates.ObjectPredicate;
import oadd.com.carrotsearch.hppc.procedures.FloatObjectProcedure;
import oadd.com.carrotsearch.hppc.procedures.FloatProcedure;
import oadd.com.carrotsearch.hppc.procedures.ObjectProcedure;

public class FloatObjectOpenHashMap<VType>
implements FloatObjectMap<VType>,
Cloneable {
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public float[] keys;
    public VType[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;

    public FloatObjectOpenHashMap() {
        this(16);
    }

    public FloatObjectOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public FloatObjectOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public FloatObjectOpenHashMap(FloatObjectAssociativeContainer<VType> container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public VType put(float key, VType value) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                VType oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = key;
        this.values[slot] = value;
        return null;
    }

    @Override
    public final int putAll(FloatObjectAssociativeContainer<? extends VType> container) {
        int count = this.assigned;
        for (FloatObjectCursor<VType> floatObjectCursor : container) {
            this.put(floatObjectCursor.key, floatObjectCursor.value);
        }
        return this.assigned - count;
    }

    @Override
    public final int putAll(Iterable<? extends FloatObjectCursor<? extends VType>> iterable) {
        int count = this.assigned;
        for (FloatObjectCursor<VType> floatObjectCursor : iterable) {
            this.put(floatObjectCursor.key, floatObjectCursor.value);
        }
        return this.assigned - count;
    }

    public final boolean putIfAbsent(float key, VType value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    private void expandAndRehash() {
        float[] oldKeys = this.keys;
        VType[] oldValues = this.values;
        boolean[] oldStates = this.allocated;
        assert (this.assigned >= this.resizeThreshold);
        this.allocateBuffers(this.nextCapacity(this.keys.length));
        int mask = this.allocated.length - 1;
        for (int i = 0; i < oldStates.length; ++i) {
            if (!oldStates[i]) continue;
            float key = oldKeys[i];
            VType value = oldValues[i];
            oldValues[i] = null;
            int slot = Internals.rehash(key) & mask;
            while (this.allocated[slot] && key != this.keys[slot]) {
                slot = slot + 1 & mask;
            }
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value;
        }
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = new float[capacity];
        this.values = (Object[])Internals.newArray(capacity);
        this.allocated = new boolean[capacity];
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
    }

    @Override
    public VType remove(float key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                VType v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    protected final void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr]) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
        this.values[slotPrev] = null;
    }

    @Override
    public final int removeAll(FloatContainer container) {
        int before = this.assigned;
        for (FloatCursor cursor : container) {
            this.remove(cursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public final int removeAll(FloatPredicate predicate) {
        int before = this.assigned;
        float[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public VType get(float key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    public VType lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public VType lset(VType key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        VType previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    @Override
    public boolean containsKey(float key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    protected int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
        Arrays.fill(this.values, null);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (FloatObjectCursor<VType> c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            FloatObjectMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof FloatObjectMap && (other = (FloatObjectMap)obj).size() == this.size()) {
                for (FloatObjectCursor<VType> c : this) {
                    if (other.containsKey(c.key)) {
                        Object v = other.get(c.key);
                        if (c.value == null ? v == null : c.value.equals(v)) continue;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<FloatObjectCursor<VType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends FloatObjectProcedure<? super VType>> T forEach(T procedure) {
        float[] keys = this.keys;
        VType[] values = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ObjectContainer<VType> values() {
        return new ValuesContainer();
    }

    public FloatObjectOpenHashMap<VType> clone() {
        try {
            FloatObjectOpenHashMap cloned = (FloatObjectOpenHashMap)super.clone();
            cloned.keys = (float[])this.keys.clone();
            cloned.values = (Object[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (FloatObjectCursor<VType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static <VType> FloatObjectOpenHashMap<VType> from(float[] keys, VType[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        FloatObjectOpenHashMap<VType> map = new FloatObjectOpenHashMap<VType>();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <VType> FloatObjectOpenHashMap<VType> from(FloatObjectAssociativeContainer<VType> container) {
        return new FloatObjectOpenHashMap<VType>(container);
    }

    public static <VType> FloatObjectOpenHashMap<VType> newInstance() {
        return new FloatObjectOpenHashMap<VType>();
    }

    public static <VType> FloatObjectOpenHashMap<VType> newInstance(int initialCapacity, float loadFactor) {
        return new FloatObjectOpenHashMap<VType>(initialCapacity, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor = new ObjectCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            int i;
            int max = FloatObjectOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !FloatObjectOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = FloatObjectOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractObjectCollection<VType> {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return FloatObjectOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return FloatObjectOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(VType value) {
            boolean[] allocated = FloatObjectOpenHashMap.this.allocated;
            VType[] values = FloatObjectOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || !(value == null ? values[slot] == null : value.equals(values[slot]))) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T procedure) {
            boolean[] allocated = FloatObjectOpenHashMap.this.allocated;
            VType[] values = FloatObjectOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values[i]);
            }
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T predicate) {
            boolean[] allocated = FloatObjectOpenHashMap.this.allocated;
            VType[] values = FloatObjectOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(VType e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(ObjectPredicate<? super VType> predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected FloatCursor fetch() {
            int i;
            int max = FloatObjectOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !FloatObjectOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (FloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = FloatObjectOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractFloatCollection
    implements FloatLookupContainer {
        private final FloatObjectOpenHashMap<VType> owner;

        public KeysContainer() {
            this.owner = FloatObjectOpenHashMap.this;
        }

        @Override
        public boolean contains(float e) {
            return FloatObjectOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            float[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            float[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(float e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<FloatObjectCursor<VType>> {
        private final FloatObjectCursor<VType> cursor = new FloatObjectCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected FloatObjectCursor<VType> fetch() {
            int i;
            int max = FloatObjectOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !FloatObjectOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (FloatObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = FloatObjectOpenHashMap.this.keys[i];
            this.cursor.value = FloatObjectOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

