/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import oadd.com.carrotsearch.hppc.AbstractCharCollection;
import oadd.com.carrotsearch.hppc.AbstractFloatCollection;
import oadd.com.carrotsearch.hppc.AbstractIterator;
import oadd.com.carrotsearch.hppc.BitUtil;
import oadd.com.carrotsearch.hppc.CharContainer;
import oadd.com.carrotsearch.hppc.CharFloatAssociativeContainer;
import oadd.com.carrotsearch.hppc.CharFloatMap;
import oadd.com.carrotsearch.hppc.CharLookupContainer;
import oadd.com.carrotsearch.hppc.FloatContainer;
import oadd.com.carrotsearch.hppc.Internals;
import oadd.com.carrotsearch.hppc.cursors.CharCursor;
import oadd.com.carrotsearch.hppc.cursors.CharFloatCursor;
import oadd.com.carrotsearch.hppc.cursors.FloatCursor;
import oadd.com.carrotsearch.hppc.predicates.CharPredicate;
import oadd.com.carrotsearch.hppc.predicates.FloatPredicate;
import oadd.com.carrotsearch.hppc.procedures.CharFloatProcedure;
import oadd.com.carrotsearch.hppc.procedures.CharProcedure;
import oadd.com.carrotsearch.hppc.procedures.FloatProcedure;

public class CharFloatOpenHashMap
implements CharFloatMap,
Cloneable {
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public char[] keys;
    public float[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;

    public CharFloatOpenHashMap() {
        this(16);
    }

    public CharFloatOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CharFloatOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public CharFloatOpenHashMap(CharFloatAssociativeContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public float put(char key, float value) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                float oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = key;
        this.values[slot] = value;
        return 0.0f;
    }

    @Override
    public final int putAll(CharFloatAssociativeContainer container) {
        int count = this.assigned;
        for (CharFloatCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    @Override
    public final int putAll(Iterable<? extends CharFloatCursor> iterable) {
        int count = this.assigned;
        for (CharFloatCursor charFloatCursor : iterable) {
            this.put(charFloatCursor.key, charFloatCursor.value);
        }
        return this.assigned - count;
    }

    public final boolean putIfAbsent(char key, float value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    public final float putOrAdd(char key, float putValue, float additionValue) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                int n = slot;
                float f = this.values[n] + additionValue;
                this.values[n] = f;
                return f;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = key;
        float v = this.values[slot] = putValue;
        return v;
    }

    private void expandAndRehash() {
        char[] oldKeys = this.keys;
        float[] oldValues = this.values;
        boolean[] oldStates = this.allocated;
        assert (this.assigned >= this.resizeThreshold);
        this.allocateBuffers(this.nextCapacity(this.keys.length));
        int mask = this.allocated.length - 1;
        for (int i = 0; i < oldStates.length; ++i) {
            if (!oldStates[i]) continue;
            char key = oldKeys[i];
            float value = oldValues[i];
            int slot = Internals.rehash(key) & mask;
            while (this.allocated[slot] && key != this.keys[slot]) {
                slot = slot + 1 & mask;
            }
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value;
        }
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = new char[capacity];
        this.values = new float[capacity];
        this.allocated = new boolean[capacity];
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
    }

    @Override
    public float remove(char key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                float v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            slot = slot + 1 & mask;
        }
        return 0.0f;
    }

    protected final void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr]) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    @Override
    public final int removeAll(CharContainer container) {
        int before = this.assigned;
        for (CharCursor cursor : container) {
            this.remove(cursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public final int removeAll(CharPredicate predicate) {
        int before = this.assigned;
        char[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public float get(char key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0.0f;
    }

    public float lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public float lset(float key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        float previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    @Override
    public boolean containsKey(char key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    protected int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (CharFloatCursor c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            CharFloatMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof CharFloatMap && (other = (CharFloatMap)obj).size() == this.size()) {
                for (CharFloatCursor c : this) {
                    float v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<CharFloatCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends CharFloatProcedure> T forEach(T procedure) {
        char[] keys = this.keys;
        float[] values = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public FloatContainer values() {
        return new ValuesContainer();
    }

    public CharFloatOpenHashMap clone() {
        try {
            CharFloatOpenHashMap cloned = (CharFloatOpenHashMap)super.clone();
            cloned.keys = (char[])this.keys.clone();
            cloned.values = (float[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (CharFloatCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static CharFloatOpenHashMap from(char[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharFloatOpenHashMap map = new CharFloatOpenHashMap();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static CharFloatOpenHashMap from(CharFloatAssociativeContainer container) {
        return new CharFloatOpenHashMap(container);
    }

    public static CharFloatOpenHashMap newInstance() {
        return new CharFloatOpenHashMap();
    }

    public static CharFloatOpenHashMap newInstance(int initialCapacity, float loadFactor) {
        return new CharFloatOpenHashMap(initialCapacity, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected FloatCursor fetch() {
            int i;
            int max = CharFloatOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !CharFloatOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (FloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = CharFloatOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractFloatCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return CharFloatOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CharFloatOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(float value) {
            boolean[] allocated = CharFloatOpenHashMap.this.allocated;
            float[] values = CharFloatOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            boolean[] allocated = CharFloatOpenHashMap.this.allocated;
            float[] values = CharFloatOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values[i]);
            }
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            boolean[] allocated = CharFloatOpenHashMap.this.allocated;
            float[] values = CharFloatOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(float e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected CharCursor fetch() {
            int i;
            int max = CharFloatOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !CharFloatOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (CharCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = CharFloatOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharFloatOpenHashMap owner;

        public KeysContainer() {
            this.owner = CharFloatOpenHashMap.this;
        }

        @Override
        public boolean contains(char e) {
            return CharFloatOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            char[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            char[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(char e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<CharFloatCursor> {
        private final CharFloatCursor cursor = new CharFloatCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected CharFloatCursor fetch() {
            int i;
            int max = CharFloatOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !CharFloatOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (CharFloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = CharFloatOpenHashMap.this.keys[i];
            this.cursor.value = CharFloatOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

