/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.carrotsearch.hppc;

import java.util.Arrays;
import oadd.com.carrotsearch.hppc.ByteCollection;
import oadd.com.carrotsearch.hppc.ByteLookupContainer;
import oadd.com.carrotsearch.hppc.cursors.ByteCursor;
import oadd.com.carrotsearch.hppc.predicates.BytePredicate;

abstract class AbstractByteCollection
implements ByteCollection {
    AbstractByteCollection() {
    }

    @Override
    public int removeAll(ByteLookupContainer c) {
        final ByteLookupContainer c2 = c;
        return this.removeAll(new BytePredicate(){

            @Override
            public boolean apply(byte k) {
                return c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(ByteLookupContainer c) {
        final ByteLookupContainer c2 = c;
        return this.removeAll(new BytePredicate(){

            @Override
            public boolean apply(byte k) {
                return !c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final BytePredicate predicate) {
        return this.removeAll(new BytePredicate(){

            @Override
            public boolean apply(byte value) {
                return !predicate.apply(value);
            }
        });
    }

    @Override
    public byte[] toArray() {
        int size = this.size();
        byte[] array = new byte[size];
        int i = 0;
        for (ByteCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

