/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security.maprsasl;

import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.proto.Security;
import com.mapr.login.client.MapRLoginHttpsClient;
import com.mapr.security.JNISecurity;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import com.mapr.security.maprsasl.MaprSaslServer;
import com.mapr.security.maprsasl.MaprSecurityLoginModule;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import oadd.com.google.protobuf.ByteString;
import oadd.com.google.protobuf.InvalidProtocolBufferException;
import oadd.org.apache.commons.codec.binary.Base64;
import oadd.org.apache.log4j.Logger;

public class MaprSaslClient
implements SaslClient {
    private static final Logger LOG = Logger.getLogger(MaprSaslClient.class);
    private static final Integer MAX_BUF_SIZE_FOR_WRAP = new Integer(65536);
    private boolean completed;
    private boolean firstPassDone;
    private CallbackHandler cbh;
    private long randomSecret;
    private String authorizationId;
    private String authenticationId;
    private Security.Key sessionKey;
    private Security.Key userKey;
    private String negotiatedQOPProperty;
    private String localqopProperty;

    public MaprSaslClient(Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        this.cbh = cbh;
        if (props == null || props.isEmpty()) {
            this.localqopProperty = MaprSaslServer.QOP.AUTHENTICATION.getQopString();
        } else {
            for (Map.Entry<String, ?> entry : props.entrySet()) {
                Object valueO;
                String key = entry.getKey();
                if (!key.equals("javax.security.sasl.qop") || !((valueO = entry.getValue()) instanceof String)) continue;
                this.localqopProperty = (String)entry.getValue();
            }
        }
    }

    @Override
    public void dispose() throws SaslException {
        this.sessionKey = null;
        this.randomSecret = -1L;
        this.authorizationId = null;
        this.authenticationId = null;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("MaprSasl authentication already completed");
        }
        if (!this.firstPassDone) {
            try {
                MutableInt err = new MutableInt();
                MapRLoginHttpsClient client = new MapRLoginHttpsClient();
                Security.TicketAndKey ticketKey = null;
                if (MaprSecurityLoginModule.isUseMaprServerTicket()) {
                    String currentClusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
                    ticketKey = Security.GetTicketAndKeyForCluster(Security.ServerKeyType.CldbKey, currentClusterName, err);
                } else {
                    ticketKey = client.authenticateIfNeeded();
                }
                if (ticketKey == null) {
                    throw new SaslException("ServerTicketKey was not set");
                }
                long ticketExpTime = ticketKey.getExpiryTime() * 1000L;
                if (ticketExpTime < System.currentTimeMillis()) {
                    throw new SaslException("MaprSaslClient My ticket Expired");
                }
                this.userKey = ticketKey.getUserKey();
                this.randomSecret = JNISecurity.GenerateRandomNumber();
                byte[] writeBuffer = new byte[]{(byte)(this.randomSecret >>> 56), (byte)(this.randomSecret >>> 48), (byte)(this.randomSecret >>> 40), (byte)(this.randomSecret >>> 32), (byte)(this.randomSecret >>> 24), (byte)(this.randomSecret >>> 16), (byte)(this.randomSecret >>> 8), (byte)(this.randomSecret >>> 0)};
                Security.AuthenticationReqFull.Builder bld = Security.AuthenticationReqFull.newBuilder();
                byte[] secretBytesEncrypted = Security.Encrypt(this.userKey, writeBuffer, err);
                if (err.GetValue() != 0) {
                    throw new SaslException("Error while encrypting data: " + err.GetValue());
                }
                bld.setEncryptedRandomSecret(ByteString.copyFrom(secretBytesEncrypted));
                bld.setEncryptedTicket(ticketKey.getEncryptedTicket());
                byte[] authRequestBytes = bld.build().toByteArray();
                authRequestBytes = Base64.encodeBase64(authRequestBytes);
                this.firstPassDone = true;
                return authRequestBytes;
            }
            catch (Throwable t) {
                if (t instanceof SaslException) {
                    throw (SaslException)t;
                }
                LOG.error((Object)"Exception while processing ticket data", t);
                throw new SaslException("Exception while processing ticket data", t);
            }
        }
        if (challenge == null || challenge.length < 1) {
            throw new SaslException("Received challenge is empty when secret expected");
        }
        if (this.userKey == null) {
            throw new SaslException("Bad userKey");
        }
        try {
            int status;
            MutableInt err = new MutableInt();
            challenge = Base64.decodeBase64(challenge);
            byte[] decodedResponse = Security.Decrypt(this.userKey, challenge, err);
            if (err.GetValue() != 0) {
                throw new SaslException("Error while decrypting data: " + err.GetValue());
            }
            Security.AuthenticationResp authResponse = null;
            try {
                authResponse = Security.AuthenticationResp.parseFrom(decodedResponse);
            }
            catch (InvalidProtocolBufferException e) {
                throw new SaslException("Can not parse out the data from server response", e);
            }
            if (authResponse != null && (status = authResponse.getStatus()) == 0) {
                if (authResponse.hasChallengeResponse()) {
                    long respLong = authResponse.getChallengeResponse();
                    if (this.randomSecret != respLong) {
                        throw new SaslException("Bad returned secret");
                    }
                } else {
                    throw new SaslException("No returned secret");
                }
                if (authResponse.hasEncodingType()) {
                    int qopInt = authResponse.getEncodingType();
                    String interimQOPOption = MaprSaslServer.QOP.getStringFromQOPInt(qopInt);
                    if (interimQOPOption != null) {
                        if (!interimQOPOption.equals(this.localqopProperty)) {
                            LOG.warn((Object)("SASL Server qopProperty: " + interimQOPOption + "is different from Client: " + this.localqopProperty + ".Using Server one"));
                        }
                        this.negotiatedQOPProperty = interimQOPOption;
                    }
                } else {
                    throw new SaslException("No server QOP in response");
                }
                if (!MaprSaslServer.QOP.AUTHENTICATION.getQopString().equals(this.negotiatedQOPProperty)) {
                    this.sessionKey = authResponse.getSessionKey();
                    if (this.sessionKey == null) {
                        throw new SaslException("Bad returned sessionKey");
                    }
                }
                this.completed = true;
                return new byte[0];
            }
            throw new SaslException("Bad response");
        }
        catch (Throwable t) {
            if (t instanceof SaslException) {
                throw (SaslException)t;
            }
            LOG.error((Object)"Exception while processing ticket data", t);
            throw new SaslException("Exception while processing ticket data", t);
        }
    }

    @Override
    public String getMechanismName() {
        return "MAPR-SECURITY";
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (this.completed) {
            if ("javax.security.sasl.qop".equals(propName)) {
                return this.negotiatedQOPProperty;
            }
            if ("javax.security.sasl.rawsendsize".equals(propName)) {
                return MAX_BUF_SIZE_FOR_WRAP.toString();
            }
            throw new IllegalStateException("MAPR-SECURITY does not support any property except javax.security.sasl.qop and javax.security.sasl.rawsendsize");
        }
        throw new IllegalStateException("MAPR-SECURITY authentication not completed");
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        byte[] keyBytes = new byte[len];
        System.arraycopy(incoming, offset, keyBytes, 0, len);
        MutableInt err = new MutableInt();
        byte[] decrypted = Security.Decrypt(this.sessionKey, keyBytes, err);
        return decrypted;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        byte[] keyBytes = new byte[len];
        System.arraycopy(outgoing, offset, keyBytes, 0, len);
        MutableInt err = new MutableInt();
        byte[] encrypted = Security.Encrypt(this.sessionKey, keyBytes, err);
        return encrypted;
    }

    public static class SaslMaprClientFactory
    implements SaslClientFactory {
        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return new String[]{"MAPR-SECURITY"};
        }

        @Override
        public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            if (mechanisms != null) {
                for (String mechanism : mechanisms) {
                    if (!"MAPR-SECURITY".equals(mechanism)) continue;
                    return new MaprSaslClient(props, cbh);
                }
            }
            return null;
        }
    }
}

