/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security.maprauth;

import com.mapr.baseutils.JVMProperties;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.proto.Security;
import com.mapr.login.client.MapRLoginHttpsClient;
import com.mapr.security.JNISecurity;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import oadd.com.google.protobuf.ByteString;
import oadd.org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.authentication.client.PseudoAuthenticator;

public class MaprAuthenticator
implements Authenticator {
    public static final String WWW_ERR_AUTHENTICATE = "WWW-MAPR-Err-Authenticate";
    public static final String NEGOTIATE = "MAPR-Negotiate";
    private HttpURLConnection conn;
    private URL url;
    private Security.Key userkey;
    private ConnectionConfigurator connConfigurator;

    @Override
    public void authenticate(URL url, AuthenticatedURL.Token token) throws IOException, AuthenticationException {
        JVMProperties.init();
        this.url = url;
        this.conn = (HttpURLConnection)url.openConnection();
        if (this.connConfigurator != null) {
            this.conn = this.connConfigurator.configure(this.conn);
        }
        this.conn.setRequestMethod("OPTIONS");
        this.conn.connect();
        if (this.isNegotiate()) {
            ShimLoader.load();
            this.doMaprHandshake(token);
        } else {
            this.getFallbackAuthenticator().authenticate(url, token);
        }
    }

    @Override
    public void setConnectionConfigurator(ConnectionConfigurator configurator) {
        this.connConfigurator = configurator;
    }

    private void doMaprHandshake(AuthenticatedURL.Token token) throws IOException, AuthenticationException {
        try {
            MapRLoginHttpsClient client = new MapRLoginHttpsClient();
            Security.TicketAndKey ticketKey = client.authenticateIfNeeded();
            if (ticketKey == null) {
                throw new AuthenticationException("ServerTicketKey was not set");
            }
            MutableInt err = new MutableInt();
            this.userkey = ticketKey.getUserKey();
            long randomSecret = JNISecurity.GenerateRandomNumber();
            randomSecret = Math.abs(randomSecret);
            byte[] writeBuffer = new byte[]{(byte)(randomSecret >>> 56), (byte)(randomSecret >>> 48), (byte)(randomSecret >>> 40), (byte)(randomSecret >>> 32), (byte)(randomSecret >>> 24), (byte)(randomSecret >>> 16), (byte)(randomSecret >>> 8), (byte)(randomSecret >>> 0)};
            Security.AuthenticationReqFull.Builder bld = Security.AuthenticationReqFull.newBuilder();
            byte[] secretBytesEncrypted = Security.Encrypt(this.userkey, writeBuffer, err);
            if (err.GetValue() != 0) {
                throw new AuthenticationException("Error while encrypting data: " + err.GetValue());
            }
            bld.setEncryptedRandomSecret(ByteString.copyFrom(secretBytesEncrypted));
            bld.setEncryptedTicket(ticketKey.getEncryptedTicket());
            byte[] authRequestBytes = bld.build().toByteArray();
            this.sendBytes(authRequestBytes);
            Security.AuthenticationResp authResponse = this.readResponse();
            if (authResponse.hasChallengeResponse()) {
                long responseSecret = authResponse.getChallengeResponse();
                if (responseSecret != randomSecret + 1L) {
                    throw new AuthenticationException("Incorrect challenge response");
                }
            } else {
                throw new AuthenticationException("No response secret");
            }
            AuthenticatedURL.extractToken(this.conn, token);
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (t instanceof AuthenticationException) {
                throw (AuthenticationException)t;
            }
            throw new AuthenticationException("Exception while getting ticket and key", t);
        }
    }

    private void sendToken(String authorizationToken) throws IOException, AuthenticationException {
        this.conn = (HttpURLConnection)this.url.openConnection();
        this.conn.setRequestMethod("OPTIONS");
        this.conn.setRequestProperty("Authorization", "MAPR-Negotiate " + authorizationToken);
        this.conn.connect();
    }

    private void sendBytes(byte[] authRequestBytes) throws IOException, AuthenticationException {
        Base64 base64 = new Base64(0);
        String token = base64.encodeToString(authRequestBytes);
        this.sendToken(token);
    }

    private Security.AuthenticationResp readResponse() throws IOException, AuthenticationException {
        int status = this.conn.getResponseCode();
        String authorizationError = this.conn.getHeaderField(WWW_ERR_AUTHENTICATE);
        if (authorizationError != null) {
            String err = authorizationError.trim();
            throw new AuthenticationException("Exception in server: " + err);
        }
        if (status == 200) {
            String authHeader = null;
            Map<String, List<String>> headers = this.conn.getHeaderFields();
            List<String> wwwAuthHeaders = headers.get("Authorization");
            if (wwwAuthHeaders == null) {
                throw new AuthenticationException("No header : Authorization is present");
            }
            for (String header : wwwAuthHeaders) {
                if (header == null || !header.trim().startsWith(NEGOTIATE)) continue;
                authHeader = header;
            }
            if (authHeader == null) {
                throw new AuthenticationException("Invalid sequence, incorrect header" + wwwAuthHeaders);
            }
            String negotiation = authHeader.trim().substring("MAPR-Negotiate ".length()).trim();
            Base64 base64 = new Base64(0);
            byte[] base64Bytes = base64.decode(negotiation);
            MutableInt err = new MutableInt();
            byte[] decodedResponse = Security.Decrypt(this.userkey, base64Bytes, err);
            if (err.GetValue() != 0) {
                throw new AuthenticationException("Error while decrypting response " + err.GetValue());
            }
            Security.AuthenticationResp authResponse = null;
            authResponse = Security.AuthenticationResp.parseFrom(decodedResponse);
            if (authResponse == null) {
                throw new AuthenticationException("Response is null");
            }
            return authResponse;
        }
        throw new AuthenticationException("Incorrect status" + status);
    }

    private Authenticator getFallbackAuthenticator() {
        return new PseudoAuthenticator();
    }

    private boolean isNegotiate() throws IOException {
        Map<String, List<String>> headers;
        List<String> wwwAuthHeaders;
        boolean negotiate = false;
        if (this.conn.getResponseCode() == 401 && (wwwAuthHeaders = (headers = this.conn.getHeaderFields()).get("WWW-Authenticate")) != null) {
            for (String authHeader : wwwAuthHeaders) {
                if (authHeader == null || !authHeader.trim().startsWith(NEGOTIATE)) continue;
                return true;
            }
        }
        return negotiate;
    }
}

