/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.jni;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MapRUserGroupInfo {
    private static volatile Method getCurrentUser = null;
    private static volatile Method getShortName = null;
    private static volatile Method getLoginUser = null;
    private static boolean haveMethodIDs = false;

    public static String getCurrentUserName() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        String userName = null;
        if (!haveMethodIDs) {
            MapRUserGroupInfo.GetMethodIDs();
        }
        Object currentUser = getCurrentUser.invoke(null, new Object[0]);
        userName = (String)getShortName.invoke(currentUser, new Object[0]);
        return userName;
    }

    public static String getLoginUserName() throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String userName = null;
        if (!haveMethodIDs) {
            MapRUserGroupInfo.GetMethodIDs();
        }
        Object loginUser = getLoginUser.invoke(null, new Object[0]);
        userName = (String)getShortName.invoke(loginUser, new Object[0]);
        return userName;
    }

    private static void GetMethodIDs() throws SecurityException, NoSuchMethodException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> UGIClass = Class.forName("org.apache.hadoop.security.UserGroupInformation", true, cl);
            if (getCurrentUser == null) {
                getCurrentUser = UGIClass.getMethod("getCurrentUser", new Class[0]);
            }
            if (getShortName == null) {
                getShortName = UGIClass.getMethod("getShortUserName", new Class[0]);
            }
            if (getLoginUser == null) {
                getLoginUser = UGIClass.getMethod("getLoginUser", new Class[0]);
            }
            if (getCurrentUser != null && getShortName != null && getLoginUser != null) {
                haveMethodIDs = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

