/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.baseutils.threadpool.TimeStampedRunnableTask;
import com.mapr.fs.RpcCallContext;
import com.mapr.fs.RpcExport;
import com.mapr.fs.RpcProgram;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.ThreadPoolFinder;
import com.mapr.fs.jni.RpcNative;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import oadd.com.google.protobuf.MessageLite;

public class Rpc
extends RpcNative {
    static RpcExport[] progTab_;
    static int port_;
    static ThreadPoolFinder poolFinder_;

    public static int initialize(int port, int numThreads, String clusterName) throws Exception {
        return Rpc.initialize(port, numThreads, clusterName, null, null);
    }

    public static int initialize(int port, int numThreads, String clusterName, RpcExport[] exports, ThreadPoolFinder thrPool) throws Exception {
        if (progTab_ == null) {
            int numExports = 4;
            if (exports == null) {
                port_ = Rpc.init(port, clusterName);
            } else {
                int numPrograms = exports.length;
                numExports += numPrograms;
                int[] ids = new int[numPrograms];
                for (int i = 0; i < numPrograms; ++i) {
                    ids[i] = exports[i].getProgramId();
                }
                port_ = Rpc.initAndExport(port, clusterName, ids);
            }
            if (port_ < 0) {
                return port_;
            }
            progTab_ = new RpcExport[numExports];
            if (exports != null) {
                int i = 0;
                for (RpcExport e : exports) {
                    Rpc.progTab_[i] = new RpcExport(e.getProgramId(), e.getProgram());
                    ++i;
                }
            }
            ExecutorService threadPool = null;
            if (thrPool == null) {
                threadPool = Executors.newCachedThreadPool();
            } else {
                Rpc.setThreadPoolFinder(thrPool);
            }
            RpcListenerThread t = new RpcListenerThread();
            t.setThreadPool(threadPool);
            t.setDaemon(true);
            t.start();
        }
        return port_;
    }

    public static byte[] sendRequest(long binding, int programId, int procedureId, MessageLite request) throws Exception {
        byte[] serializedReq = request.toByteArray();
        return Rpc.sendRequest(binding, programId, procedureId, serializedReq);
    }

    public static void exportProgram(int programId, RpcProgram program) throws Exception {
        for (int i = 0; i < progTab_.length; ++i) {
            if (progTab_[i] != null) continue;
            Rpc.progTab_[i] = new RpcExport(programId, program);
            break;
        }
        Rpc.registerProgramId(programId);
    }

    public static void sendReply(RpcCallContext c, MessageLite reply) throws Exception {
        byte[] serReply = reply.toByteArray();
        Rpc.sendReply(c.binding, c.context, serReply);
    }

    public static void rejectCall(RpcCallContext c) throws Exception {
        Rpc.rejectCall(c.binding, c.context);
    }

    public static void closeBinding(RpcCallContext c) throws Exception {
        Rpc.closeBinding(c.binding);
    }

    public static void setThreadPoolFinder(ThreadPoolFinder finder) {
        poolFinder_ = finder;
    }

    static RpcProgram findExported(int programId) {
        for (RpcExport p : progTab_) {
            if (p == null) {
                return null;
            }
            if (p.programId != programId) continue;
            return p.program;
        }
        return null;
    }

    static {
        ShimLoader.load();
    }

    static class RpcListenerThread
    extends Thread {
        ExecutorService threadPool;

        RpcListenerThread() {
        }

        public void setThreadPool(ExecutorService pool) {
            this.threadPool = pool;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        RpcCallContext c = new RpcCallContext();
                        byte[] req = Rpc.waitForRequest(c);
                        RpcProgram p = Rpc.findExported(c.programId);
                        if (p == null) continue;
                        RpcExecutor rpc = new RpcExecutor(p, c, req);
                        ExecutorService pool = this.threadPool;
                        if (poolFinder_ != null) {
                            pool = poolFinder_.getThreadPool(c);
                        }
                        pool.execute(rpc);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                catch (OutOfMemoryError oom) {
                    oom.printStackTrace();
                    System.exit(0);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.exit(0);
                    continue;
                }
                break;
            }
        }
    }

    static class RpcExecutor
    implements TimeStampedRunnableTask {
        RpcProgram prog;
        RpcCallContext ctx;
        byte[] req;

        RpcExecutor(RpcProgram p, RpcCallContext c, byte[] r) {
            this.prog = p;
            this.ctx = c;
            this.req = r;
            this.ctx.arrTime = System.currentTimeMillis();
        }

        @Override
        public long arrTime() {
            return this.ctx.arrTime;
        }

        @Override
        public void run() {
            this.prog.requestArrived(this.ctx, this.req);
        }
    }
}

