/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.proto.Dbserver;
import java.io.IOException;
import java.util.List;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;

public class MapRTabletScanner {
    private static final Log LOG = LogFactory.getLog(MapRTabletScanner.class);
    private static final byte[] EMPTY_KEY = new byte[0];
    private Path tablePath;
    private Dbserver.TabletLookupResponse lookupResp;
    private MapRFileSystem fs_;
    private int size;
    private int idx;

    public MapRTabletScanner(MapRFileSystem fs, Path tableURI, byte[] startKey) throws IOException {
        this.tablePath = tableURI;
        this.fs_ = fs;
        this.idx = 0;
        this.lookupResp = this.fs_.getTablets(this.tablePath, startKey);
        this.size = this.lookupResp.getDescCount();
    }

    public MapRTabletScanner(MapRFileSystem fs, Path tableURI) throws IOException {
        this.tablePath = tableURI;
        this.fs_ = fs;
        this.idx = 0;
        this.lookupResp = this.fs_.getTablets(this.tablePath, EMPTY_KEY);
        this.size = this.lookupResp.getDescCount();
    }

    private boolean isEndKey(byte[] key) {
        return key == null || key.length == 0;
    }

    public Dbserver.TabletDesc next() throws IOException {
        if (this.idx >= this.size) {
            if (this.size == 0) {
                return null;
            }
            byte[] lastKey = this.lookupResp.getDesc(this.size - 1).getEndKey().toByteArray();
            if (this.isEndKey(lastKey)) {
                return null;
            }
            this.idx = 0;
            this.lookupResp = this.fs_.getTablets(this.tablePath, lastKey);
            this.size = this.lookupResp.getDescCount();
            return this.next();
        }
        return this.lookupResp.getDesc(this.idx++);
    }

    public List<Dbserver.TabletDesc> nextSet() throws IOException {
        if (this.idx >= this.size) {
            if (this.size == 0) {
                return null;
            }
            byte[] lastKey = this.lookupResp.getDesc(this.size - 1).getEndKey().toByteArray();
            if (this.isEndKey(lastKey)) {
                return null;
            }
            this.idx = 0;
            this.lookupResp = this.fs_.getTablets(this.tablePath, lastKey);
            this.size = this.lookupResp.getDescCount();
            return this.nextSet();
        }
        this.idx += this.size;
        return this.lookupResp.getDescList();
    }

    public int getTotal() {
        return this.lookupResp.getNumTotalTablets();
    }

    public boolean hasTotal() {
        return this.lookupResp.hasNumTotalTablets();
    }
}

