/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.Inode;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRResultScanner;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.StaleFileException;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.jni.MapRGet;
import com.mapr.fs.jni.MapRIncrement;
import com.mapr.fs.jni.MapRPut;
import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.jni.MapRScan;
import com.mapr.fs.proto.Dbserver;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class MapRHTable
implements Closeable,
MapRConstants {
    private static final Log LOG = LogFactory.getLog(MapRHTable.class);
    private MapRFileSystem maprfs_;
    private Configuration conf_;
    private byte[] tableNameInBytes_;
    private Path tablePath_;
    private String clusterName_;
    private volatile Inode inode_;
    private boolean closed_ = false;
    private boolean closeCalled_ = false;
    private LinkedList<MapRResultScanner> allScanners_ = new LinkedList();
    private volatile long schemaVersion_;
    private Dbserver.ColumnFamilyScanResponse cfSchema_;
    private Object cfSchemaLock_ = new Object();
    private Map<Integer, Dbserver.SchemaFamily> idToSchemaMap_ = new HashMap<Integer, Dbserver.SchemaFamily>();
    private Map<String, Dbserver.SchemaFamily> nameToSchemaMap_ = new HashMap<String, Dbserver.SchemaFamily>();
    int maxReopenAttempt_;
    int sleepMsOnReopenFailure_;

    public static boolean unsignedLessThan(long a, long b) {
        return MapRHTable.flip(a) < MapRHTable.flip(b);
    }

    public static long flip(long a) {
        return a ^ Long.MIN_VALUE;
    }

    public synchronized void init(Configuration conf, Path tablePath) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Init table " + tablePath));
        }
        this.conf_ = conf;
        this.closed_ = false;
        this.closeCalled_ = false;
        this.tableNameInBytes_ = tablePath.getName().getBytes("UTF-8");
        this.tablePath_ = tablePath;
        this.maprfs_ = new MapRFileSystem();
        this.maprfs_.initialize(this.tablePath_.toUri(), conf);
        this.clusterName_ = this.maprfs_.getClusterName(this.tablePath_.toUri());
        this.maxReopenAttempt_ = this.conf_.getInt("fs.mapr.table.max.reopen.attempt", 2);
        this.sleepMsOnReopenFailure_ = this.conf_.getInt("fs.mapr.table.reopen.failure.sleep", 1000);
        this.inode_ = this.maprfs_.openTable(this.tablePath_, this);
        this.refreshSchema();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("opened table " + tablePath + " clustername " + this.clusterName_));
        }
    }

    public void put(MapRPut mput) throws IOException {
        this.put(new MapRPut[]{mput});
    }

    public void put(MapRPut[] mputs) throws IOException {
        while (true) {
            try {
                this.inode_.put(mputs);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void syncPut(MapRPut mput) throws IOException {
        this.syncPut(mput, true);
    }

    public void syncPut(MapRPut[] mputs) throws IOException {
        this.syncPut(mputs, true);
    }

    public void syncPut(MapRPut mput, boolean shouldBlock) throws IOException {
        this.syncPut(new MapRPut[]{mput}, shouldBlock);
    }

    public void syncPut(MapRPut[] mputs, boolean shouldBlock) throws IOException {
        while (true) {
            try {
                this.inode_.syncPut(mputs, shouldBlock, false);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void syncPut(MapRPut[] mputs, boolean shouldBlock, boolean rowMut) throws IOException {
        while (true) {
            try {
                this.inode_.syncPut(mputs, shouldBlock, rowMut);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public long getBulkLoader(byte[] tableUuid) throws IOException {
        while (true) {
            try {
                return this.inode_.getBulkLoader(tableUuid);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void bulkLoaderClose(long bulkLoaderId) throws IOException {
        while (true) {
            try {
                this.inode_.bulkLoaderClose(bulkLoaderId);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void bulkLoaderAppend(long bulkLoaderId, MapRPut mput) throws IOException {
        this.bulkLoaderAppend(bulkLoaderId, new MapRPut[]{mput});
    }

    public void bulkLoaderAppend(long bulkLoaderId, MapRPut[] mput) throws IOException {
        while (true) {
            try {
                this.inode_.bulkLoaderAppend(bulkLoaderId, mput);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public byte[] getName() {
        return this.tableNameInBytes_;
    }

    public Path getTablePath() {
        return this.tablePath_;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closeCalled_) {
            this.closeCalled_ = true;
            this.tryClose();
        }
    }

    public synchronized void tryClose() throws IOException {
        if (this.closeCalled_ && this.allScanners_.isEmpty() && !this.closed_) {
            this.allScanners_.clear();
            this.idToSchemaMap_.clear();
            this.nameToSchemaMap_.clear();
            this.schemaVersion_ = 0L;
            this.inode_.removeFromTables();
            this.inode_.close();
            this.closed_ = true;
            LOG.debug((Object)("Closing the table " + this.tablePath_));
        }
    }

    public void flushCommits() throws IOException {
        while (true) {
            try {
                this.inode_.flushPuts();
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public MapRResult get(MapRGet mget) throws IOException {
        return this.get(mget, true);
    }

    public MapRResult[] get(MapRGet[] mgets) throws IOException {
        return this.get(mgets, true);
    }

    public MapRResult get(MapRGet mget, boolean shouldFlush) throws IOException {
        MapRGet[] mgets = new MapRGet[]{mget};
        while (true) {
            try {
                this.inode_.get(mgets, shouldFlush);
                return mgets[0].getResult();
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public MapRResult[] get(MapRGet[] mgets, boolean shouldFlush) throws IOException {
        while (true) {
            try {
                this.inode_.get(mgets, shouldFlush);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
        MapRResult[] results = new MapRResult[mgets.length];
        int i = 0;
        for (MapRGet mget : mgets) {
            results[i++] = mget.getResult();
        }
        return results;
    }

    public void freeArena(long arenaAddr) {
        this.inode_.freeArena(arenaAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScanner(MapRResultScanner scanner) {
        LinkedList<MapRResultScanner> linkedList = this.allScanners_;
        synchronized (linkedList) {
            this.allScanners_.addLast(scanner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScanner(MapRResultScanner scanner) {
        LinkedList<MapRResultScanner> linkedList = this.allScanners_;
        synchronized (linkedList) {
            this.allScanners_.remove(scanner);
        }
    }

    public void increment(MapRIncrement incr) throws IOException {
        this.increment(incr, true);
    }

    public void increment(MapRIncrement incr, boolean shouldFlush) throws IOException {
        while (true) {
            try {
                this.inode_.increment(incr, shouldFlush);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public boolean checkAndPut(byte[] row, boolean useCf, int familyId, byte[] qualifier, byte[] value, MapRPut mput) throws IOException {
        return this.checkAndPut(row, useCf, familyId, qualifier, value, mput, true);
    }

    public boolean checkAndPut(byte[] row, boolean useCf, int familyId, byte[] qualifier, byte[] value, MapRPut mput, boolean shouldFlush) throws IOException {
        while (true) {
            try {
                return this.inode_.checkAndPut(row, useCf, familyId, qualifier, value, mput, shouldFlush);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void delete(MapRPut mput) throws IOException {
        while (true) {
            try {
                this.inode_.delete(new MapRPut[]{mput});
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void delete(MapRPut[] mputs) throws IOException {
        while (true) {
            try {
                this.inode_.delete(mputs);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public boolean checkAndDelete(byte[] row, boolean useCf, int familyId, byte[] qualifier, byte[] value, MapRPut mput) throws IOException {
        return this.checkAndDelete(row, useCf, familyId, qualifier, value, mput, true);
    }

    public boolean checkAndDelete(byte[] row, boolean useCf, int familyId, byte[] qualifier, byte[] value, MapRPut mput, boolean shouldFlush) throws IOException {
        while (true) {
            try {
                return this.inode_.checkAndDelete(row, useCf, familyId, qualifier, value, mput, shouldFlush);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void append(MapRPut mput, boolean needResult) throws IOException {
        this.append(mput, true);
    }

    public void append(MapRPut mput, boolean needResult, boolean shouldFlush) throws IOException {
        while (true) {
            try {
                this.inode_.append(mput, needResult, shouldFlush);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void createTable(Configuration conf, byte[] tableName) throws IOException {
        Path tablePath = new Path(new String(tableName));
        MapRFileSystem maprfs = new MapRFileSystem();
        maprfs.initialize(this.tablePath_.toUri(), conf);
        maprfs.createTable(this.tablePath_);
        maprfs.close();
    }

    private synchronized void reopenTable(StaleFileException originalException) throws IOException {
        Inode currInode = this.inode_;
        if (currInode.isStale()) {
            if (this.maxReopenAttempt_ == 0) {
                throw originalException.noRetry();
            }
            HashSet<String> families = new HashSet<String>(this.nameToSchemaMap_.keySet());
            int i = 0;
            while (true) {
                try {
                    this.inode_ = this.maprfs_.openTable(this.tablePath_, this);
                    if (this.inode_.attrs().eq(currInode.attrs())) {
                        LOG.warn((Object)("Attept to reopen table returned the same inode: " + this.inode_.attrs()));
                        currInode.close();
                        throw originalException.noRetry();
                    }
                    block5: for (String family : families) {
                        int j = 0;
                        while (true) {
                            try {
                                this.inode_.getFamilyId(family);
                                continue block5;
                            }
                            catch (IOException e) {
                                this.handleReopenException(j, originalException.noRetry());
                                ++j;
                                continue;
                            }
                            break;
                        }
                    }
                    this.refreshSchema();
                    currInode.close();
                    return;
                }
                catch (IOException e) {
                    if (e == originalException) {
                        throw originalException.noRetry();
                    }
                    this.handleReopenException(i, originalException);
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    private void handleReopenException(int retryAttempt, StaleFileException e) throws IOException {
        if (retryAttempt < this.maxReopenAttempt_) {
            try {
                Thread.sleep(this.sleepMsOnReopenFailure_);
            }
            catch (InterruptedException e1) {
                throw new IOException("Interrupted while sleeping", e1);
            }
        } else {
            throw e.noRetry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refreshSchema() throws IOException {
        Dbserver.ColumnFamilyScanResponse scanResp;
        byte[] newSchema = this.inode_.getSchema(this.schemaVersion_);
        if (newSchema != null && MapRHTable.unsignedLessThan(this.schemaVersion_, (scanResp = Dbserver.ColumnFamilyScanResponse.parseFrom(newSchema)).getVersion())) {
            Object object = this.cfSchemaLock_;
            synchronized (object) {
                if (MapRHTable.unsignedLessThan(this.schemaVersion_, scanResp.getVersion())) {
                    this.idToSchemaMap_.clear();
                    this.nameToSchemaMap_.clear();
                    this.cfSchema_ = scanResp;
                    int families = scanResp.getCfAttrListCount();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Updating schema #families " + families));
                    }
                    for (int i = 0; i < families; ++i) {
                        Dbserver.SchemaFamily sf = this.cfSchema_.getCfAttrList(i).getSchFamily();
                        this.idToSchemaMap_.put(sf.getId(), sf);
                        this.nameToSchemaMap_.put(sf.getName(), sf);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Caching family name=" + sf.getName() + ", id=" + sf.getId()));
                    }
                    this.schemaVersion_ = scanResp.getVersion();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFamilyName(int id) throws IOException {
        Dbserver.SchemaFamily sf;
        Object object = this.cfSchemaLock_;
        synchronized (object) {
            sf = this.idToSchemaMap_.get(id);
        }
        if (sf != null) {
            return sf.getName();
        }
        String fname = null;
        while (true) {
            try {
                fname = this.inode_.getFamilyName(id);
                this.refreshSchema();
                return fname;
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFamilyId(String name) throws IOException {
        Dbserver.SchemaFamily sf;
        Object object = this.cfSchemaLock_;
        synchronized (object) {
            sf = this.nameToSchemaMap_.get(name);
        }
        if (sf != null) {
            return sf.getId();
        }
        int id = 0;
        while (true) {
            try {
                id = this.inode_.getFamilyId(name);
                this.refreshSchema();
                return id;
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public MapRTabletScanner getTabletScanner(byte[] row) throws IOException {
        return this.maprfs_.getTabletScanner(this.tablePath_, row);
    }

    public MapRTabletScanner getTabletScanner() throws IOException {
        return this.maprfs_.getTabletScanner(this.tablePath_);
    }

    public String getServerForCid(int cid) throws IOException {
        return this.maprfs_.getServerForCid(cid, this.clusterName_);
    }

    public void asyncFlush() throws IOException {
        while (true) {
            try {
                this.inode_.flushPuts();
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public long getScanner(MapRScan scan) throws IOException {
        while (true) {
            try {
                return this.inode_.getScanner(scan);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void scanNext(long scannerId, int nbRows, MapRResult[] res) throws IOException {
        try {
            this.inode_.scanNext(scannerId, nbRows, res);
        }
        catch (StaleFileException e) {
            this.reopenTable(e);
            throw e;
        }
    }

    public void closeScanner(long scannerId) throws IOException {
        while (true) {
            try {
                this.inode_.closeScanner(scannerId);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public MapRFileSystem getMapRFS() {
        return this.maprfs_;
    }

    public Inode getInode() {
        return this.inode_;
    }

    public Configuration getConf() {
        return this.conf_;
    }

    static {
        ShimLoader.load();
    }
}

