/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.AceHelper;
import com.mapr.fs.BackgroundWork;
import com.mapr.fs.ClusterConf;
import com.mapr.fs.Inode;
import com.mapr.fs.MapRBlockLocation;
import com.mapr.fs.MapRClientImpl;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFsDataInputStream;
import com.mapr.fs.MapRFsDataOutputStream;
import com.mapr.fs.MapRFsInStream;
import com.mapr.fs.MapRFsOutStream;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.MapRPathId;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.jni.Errno;
import com.mapr.fs.jni.GatewaySource;
import com.mapr.fs.jni.IPPort;
import com.mapr.fs.jni.MapRClientInitParams;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.jni.MapRUserInfo;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Fileserver;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.constant.Constable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.PathId;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;

public class MapRFileSystem
extends FileSystem
implements MapRConstants {
    private static final Log LOG;
    private static final Pattern FID_PATTERN;
    private static final Pattern FID_SPLITTER;
    private static ClusterConf clusterConf;
    private static Map<String, ClusterData> clusterTable;
    private static Integer numInstances;
    private static Boolean initialized;
    private static boolean disableNameCache_;
    private static MapRClientInitParams clientInitParams;
    private URI uri = null;
    private String clusterName = null;
    private Boolean clusterNameUnique;
    private List<ClusterConf.ClusterEntry> localClusterList = new ArrayList<ClusterConf.ClusterEntry>();
    private Map<String, ClusterData> localClusterTable = new HashMap<String, ClusterData>();
    private Path workingDir;
    private long chunkSize = 0x10000000L;
    private boolean chunkSizePresentInConf_ = false;
    private MapRUserInfo userInfo = null;
    private ClusterData globStatClusterData = null;
    private String globStatAuth = null;
    private boolean fileSystemOpen = false;
    public static final String[] emptyStringArray;

    private void InitializeUserInfo() throws IOException {
        UserGroupInformation loginUser;
        UserGroupInformation currentUser;
        boolean impersonating;
        String user;
        block3: {
            user = null;
            impersonating = false;
            currentUser = null;
            loginUser = null;
            try {
                loginUser = UserGroupInformation.getLoginUser();
                currentUser = UserGroupInformation.getCurrentUser();
                if (!currentUser.getShortUserName().equals(loginUser.getShortUserName())) {
                    impersonating = true;
                    LOG.info((Object)("User " + loginUser.getShortUserName() + " is impersonating user " + currentUser.getShortUserName()));
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Exception while trying to get currentUser", (Throwable)e);
                if (currentUser != null || loginUser != null) break block3;
                LOG.error((Object)"No current user of login user found");
                throw new IOException(e);
            }
        }
        user = currentUser != null ? currentUser.getShortUserName() : loginUser.getShortUserName();
        this.userInfo = new MapRUserInfo(user);
        this.userInfo.SetImpersonationStatus(impersonating);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createClientInitParams() {
        if (!initialized.booleanValue()) {
            Boolean bl = initialized;
            synchronized (bl) {
                if (!initialized.booleanValue()) {
                    clientInitParams = new MapRClientInitParams();
                }
            }
        }
    }

    public MapRFileSystem() throws IOException {
        this.createClientInitParams();
        this.InitializeUserInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapRFileSystem(String cName, String[] cldbLocations) throws IOException {
        Map<String, ClusterData> map = clusterTable;
        synchronized (map) {
            if (!clusterTable.containsKey(cName)) {
                clusterConf.updateClusterEntry(this, cName, cldbLocations);
                this.clusterName = cName;
            }
        }
        this.createClientInitParams();
        this.InitializeUserInfo();
        this.setConf(new Configuration());
        try {
            URI uri = new URI("maprfs", cName, "/", null, null);
            this.initConfig(uri);
        }
        catch (URISyntaxException uriException) {
            throw new IOException("Could not build URI for cluster: " + cName);
        }
        this.fileSystemOpen = true;
    }

    private Path adjustWorkingDir(String workingDirStr) {
        UserGroupInformation currentUser = null;
        try {
            currentUser = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            LOG.error((Object)"Exception while trying to get currentUser", (Throwable)e);
        }
        String currentUserName = currentUser != null ? currentUser.getShortUserName() : this.userInfo.userName;
        if (workingDirStr != null && !workingDirStr.isEmpty()) {
            workingDirStr = currentUserName != null ? workingDirStr.replaceAll("\\$USERNAME", currentUserName) : "/";
            if (!workingDirStr.endsWith("/")) {
                workingDirStr = workingDirStr + "/";
            }
            try {
                if (new URI(workingDirStr).getScheme() == null) {
                    workingDirStr = "maprfs:///" + workingDirStr;
                }
            }
            catch (URISyntaxException e) {
                LOG.error((Object)("Exception while trying to parse working directory " + workingDirStr), (Throwable)e);
            }
        } else {
            workingDirStr = currentUserName != null ? "/user/" + currentUserName + "/" : "/";
        }
        return new Path(workingDirStr);
    }

    @Override
    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.setConf(conf);
        this.initConfig(name);
        this.workingDir = this.adjustWorkingDir(conf.get("fs.mapr.working.dir"));
        this.fileSystemOpen = true;
    }

    private void InitializeClientInitParamsFromConf(Configuration conf) {
        MapRFileSystem.clientInitParams.aggregateWrites = conf.getBoolean("fs.mapr.aggregate.writes", true);
        MapRFileSystem.clientInitParams.numWriters = conf.getInt("fs.mapr.threads", MapRFileSystem.clientInitParams.aggregateWrites ? 8 : 64);
        if (MapRFileSystem.clientInitParams.numWriters <= 0) {
            MapRFileSystem.clientInitParams.numWriters = MapRFileSystem.clientInitParams.aggregateWrites ? 8 : 64;
        }
        MapRFileSystem.clientInitParams.tabletLruLimitKB = conf.getInt("fs.mapr.tabletlru.size.kb", 0);
        MapRFileSystem.clientInitParams.memPoolSize = conf.getInt("fs.mapr.shmpool.size", 2560);
        if (MapRFileSystem.clientInitParams.memPoolSize < 0) {
            MapRFileSystem.clientInitParams.memPoolSize = 2560;
        }
        MapRFileSystem.clientInitParams.allTrace = conf.getTrimmed("fs.mapr.trace");
        MapRFileSystem.clientInitParams.slowOpsThreshold = conf.getInt("fs.mapr.slowops.threshold", 0);
        if (MapRFileSystem.clientInitParams.slowOpsThreshold > 0) {
            MapRClientImpl.setSlowOpsThreshold(MapRFileSystem.clientInitParams.slowOpsThreshold);
        }
        MapRFileSystem.clientInitParams.disableLocalIO = conf.getBoolean("fs.mapr.io.remoteonly", false);
        MapRFileSystem.clientInitParams.rpcTimeout = conf.getInt("fs.mapr.rpc.timeout", 0);
        MapRFileSystem.clientInitParams.spoofedUser = conf.get("hadoop.spoofed.user.username", "root");
        MapRFileSystem.clientInitParams.spoofedUid = conf.getInt("hadoop.spoofed.user.uid", 0);
        if (MapRFileSystem.clientInitParams.spoofedUid < 0) {
            MapRFileSystem.clientInitParams.spoofedUid = 0;
        }
        MapRFileSystem.clientInitParams.spoofedGroup = conf.get("hadoop.spoofed.user.groupname", "root");
        MapRFileSystem.clientInitParams.spoofedGid = conf.getInt("hadoop.spoofed.user.gid", 0);
        if (MapRFileSystem.clientInitParams.spoofedGid < 0) {
            MapRFileSystem.clientInitParams.spoofedGid = 0;
        }
        MapRFileSystem.clientInitParams.dbPutThresholdMB = conf.getInt("db.mapr.putbuffer.threshold.mb", 0);
        MapRFileSystem.clientInitParams.dbPutThresholdSec = conf.getInt("db.mapr.putbuffer.threshold.sec", 0);
        MapRFileSystem.clientInitParams.dbPutBufSize = conf.getInt("db.mapr.putbuffer.size", 0);
        MapRFileSystem.clientInitParams.readBuffering = conf.getBoolean("fs.mapr.readbuffering", true);
        MapRFileSystem.clientInitParams.blQueueSizeMB = conf.getInt("db.mapr.bulkload.queuesize.mb", 0);
        MapRFileSystem.clientInitParams.blFlags = conf.getInt("db.mapr.bulkload.flags", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getClustersfromConfObject(Configuration conf) {
        String[] clusterList;
        String clusterListKey = "dfs.nameservices";
        String cldbListPrefix = "dfs.ha.namenodes.";
        String cldbAddressPrefix = "dfs.namenode.rpc-address.";
        String clusterIsUnique = "fs.mapr.impl.clustername.unique";
        if (conf == null) {
            return;
        }
        Object object = this.localClusterList;
        synchronized (object) {
            this.localClusterList.clear();
        }
        object = this.localClusterTable;
        synchronized (object) {
            this.localClusterTable.clear();
        }
        this.clusterNameUnique = conf.getBoolean(clusterIsUnique, true);
        for (String cluster : clusterList = conf.getTrimmedStrings(clusterListKey)) {
            Map<String, ClusterData> cTable = this.clusterNameUnique == false ? this.localClusterTable : clusterTable;
            Map<String, ClusterData> map = cTable;
            synchronized (map) {
                if (cTable.containsKey(cluster)) {
                    cTable.remove(cluster);
                }
            }
            String[] cldbList = conf.getTrimmedStrings(cldbListPrefix + cluster);
            ArrayList<String> cldbLocations = new ArrayList<String>();
            for (String cldb : cldbList) {
                String cldbAddress = conf.getTrimmed(cldbAddressPrefix + cluster + "." + cldb);
                if (cldbAddress == null) continue;
                cldbLocations.add(cldbAddress);
            }
            if (cldbLocations.size() <= 0) continue;
            String[] cldbIps = new String[cldbLocations.size()];
            cldbIps = cldbLocations.toArray(cldbIps);
            clusterConf.updateClusterEntry(this, cluster, cldbIps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfig(URI name) throws IOException {
        Constable constable;
        block24: {
            Configuration conf = this.getConf();
            if (conf != null) {
                this.chunkSize = conf.getLong("fs.mapr.block.size", -1L);
                boolean bl = this.chunkSizePresentInConf_ = this.chunkSize >= 0L;
                if (!this.chunkSizePresentInConf_) {
                    this.chunkSize = conf.getLong("dfs.blocksize", -1L);
                    boolean bl2 = this.chunkSizePresentInConf_ = this.chunkSize >= 0L;
                    if (!this.chunkSizePresentInConf_) {
                        this.chunkSize = 0x10000000L;
                    }
                }
                if (this.chunkSize % 65536L != 0L) {
                    throw new IOException("chunksize should be a multiple of 64K");
                }
                if (!initialized.booleanValue()) {
                    constable = initialized;
                    synchronized (constable) {
                        if (!initialized.booleanValue()) {
                            if (conf != null) {
                                disableNameCache_ = conf.getBoolean("fs.mapr.disable.namecache", false);
                                this.InitializeClientInitParamsFromConf(conf);
                            }
                            if (MapRClientImpl.initSpoofedUser(MapRFileSystem.clientInitParams.spoofedUser, MapRFileSystem.clientInitParams.spoofedUid, MapRFileSystem.clientInitParams.spoofedGroup, MapRFileSystem.clientInitParams.spoofedGid) != 0) {
                                throw new IOException("Failed to initialize spoofed user");
                            }
                            Inode.allocWriteBuffers(MapRFileSystem.clientInitParams.memPoolSize);
                            MapRClientImpl.setReadBuffering(MapRFileSystem.clientInitParams.readBuffering);
                            initialized = true;
                        }
                    }
                }
            }
            this.getClustersfromConfObject(conf);
            if (name != null) {
                try {
                    ClusterConf.ClusterEntry centry = clusterConf.getClusterByUri(this, name);
                    this.clusterName = centry.getClusterName();
                    if (name.getHost() != null) {
                        this.uri = name;
                        break block24;
                    }
                    try {
                        this.uri = new URI(name.getScheme(), "", name.getPath(), null, null);
                    }
                    catch (URISyntaxException uriException) {
                        throw new IOException("Could not build URI");
                    }
                }
                catch (IOException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)"Could not find any cluster, defaulting to localhost");
                    }
                    ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByAddr(this, "127.0.0.1", 7222);
                    this.clusterName = centry.getClusterName();
                    String authority = "127.0.0.1:7222";
                    try {
                        this.uri = new URI("maprfs", authority, "/", null, null);
                    }
                    catch (URISyntaxException uriException) {
                        throw new IOException("Could not build URI");
                    }
                }
            }
        }
        constable = numInstances;
        synchronized (constable) {
            if (numInstances == 0) {
                BackgroundWork.init();
            }
            Integer n = numInstances;
            Integer n2 = numInstances = Integer.valueOf(numInstances + 1);
        }
    }

    @Override
    public PathId createPathId() {
        MapRPathId pathId = new MapRPathId();
        return pathId;
    }

    private static void initError(MapRConstants.ErrorValue err) {
        err.error = 0;
        err.trailpath = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterData lookupClient(ClusterConf.ClusterEntry centry) throws IOException {
        this.checkOpen();
        if (this.globStatClusterData != null) {
            return this.globStatClusterData;
        }
        ClusterData retCluster = null;
        String cluster = centry.getClusterName();
        Map<String, ClusterData> cTable = this.clusterNameUnique == false ? this.localClusterTable : clusterTable;
        Map<String, ClusterData> map = cTable;
        synchronized (map) {
            if (cTable.containsKey(cluster)) {
                retCluster = cTable.get(cluster);
            } else {
                try {
                    MapRClientImpl client = new MapRClientImpl(cluster, centry.getIPs(), "", disableNameCache_, clientInitParams);
                    retCluster = new ClusterData(client);
                    cTable.put(cluster, retCluster);
                }
                catch (Exception e) {
                    throw new IOException(e.getLocalizedMessage());
                }
            }
        }
        if (this.clusterName == null) {
            this.clusterName = cluster;
        }
        if (!this.userInfo.infoIsComplete()) {
            if (0 != retCluster.client.GetUserInfo(this.userInfo)) {
                throw new IOException("Error getting user info for current user, " + this.userInfo.userName);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("User Info object initialized for user " + this.userInfo.userName + " with user ID " + this.userInfo.GetUserID()));
            }
            this.userInfo.idInfoIsPopulated();
        }
        return retCluster;
    }

    private ClusterData lookupClient(Path p) throws IOException {
        ClusterConf.ClusterEntry centry;
        if (this.globStatClusterData != null) {
            return this.globStatClusterData;
        }
        URI tmpURI = this.uri;
        URI absPathURI = this.makeAbsolute(p).toUri();
        if (tmpURI == null) {
            tmpURI = absPathURI;
        }
        if (this.clusterName == null) {
            LOG.debug((Object)"lookupClient: Cluster name is null");
        }
        if ((centry = clusterConf.getClusterByPath(this, absPathURI, tmpURI, this.clusterName)) == null) {
            throw new IOException("Could not resolve path: " + p.toString());
        }
        return this.lookupClient(centry);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        boolean createIfNonExistant = false;
        boolean append = false;
        boolean overwrite = false;
        for (CreateFlag fl : flag) {
            if (fl == CreateFlag.CREATE) {
                createIfNonExistant = true;
                continue;
            }
            if (fl == CreateFlag.APPEND) {
                append = true;
                continue;
            }
            if (fl != CreateFlag.OVERWRITE) continue;
            overwrite = true;
        }
        return this.create(f, 128, permission, createIfNonExistant, append, overwrite, bufferSize, replication, blockSize, progress, true);
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (!this.exists(f.getParent())) {
            throw new IOException("Parent to path " + f + " does not exist.");
        }
        return this.create(f, 128, permission, true, false, overwrite, bufferSize, replication, blockSize, progress, false);
    }

    public FSDataOutputStream create(Path f, int mask, FsPermission permission, boolean createIfNonExistant, boolean append, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress, boolean createParent) throws IOException {
        MapRFsOutStream os;
        if (append && overwrite) {
            if (createIfNonExistant) {
                throw new HadoopIllegalArgumentException("CREATE, APPEND and OVERWRITE set in CreateFlag");
            }
            throw new HadoopIllegalArgumentException("APPEND and OVERWRITE set in CreateFlag");
        }
        if (this.exists(f)) {
            if (createIfNonExistant && !append && !overwrite) {
                throw new FileAlreadyExistsException("Path " + f + " already exists");
            }
        } else if (!createIfNonExistant) {
            throw new FileNotFoundException("Path " + f + " not found");
        }
        if (blockSize % 65536L != 0L) {
            throw new IOException("chunksize should be a multiple of 64K");
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int mode = MapRClientImpl.getModeBits(permission, this.getConf());
        int clusterCount = 0;
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(f)) == null) {
                throw new IOException("Bad URI - no such cluster");
            }
            MapRFileSystem.initError(err);
            os = clusterData.client.create(this.getName(f), mask, mode, createIfNonExistant, append, overwrite, replication, blockSize, progress, err, createParent, this.userInfo, this.statistics);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.userName + "(user id " + this.userInfo.GetUserID() + ") " + "does not have access to create " + f);
            }
            if (err.error != 136) continue;
            f = new Path(err.trailpath);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        MapRFsDataOutputStream dos = null;
        if (os != null) {
            dos = new MapRFsDataOutputStream(os);
            if (append) {
                os.seekToEof();
            }
        }
        return dos;
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(f, 128, permission, true, false, overwrite, bufferSize, replication, blockSize, progress, true);
    }

    @Override
    public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        return this.create(f, this.shouldUseDefaultBlockSize(), FsPermission.getDefault(), true, false, overwrite, 0, this.getDefaultReplication(), this.chunkSize, null, true);
    }

    @Override
    public FSDataOutputStream create(Path f, Progressable progress) throws IOException {
        return this.create(f, this.shouldUseDefaultBlockSize(), FsPermission.getDefault(), true, false, true, 0, this.getDefaultReplication(), this.chunkSize, progress, true);
    }

    @Override
    public FSDataOutputStream create(Path f, short replication) throws IOException {
        return this.create(f, this.shouldUseDefaultBlockSize(), FsPermission.getDefault(), true, false, true, 0, replication, this.chunkSize, null, true);
    }

    @Override
    public FSDataOutputStream create(Path f, short replication, Progressable progress) throws IOException {
        return this.create(f, this.shouldUseDefaultBlockSize(), FsPermission.getDefault(), true, false, true, 0, replication, this.chunkSize, progress, true);
    }

    @Override
    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize) throws IOException {
        return this.create(f, this.shouldUseDefaultBlockSize(), FsPermission.getDefault(), true, false, overwrite, bufferSize, this.getDefaultReplication(), this.chunkSize, null, true);
    }

    @Override
    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, Progressable progress) throws IOException {
        return this.create(f, this.shouldUseDefaultBlockSize(), FsPermission.getDefault(), true, false, overwrite, bufferSize, this.getDefaultReplication(), this.chunkSize, progress, true);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException, AccessControlException {
        MapRFsInStream is;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(f)) == null) {
                return null;
            }
            MapRFileSystem.initError(err);
            is = clusterData.client.open(this.getName(f), err, this.userInfo, this.statistics);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.userName + "(user id " + this.userInfo.GetUserID() + ") " + "does not have access to " + f);
            }
            if (err.error != 136) continue;
            f = new Path(err.trailpath);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (is != null) {
            return new MapRFsDataInputStream(is);
        }
        return null;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public String getScheme() {
        return this.getUri().getScheme();
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException, AccessControlException {
        MapRFsOutStream os;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(f)) == null) {
                return null;
            }
            MapRFileSystem.initError(err);
            os = clusterData.client.append(this.getName(f), err, this.userInfo, this.statistics);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.userName + "(user id " + this.userInfo.GetUserID() + ") " + " does not have access to " + f);
            }
            if (err.error != 136) continue;
            f = new Path(err.trailpath);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (os != null) {
            return new MapRFsDataOutputStream(os);
        }
        return null;
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        return this.getMapRFileStatus(f);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        int ret;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(src)) == null) {
                return false;
            }
            MapRFileSystem.initError(err);
            ret = clusterData.client.rename(this.getName(src), this.getName(dst), err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            src = new Path(err.trailpath);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (ret == 18) {
            Path tmpDst;
            FileStatus sdst;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Cannot rename across volumes, falling back on copy/delete semantics");
            }
            if (this.exists(dst) && (sdst = this.getFileStatus(dst)).isDir()) {
                dst = new Path(dst, src.getName());
            }
            if (this.exists(tmpDst = dst.suffix(".tmp~!@"))) {
                this.delete(tmpDst, true);
            }
            if (!FileUtil.copy(this, src, this, tmpDst, false, this.getConf())) {
                this.delete(tmpDst, true);
                return false;
            }
            if (!this.rename(tmpDst, dst)) {
                LOG.error((Object)("Failed to rename " + tmpDst + " to " + dst));
                return false;
            }
            if (!this.delete(src, true)) {
                LOG.error((Object)("Failed to delete " + src));
                return false;
            }
            ret = 0;
        }
        if (ret == 2) {
            throw new IOException("Invalid source or target");
        }
        if (ret == 13) {
            throw new AccessControlException("User " + this.userInfo.userName + "(user id " + this.userInfo.GetUserID() + ") " + "does has been denied access to rename  " + this.getName(src) + " to " + this.getName(dst));
        }
        if (ret != 0) {
            throw new IOException("Error: " + Errno.toString(ret < 0 ? -ret : ret));
        }
        return true;
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        int error;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(f)) == null) {
                return false;
            }
            MapRFileSystem.initError(err);
            error = clusterData.client.delete(this.getName(f), recursive, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.userName + "(user id " + this.userInfo.GetUserID() + ") " + " does not have access to " + f);
            }
            if (error == 136) {
                f = new Path(err.trailpath);
                continue;
            }
            if (error == 13) {
                throw new AccessControlException("User " + this.userInfo.userName + "(user id " + this.userInfo.GetUserID() + ") " + " does not have access to " + f);
            }
            if (error == 0) continue;
            LOG.error((Object)("Failed to delete path " + f + ", error: " + Errno.toString(err.error) + " (" + err.error + ")"));
            try {
                MapRFileStatus fStatus = this.getMapRFileStatus(f);
                if (((FileStatus)fStatus).isDir() && !recursive) {
                    throw new IOException("Could not delete dir " + f + ", Error: " + Errno.toString(err.error) + ", Try with recursive flag set to true");
                }
            }
            catch (FileNotFoundException e) {
                return false;
            }
        } while (error == 136);
        return error == 0;
    }

    @Override
    public boolean delete(Path f) throws IOException {
        return this.delete(f, true);
    }

    @Override
    public void setWorkingDirectory(Path new_dir) {
        this.workingDir = this.adjustWorkingDir(this.makeAbsolute(new_dir).toString());
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public long getDefaultBlockSize() {
        return this.chunkSize;
    }

    int shouldUseDefaultBlockSize() {
        return this.chunkSizePresentInConf_ ? 128 : 0;
    }

    @Override
    public short getDefaultReplication() {
        return 3;
    }

    String makeDir(Path p, int mask, int mode, boolean z, long chunkSize, boolean needFid, boolean createParent) throws IOException {
        int error;
        if (chunkSize % 65536L != 0L) {
            throw new IOException("chunksize should be a multiple of 64K");
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(p)) == null) {
                throw new IOException("Bad URI: no such cluster, path: " + p);
            }
            MapRFileSystem.initError(err);
            error = clusterData.client.mkdirs(this.getName(p), mask, mode, z, chunkSize, err, needFid, createParent, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (error != 136) continue;
            p = new Path(err.trailpath);
        } while (error == 136);
        if (error != 0) {
            if (error < 0) {
                error = -error;
            }
            if (error == 13) {
                throw new AccessControlException("User " + this.userInfo.userName + "(user id " + this.userInfo.GetUserID() + ") " + " has been denied access to create " + p.getName());
            }
            throw new IOException("Error: " + Errno.toString(error) + "(" + error + ")" + ", file: " + p.getName() + ", user name: " + this.userInfo.userName + ", ID: " + this.userInfo.GetUserID());
        }
        return needFid ? err.fid : null;
    }

    @Override
    public boolean mkdirs(Path p, FsPermission permission) throws IOException {
        this.makeDir(p, this.shouldUseDefaultBlockSize(), MapRClientImpl.getModeBits(permission, this.getConf()), true, this.chunkSize, false, true);
        return true;
    }

    public boolean mkdirs(Path p, boolean createParent, FsPermission permission) throws IOException {
        this.makeDir(p, this.shouldUseDefaultBlockSize(), MapRClientImpl.getModeBits(permission, this.getConf()), true, this.chunkSize, false, createParent);
        return true;
    }

    public boolean mkdirs(Path p, FsPermission permission, boolean compress) throws IOException {
        this.makeDir(p, this.shouldUseDefaultBlockSize() | 0x40, MapRClientImpl.getModeBits(permission, this.getConf()), compress, this.chunkSize, false, true);
        return true;
    }

    public boolean mkdirs(Path f, FsPermission permission, long chunkSize) throws IOException {
        this.makeDir(f, 128, MapRClientImpl.getModeBits(permission, this.getConf()), true, chunkSize, false, true);
        return true;
    }

    public boolean mkdirs(Path f, FsPermission permission, boolean compress, long chunkSize) throws IOException {
        this.makeDir(f, 192, MapRClientImpl.getModeBits(permission, this.getConf()), compress, chunkSize, false, true);
        return true;
    }

    private static MapRFileStatus adjustFileStatus(MapRFileStatus fstatus, boolean needAuthority, String authority) {
        if (needAuthority) {
            Path p = new Path("maprfs", authority, fstatus.getPath().toString());
            fstatus.setPath(p);
        }
        return fstatus;
    }

    @Override
    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        ClusterData tmpClusterData = this.lookupClient(pathPattern);
        LOG.debug((Object)"Using MapR globStatus");
        if (this.globStatClusterData == null) {
            this.globStatClusterData = tmpClusterData;
        } else if (tmpClusterData.client != this.globStatClusterData.client) {
            throw new IOException("Recursive/concurrent use of globStatus for different clusters not supported");
        }
        if (this.globStatAuth == null) {
            this.globStatAuth = pathPattern.toUri().getAuthority();
        } else if (!this.globStatAuth.equals(pathPattern.toUri().getAuthority())) {
            throw new IOException("Recursive/concurrent use of globStatus for different clusters not supported");
        }
        FileStatus[] result = super.globStatus(pathPattern, filter);
        this.globStatClusterData = null;
        this.globStatAuth = null;
        return result;
    }

    public MapRFileStatus getMapRFileStatus(Path f) throws IOException {
        MapRFileStatus fstatus;
        URI u = this.makeAbsolute(f).toUri();
        String authority = u.getAuthority();
        if (authority == null) {
            authority = this.globStatAuth;
        }
        boolean needAuthority = authority != null && !authority.isEmpty();
        String rawPath = u.getPath();
        if (rawPath.equals("/mapr") || rawPath.equals("/mapr/")) {
            return MapRFileSystem.adjustFileStatus(new MapRFileStatus("/mapr", System.currentTimeMillis()), needAuthority, authority);
        }
        boolean needSlashMapr = rawPath.startsWith("/mapr/");
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(f)) == null) {
                return null;
            }
            MapRFileSystem.initError(err);
            fstatus = clusterData.client.getFileStatus(this.getNameStr(rawPath), needSlashMapr, this.getScheme(), authority, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.userName + "(user id " + this.userInfo.GetUserID() + ") " + " does not have access to " + f);
            }
            if (err.error != 136) continue;
            f = new Path(err.trailpath);
            rawPath = this.makeAbsolute(f).toUri().getPath();
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (fstatus == null) {
            throw new FileNotFoundException("Requested file " + f + " does not exist" + (f.isAbsolute() ? "." : " (Absolute path: " + rawPath + ")."));
        }
        return fstatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapRFileStatus[] listMapRStatus(Path f, boolean showVols, boolean showHidden) throws IOException {
        MapRFileStatus status;
        String name;
        ClusterData clusterData;
        URI u = this.makeAbsolute(f).toUri();
        String authority = u.getAuthority();
        if (authority == null) {
            authority = this.globStatAuth;
        }
        boolean needAuthority = authority != null && !authority.isEmpty();
        String rawPath = u.getPath();
        if (rawPath.equals("/mapr") || rawPath.equals("/mapr/")) {
            List<ClusterConf.ClusterEntry> clusterList = clusterConf.getClusterList();
            if (clusterList.isEmpty()) {
                return null;
            }
            MapRFileStatus[] result = new MapRFileStatus[clusterList.size()];
            List<ClusterConf.ClusterEntry> list = clusterList;
            synchronized (list) {
                int i = 0;
                long time = System.currentTimeMillis();
                for (ClusterConf.ClusterEntry centry : clusterList) {
                    result[i] = MapRFileSystem.adjustFileStatus(new MapRFileStatus("/mapr/" + centry.getClusterName(), time), needAuthority, authority);
                    ++i;
                }
            }
            return result;
        }
        boolean needSlashMapr = rawPath.startsWith("/mapr/");
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        do {
            if ((clusterData = this.lookupClient(f)) == null) {
                return null;
            }
            MapRFileSystem.initError(err);
            name = this.getNameStr(rawPath);
            status = clusterData.client.getFileStatus(name, needSlashMapr, this.getScheme(), authority, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            f = new Path(err.trailpath);
            rawPath = this.makeAbsolute(f).toUri().getPath();
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error == 13) {
            throw new AccessControlException("User " + this.userInfo.userName + "(user id " + this.userInfo.GetUserID() + ") " + " does not have access to " + f);
        }
        if (status == null) {
            throw new FileNotFoundException(f.toString());
        }
        if (status.isDir()) {
            MapRFileStatus[] result = clusterData.client.listStatus(name, showVols, needSlashMapr, showHidden, this.getScheme(), authority, err, this.userInfo);
            if (result == null) {
                if (err.error < 0) {
                    err.error = -err.error;
                }
                if (err.error == 13) {
                    throw new AccessControlException("User " + this.userInfo.userName + "(user id " + this.userInfo.GetUserID() + ") " + " does not have access to " + f);
                }
                if (err.error == 1) {
                    throw new IOException("Failed to list contents of dir " + f + ", err: " + Errno.toString(err.error) + "(" + err.error + ")");
                }
            }
            return result;
        }
        return new MapRFileStatus[]{status};
    }

    public MapRFileStatus[] listStatus(Path f) throws IOException {
        return this.listMapRStatus(f, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Map<String, ClusterData> map = numInstances;
        synchronized (map) {
            Integer n = numInstances;
            Integer n2 = numInstances = Integer.valueOf(numInstances - 1);
            if (numInstances == 0) {
                BackgroundWork.close();
            }
        }
        map = this.localClusterList;
        synchronized (map) {
            this.localClusterList.clear();
        }
        map = this.localClusterTable;
        synchronized (map) {
            this.localClusterTable.clear();
        }
        super.close();
        this.fileSystemOpen = false;
    }

    void checkOpen() throws IOException {
        if (!this.fileSystemOpen) {
            throw new IOException("Filesystem closed");
        }
    }

    @Override
    public long getUsed() throws IOException {
        FsStatus fsStatus = this.getStatus();
        return fsStatus.getUsed();
    }

    @Override
    public boolean supportsSymlinks() {
        return true;
    }

    @Override
    public void createSymlink(Path target, Path link, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, IOException {
        int err = this.createSymlink(target.toString(), link, createParent);
        if (err == -1) {
            throw new IOException("Cannot create symlink");
        }
        if (err == 17) {
            throw new FileAlreadyExistsException("Cannot create symlink");
        }
        if (err == 13) {
            throw new AccessControlException("User " + this.userInfo.userName + "(user id " + this.userInfo.GetUserID() + ") " + " does not have access to create symlink");
        }
        if (err == 2) {
            throw new FileNotFoundException(link + " not found to create symlink");
        }
        if (err == 20) {
            throw new ParentNotDirectoryException("Parent directory not found to create symlink");
        }
    }

    public int createSymlink(String target, Path link, boolean createParent) throws IOException {
        String scheme;
        URI u = this.makeAbsolute(new Path(target)).toUri();
        if (u != null && (scheme = u.getScheme()) != null && !scheme.equalsIgnoreCase("maprfs")) {
            throw new IOException("Cannot create symlinks to non-maprfs filesystems");
        }
        MapRConstants.ErrorValue linkErr = new MapRConstants.ErrorValue();
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(link)) == null) {
                return -1;
            }
            int mask = this.shouldUseDefaultBlockSize();
            int mode = MapRClientImpl.getModeBits(FsPermission.getDefault(), this.getConf());
            clusterData.client.createSymlink(target, this.getName(link).toString(), createParent, mask, mode, this.chunkSize, linkErr, this.userInfo);
            if (linkErr.error < 0) {
                linkErr.error = -linkErr.error;
            }
            if (linkErr.error != 136) continue;
            link = new Path(linkErr.trailpath);
        } while (linkErr.error == 136);
        return linkErr.error;
    }

    public MapRFileStatus[] scanDir(String cluster, String fidstr) throws IOException {
        ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(this, cluster) : clusterConf.getClusterEntryByName(this, this.clusterName);
        ClusterData clusterData = this.lookupClient(centry);
        if (clusterData == null) {
            return null;
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        return clusterData.client.listStatus(fidstr, true, false, true, this.getScheme(), null, err, this.userInfo);
    }

    public byte[] scanKV(String cluster, String fidstr, byte[] start, byte[] end, int maxkeys) throws IOException {
        ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(this, cluster) : clusterConf.getClusterEntryByName(this, this.clusterName);
        ClusterData clusterData = this.lookupClient(centry);
        if (clusterData == null) {
            return null;
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        return clusterData.client.scanKV(fidstr, start, end, maxkeys, err);
    }

    public Fileserver.KvstoreScanResponse scanKVGivenFid(Path URI2, Common.FidMsg kvFid, Fileserver.KvStoreKey start, Fileserver.KvStoreKey end) throws IOException {
        Fileserver.KvstoreScanResponse resp;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(URI2)) == null) {
                throw new IOException("Failed to create maprclient for " + URI2);
            }
            MapRFileSystem.initError(err);
            resp = clusterData.client.scanKVGivenFid(kvFid, start, end, err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            URI2 = new Path(err.trailpath);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.userName + "(user id " + this.userInfo.GetUserID() + ") " + " does not have access to scan table");
            }
            throw new IOException("Failed to scan table, Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
        return resp;
    }

    public Fileserver.KvstoreLookupResponse lookupKV(Path tableURI, Fileserver.KvStoreKey key) throws IOException {
        Fileserver.KvstoreLookupResponse resp;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            resp = clusterData.client.lookupKV(tableName, key, err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            tableURI = new Path(err.trailpath);
            tableName = this.getName(tableURI);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.userName + "(user id " + this.userInfo.GetUserID() + ") " + " does not have access to scan table");
            }
            throw new IOException("Failed to lookup key on table: " + tableName + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
        return resp;
    }

    public int createVolLink(String cluster, String volName, Path volLink, boolean writeable, boolean isHidden) throws IOException {
        ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(this, cluster) : clusterConf.getClusterEntryByName(this, this.clusterName);
        ClusterData clusterData = this.lookupClient(centry);
        if (clusterData == null) {
            return -1;
        }
        return clusterData.client.createVolLink(volName, this.getName(volLink).toString(), writeable, isHidden, this.userInfo);
    }

    public int deleteVolLink(String cluster, String volLink) throws IOException {
        ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(this, cluster) : clusterConf.getClusterEntryByName(this, this.clusterName);
        ClusterData clusterData = this.lookupClient(centry);
        if (clusterData == null) {
            return -1;
        }
        return clusterData.client.deleteVolLink(volLink, this.userInfo);
    }

    @Override
    public Path getHomeDirectory() {
        return this.workingDir;
    }

    public Path makeAbsolute(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(this.workingDir, path);
    }

    public String getClusterNameUnchecked(String str) throws IOException {
        if (str.startsWith("/mapr/")) {
            String[] strArr = str.split("/", 4);
            if (strArr.length <= 3) {
                throw new IOException("Could not parse clustername from " + str);
            }
            return strArr[2];
        }
        return this.clusterName;
    }

    public String getNameStr(String str) {
        if (str.startsWith("/mapr/")) {
            String[] strArr = str.split("/", 4);
            if (strArr.length <= 3) {
                return "/";
            }
            return "/" + strArr[3];
        }
        return str;
    }

    public String getName(Path p) {
        return this.getNameStr(this.makeAbsolute(p).toUri().getPath());
    }

    public MapRBlockLocation[] getMapRFileBlockLocations(FileStatus file, long start, long len, boolean usePrimaryFid, boolean needDiskBlocks) throws IOException {
        MapRBlockLocation[] result;
        if (file == null) {
            return null;
        }
        String path = this.getName(file.getPath());
        if (path == null) {
            return new MapRBlockLocation[0];
        }
        if (start < 0L) {
            throw new IOException("Negative offset is not supported.");
        }
        if (len < 0L) {
            throw new IOException("Negative length is not supported.");
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        Path p = file.getPath();
        int clusterCount = 0;
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(p)) == null) {
                return new MapRBlockLocation[0];
            }
            MapRFileSystem.initError(err);
            result = clusterData.client.getBlockLocations(path, start, len, usePrimaryFid, needDiskBlocks, err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.userName + "(user id " + this.userInfo.GetUserID() + ") " + " does not have access to " + path);
            }
            if (err.error != 136) continue;
            path = err.trailpath;
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        return result == null ? new MapRBlockLocation[]{} : result;
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        return this.getMapRFileBlockLocations(file, start, len, false, false);
    }

    @Override
    public void setOwner(Path p, String user, String group) throws IOException {
        int error;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setOwner: Path = " + p + " User = " + user + " Group = " + group));
        }
        if (user == null && group == null) {
            throw new HadoopIllegalArgumentException("Invalid user/group arguments " + user + "/" + group + " for path " + p);
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(p)) == null) {
                return;
            }
            MapRFileSystem.initError(err);
            error = clusterData.client.setOwner(this.getName(p), user, group, err, this.userInfo);
            if (error < 0) {
                error = -error;
            }
            if (error != 136) continue;
            p = new Path(err.trailpath);
        } while (error == 136);
        if (error == 2) {
            throw new FileNotFoundException(p.toString());
        }
        if (error == 13) {
            throw new AccessControlException("User " + this.userInfo.userName + "(user id " + this.userInfo.GetUserID() + ") " + " does not have access to set " + "owner/group for path " + p);
        }
        if (error != 0) {
            throw new IOException("Could not set owner/group " + user + "/" + group + " for path " + p);
        }
    }

    @Override
    public void setOwnerFid(String pfid, String user, String group) throws IOException {
        MapRFileSystem.validateFid(pfid);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setOwner: pfid = " + pfid + " User = " + user + " Group = " + group));
        }
        if (user == null && group == null) {
            throw new IOException("Invalid user/group arguments " + user + "/" + group + " for path " + pfid);
        }
        ClusterData clusterData = this.lookupClient(clusterConf.getClusterEntryByName(this, this.clusterName));
        if (clusterData == null) {
            throw new IOException("Unable to connect to MapR cluster!");
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        MapRFileSystem.initError(err);
        int error = clusterData.client.setOwnerFid(pfid, user, group, err, this.userInfo);
        if (error < 0) {
            error = -error;
        }
        if (error == 2) {
            throw new FileNotFoundException(pfid.toString());
        }
        if (error == 13) {
            throw new AccessControlException("User " + this.userInfo.userName + "(user id " + this.userInfo.GetUserID() + ") " + " does not have access to set " + "owner/group for fid " + pfid);
        }
        if (error != 0) {
            throw new IOException("Could not set owner/group " + user + "/" + group + " for fid " + pfid);
        }
    }

    @Override
    public void setTimes(Path p, long mtime, long atime) throws IOException {
        if (mtime != -1L || atime != -1L) {
            int error;
            MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
            do {
                ClusterData clusterData;
                if ((clusterData = this.lookupClient(p)) == null) {
                    return;
                }
                MapRFileSystem.initError(err);
                error = clusterData.client.setTimes(this.getName(p), mtime, atime, err, this.userInfo);
                if (error < 0) {
                    error = -error;
                }
                if (error != 136) continue;
                p = new Path(err.trailpath);
            } while (error == 136);
            if (error != 0) {
                throw new IOException("Could not set mtime/atime for " + p);
            }
        }
    }

    @Override
    public void setPermission(Path p, FsPermission permission) throws IOException {
        if (permission != null) {
            int error;
            MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
            do {
                ClusterData clusterData;
                if ((clusterData = this.lookupClient(p)) == null) {
                    return;
                }
                MapRFileSystem.initError(err);
                error = clusterData.client.setPermission(this.getName(p), permission.toShort(), err, this.userInfo);
                if (error < 0) {
                    error = -error;
                }
                if (error != 136) continue;
                p = new Path(err.trailpath);
            } while (error == 136);
            if (error != 0) {
                throw new IOException("Could not set permission for " + p);
            }
        }
    }

    @Override
    public FileStatus getFileLinkStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.getMapRFileStatus(f);
    }

    @Override
    public Path getLinkTarget(Path f) throws IOException {
        MapRFileStatus status = this.getMapRFileStatus(f);
        if (!status.isSymlink()) {
            throw new IOException("Path " + f + " is not a symbolic link");
        }
        Path newPath = null;
        while ((status = this.getMapRFileStatus(newPath = status.getSymlink())).isSymlink()) {
        }
        return newPath;
    }

    @Override
    protected Path resolveLink(Path f) throws IOException {
        MapRFileStatus status = this.getMapRFileStatus(f);
        if (!status.isSymlink()) {
            throw new IOException("Path " + f + " is not a symbolic link");
        }
        return status.getSymlink();
    }

    @Override
    public FsStatus getStatus() throws IOException {
        return this.getStatus(null);
    }

    @Override
    public FsStatus getStatus(Path p) throws IOException {
        ClusterData clusterData = p == null ? this.lookupClient(clusterConf.getClusterEntryByName(this, this.clusterName)) : this.lookupClient(p);
        if (clusterData == null) {
            return null;
        }
        return clusterData.client.getStatus();
    }

    public int setCompression(Path path, boolean val, String compName) throws IOException {
        int error;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(path)) == null) {
                return -1;
            }
            MapRFileSystem.initError(err);
            error = clusterData.client.setCompression(this.getName(path).toString(), val, compName, err, this.userInfo);
            if (error < 0) {
                error = -error;
            }
            if (error != 136) continue;
            path = new Path(err.trailpath);
        } while (error == 136);
        return error;
    }

    public int setWireSecurity(Path path, boolean val) throws IOException {
        int error;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(path)) == null) {
                return -1;
            }
            MapRFileSystem.initError(err);
            error = clusterData.client.setWireSecurity(this.getName(path).toString(), val, err, this.userInfo);
            if (error < 0) {
                error = -error;
            }
            if (error != 136) continue;
            path = new Path(err.trailpath);
        } while (error == 136);
        return error;
    }

    public int setChunkSize(Path path, long val) throws IOException {
        int error;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(path)) == null) {
                return -1;
            }
            MapRFileSystem.initError(err);
            error = clusterData.client.setChunkSize(this.getName(path).toString(), val, err, this.userInfo);
            if (error < 0) {
                error = -error;
            }
            if (error != 136) continue;
            path = new Path(err.trailpath);
        } while (error == 136);
        return error;
    }

    public int mountVolume(String cluster, String volName, String mountPath, String username) {
        if (mountPath.charAt(0) != '/') {
            LOG.error((Object)("mountVolume: mount path " + mountPath + " is not absolute"));
            return -1;
        }
        try {
            ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(this, cluster) : clusterConf.getClusterEntryByName(this, this.clusterName);
            int mode = MapRClientImpl.getModeBits(FsPermission.getDefault(), this.getConf());
            ClusterData clusterData = this.lookupClient(centry);
            return clusterData.client.mountVolume(volName, mountPath, username, this.userInfo, mode);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int unmountVolume(String cluster, String volName, String mountPath, String username, int pCid, int pCinum, int pUniq) {
        if (mountPath.charAt(0) != '/') {
            LOG.error((Object)("unmountVolume: mount path " + mountPath + " is not " + "absolute"));
            return -1;
        }
        try {
            ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(this, cluster) : clusterConf.getClusterEntryByName(this, this.clusterName);
            ClusterData clusterData = this.lookupClient(centry);
            return clusterData.client.unmountVolume(volName, mountPath, username, pCid, pCinum, pUniq, this.userInfo);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String getMountPathFid(String fidStr) throws IOException {
        String[] fidTriple = FID_SPLITTER.split(fidStr);
        if (fidTriple.length != 3) {
            throw new IOException(fidStr + ": Invalid fid format");
        }
        try {
            int[] fidInts = new int[]{Integer.valueOf(fidTriple[0]), Integer.valueOf(fidTriple[1]), Integer.valueOf(fidTriple[2])};
            return this.getMountPath(null, this.userInfo.userName, fidInts[0], fidInts[1], fidInts[2]);
        }
        catch (NumberFormatException e) {
            throw new IOException(fidStr + ": Invalid fid format", e);
        }
    }

    public String getMountPath(String cluster, String username, int pCid, int pCinum, int pUniq) {
        try {
            ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(this, cluster) : clusterConf.getClusterEntryByName(this, this.clusterName);
            ClusterData clusterData = this.lookupClient(centry);
            return clusterData.client.getMountPath(username, pCid, pCinum, pUniq, this.userInfo);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception in getNewMountPath", (Throwable)e);
            return null;
        }
    }

    public int createSnapshot(String cluster, String volumeName, int volId, int rootCid, String snapshotName, boolean mirrorSnapshot, String username) {
        try {
            ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(this, cluster) : clusterConf.getClusterEntryByName(this, this.clusterName);
            ClusterData clusterData = this.lookupClient(centry);
            if (clusterData == null) {
                return -1;
            }
            return clusterData.client.createSnapshot(volumeName, volId, rootCid, snapshotName, mirrorSnapshot, username, this.userInfo);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private String getZkConnectStringInternal(String cName) {
        try {
            ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, cName);
            ClusterData clusterData = this.lookupClient(centry);
            if (clusterData == null) {
                return null;
            }
            return clusterData.client.getZkConnectString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getZkConnectString() throws IOException {
        return this.getZkConnectStringInternal(this.clusterName);
    }

    private Object getMapRClient(String uri) throws IOException {
        String cName;
        if (!uri.startsWith("maprfs:///")) {
            throw new IOException("Invalid prefix in " + uri + " expecting " + "maprfs:///");
        }
        if ((uri = uri.replaceFirst("maprfs:///", "")).isEmpty()) {
            cName = this.clusterName;
        } else {
            if (uri.matches("mapr/+")) {
                throw new IOException("Invalid cluster path in " + uri + " expecting " + "maprfs:///");
            }
            uri = uri.replaceFirst("mapr/", "");
            cName = uri = uri.replaceAll("/+$", "");
        }
        try {
            ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, cName);
            return this.lookupClient((ClusterConf.ClusterEntry)centry).client;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public InetSocketAddress[] getJobTrackerAddrs(Configuration conf) throws IOException {
        URI jobTrackerUri;
        if (conf == null) {
            ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, this.clusterName);
            ClusterData clusterData = this.lookupClient(centry);
            if (clusterData != null) {
                return clusterData.client.getJobTrackerAddrs();
            }
            throw new IOException("Invalid Configuration");
        }
        String jobTrackerStr = conf.get("mapred.job.tracker", "maprdummy").trim();
        try {
            jobTrackerUri = new URI(jobTrackerStr);
        }
        catch (Exception e) {
            return this.getAddrsFromConf(conf);
        }
        if ("maprfs".equals(jobTrackerUri.getScheme())) {
            MapRClientImpl client = (MapRClientImpl)this.getMapRClient(jobTrackerStr);
            if (client != null) {
                return client.getJobTrackerAddrs();
            }
            throw new IOException("Failed to get cluster information for " + jobTrackerStr);
        }
        return this.getAddrsFromConf(conf);
    }

    private InetSocketAddress[] getAddrsFromConf(Configuration conf) {
        String[] jobTrackerStrs = MapRFileSystem.getTrimmedStrings(conf.get("mapred.job.tracker", "maprdummy"));
        InetSocketAddress[] jobTrackerAddrs = new InetSocketAddress[jobTrackerStrs.length];
        for (int i = 0; i < jobTrackerStrs.length; ++i) {
            jobTrackerAddrs[i] = NetUtils.createSocketAddr(jobTrackerStrs[i]);
        }
        return jobTrackerAddrs;
    }

    public static ClusterConf getClusterConf() {
        return clusterConf;
    }

    public static String[] getTrimmedStrings(String str) {
        if (null == str || "".equals(str.trim())) {
            return emptyStringArray;
        }
        return str.trim().split("\\s*,\\s*");
    }

    public static String fidToString(Common.FidMsg fid) {
        StringBuilder builder = new StringBuilder();
        builder.append(fid.getCid());
        builder.append(".");
        builder.append(fid.getCinum());
        builder.append(".");
        builder.append(fid.getUniq());
        return builder.toString();
    }

    public static boolean isFidString(String fid) {
        return fid != null && FID_PATTERN.matcher(fid).matches();
    }

    public static void validateFid(String fid) throws IOException {
        if (!MapRFileSystem.isFidString(fid)) {
            throw new IOException(fid + ": Incorrect fid format");
        }
    }

    public void createSymbolicLink(Path target, Path link) throws IOException {
        int err = this.createSymlink(target.toString(), link, false);
        if (err != 0) {
            throw new IOException("Failed to create symbolic link: " + link + " -> " + target + "." + "Error: " + Errno.toString(err));
        }
    }

    public Inode openTable(Path tableURI, MapRHTable htable) throws IOException {
        Inode table;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create mapr client for " + tableURI);
            }
            MapRFileSystem.initError(err);
            table = clusterData.client.openTable(tableName, err, htable, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            tableURI = new Path(err.trailpath);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        return table;
    }

    public String createTable(Path tableURI, String user, Dbserver.TableAttr attr, Dbserver.TableAces aces, byte[][] splitKeys, boolean needServerInfo) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        String server = null;
        int mode = MapRClientImpl.getModeBits(FsPermission.getDefault(), this.getConf());
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            server = clusterData.client.createTable(tableName, user, attr, aces, mode, splitKeys, needServerInfo, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to create table: " + tableName + " , Error: Operation not permitted, need license with MapR-DB support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new IOException("Failed to create table: " + tableName + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
        return server;
    }

    public void createTable(Path tableURI, String user, Dbserver.TableAttr attr, AceHelper.DBPermission dbperm) throws IOException {
        this.createTable(tableURI, user, attr, AceHelper.getTablePermission(dbperm), null, false);
    }

    public void createTable(Path tableURI, String user) throws IOException {
        this.createTable(tableURI, user, Dbserver.TableAttr.getDefaultInstance(), Dbserver.TableAces.getDefaultInstance(), null, false);
    }

    public void createTable(Path tableURI) throws IOException {
        this.createTable(tableURI, null, Dbserver.TableAttr.getDefaultInstance(), Dbserver.TableAces.getDefaultInstance(), null, false);
    }

    public void createTable(Path tableURI, String user, byte[][] splitKeys) throws IOException {
        this.createTable(tableURI, user, Dbserver.TableAttr.getDefaultInstance(), Dbserver.TableAces.getDefaultInstance(), splitKeys, false);
    }

    public void createTable(Path tableURI, byte[][] splitKeys, boolean isBulkLoad) throws IOException {
        Dbserver.TableAttr ta = Dbserver.TableAttr.getDefaultInstance();
        ta = ta.toBuilder().setBulkLoad(isBulkLoad).build();
        this.createTable(tableURI, null, ta, Dbserver.TableAces.getDefaultInstance(), splitKeys, false);
    }

    public Dbserver.TabletLookupResponse getTablets(Path tableURI, byte[] stKey) throws IOException {
        Dbserver.TabletLookupResponse lookupResp;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            lookupResp = clusterData.client.getTablets(tableName, stKey, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            tableURI = new Path(err.trailpath);
            tableName = this.getName(tableURI);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            String stKeyStr = new String(stKey, "UTF-8");
            throw new IOException("Failed to get tablets on table: " + tableName + " with startkey " + stKeyStr + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
        return lookupResp;
    }

    public void createColumnFamily(Path tableURI, String name, Dbserver.ColumnFamilyAttr schFamily, AceHelper.DBPermission dbperm) throws IOException {
        this.createColumnFamily(tableURI, name, schFamily.toBuilder().addAllAces(AceHelper.getCfPermission(dbperm)).build());
    }

    public void createColumnFamily(Path tableURI, String name, Dbserver.ColumnFamilyAttr schFamily) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.createColumnFamily(tableName, name, schFamily, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to create columnfamily on table: " + tableName + " with name " + name + ", Error: Operation not permitted, need license with MapR-DB support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new IOException("Failed to create columnfamily on table: " + tableName + " with name " + name + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
    }

    public void modifyColumnFamily(Path tableURI, String name, Dbserver.ColumnFamilyAttr schFamily, AceHelper.DBPermission dbperm) throws IOException {
        this.modifyColumnFamily(tableURI, name, schFamily.toBuilder().addAllAces(AceHelper.getCfPermission(dbperm)).build());
    }

    public void modifyColumnFamily(Path tableURI, String name, Dbserver.ColumnFamilyAttr cfAttr) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.modifyColumnFamily(tableName, name, cfAttr, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to modify columnfamily on table: " + tableName + " with name " + name + ", Error: Operation not permitted, need license with MapR-DB support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new IOException("Failed to modify columnfamily on table: " + tableName + " with name " + name + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
    }

    public void deleteColumnFamily(Path tableURI, String name) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.deleteColumnFamily(tableName, name, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to delete columnfamily on table: " + tableName + " with name " + name + ", Error: Operation not permitted, need license with MapR-DB support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new IOException("Failed to delete columnfamily on table: " + tableName + " with name " + name + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
    }

    public List<Dbserver.ColumnFamilyAttr> listColumnFamily(Path tableURI, boolean wantAces) throws IOException {
        List<Dbserver.ColumnFamilyAttr> colFamilyList;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            colFamilyList = clusterData.client.listColumnFamily(tableName, wantAces, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            tableURI = new Path(err.trailpath);
            tableName = this.getName(tableURI);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new IOException("Failed to list columnfamily on table: " + tableName + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
        return colFamilyList;
    }

    public void modifyTableAttr(Path tableURI, Dbserver.TableAttr am, AceHelper.DBPermission dbperm) throws IOException {
        this.modifyTableAttr(tableURI, am, AceHelper.getTablePermission(dbperm), false);
    }

    public void modifyTableAttr(Path tableURI, Dbserver.TableAttr am, AceHelper.DBPermission dbperm, boolean genUuid) throws IOException {
        this.modifyTableAttr(tableURI, am, AceHelper.getTablePermission(dbperm), genUuid);
    }

    public void modifyTableAttr(Path tableURI, Dbserver.TableAttr am, Dbserver.TableAces aces) throws IOException {
        this.modifyTableAttr(tableURI, am, aces, false);
    }

    public void modifyTableAttr(Path tableURI, Dbserver.TableAttr am, Dbserver.TableAces aces, boolean genUuid) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.modifyTableAttr(tableName, am, aces, genUuid, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to modify attribute on table: " + tableName + ", Error: Operation not permitted, need license with MapR-DB support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new IOException("Failed to modify attribute on table: " + tableName + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
    }

    public TableProperties getTableAttr(Path tableURI) throws IOException {
        TableProperties tableProp;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            tableProp = clusterData.client.getTableAttr(tableName, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            tableURI = new Path(err.trailpath);
            tableName = this.getName(tableURI);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new IOException("Failed to list attributes on table: " + tableName + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
        return tableProp;
    }

    public void splitTableRegion(Path tableURI, String fidstr, boolean ignoreRegionTooSmallError) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.splitTableRegion(fidstr, ignoreRegionTooSmallError, err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to split region of table: " + tableName + ", Error: Operation not permitted, need license with MapR-DB support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new IOException("Failed to split region of table: " + tableName + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
    }

    public void packTableRegion(Path tableURI, String fidstr, int ctype) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.packTableRegion(fidstr, ctype, err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to pack region of table: " + tableName + ", Error: Operation not permitted, need license with MapR-DB support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new IOException("Failed to pack region of table: " + tableName + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
    }

    public void mergeTableRegion(Path tableURI, String fidstr) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.mergeTableRegion(fidstr, err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to merge region of table: " + tableName + ", Error: Operation not permitted, need license with MapR-DB support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new IOException("Failed to merge region of table: " + tableName + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
    }

    public MapRTabletScanner getTabletScanner(Path tableURI) throws IOException {
        MapRTabletScanner scanner = new MapRTabletScanner(this, tableURI);
        return scanner;
    }

    public byte[] getContainerInfo(Path path, List<Integer> cidList) throws IOException {
        ClusterData clusterData = this.lookupClient(path);
        if (clusterData == null) {
            LOG.error((Object)("Failed to create maprclient for path " + path));
            return null;
        }
        int[] cids = new int[cidList.size()];
        for (int i = 0; i < cidList.size(); ++i) {
            cids[i] = cidList.get(i);
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        MapRFileSystem.initError(err);
        byte[] resp = clusterData.client.getContainerInfo(cids, err, this.userInfo);
        if (err.error != 0 || resp == null) {
            LOG.error((Object)("Failed to get containerinfo for path " + path.toString() + "error " + err.error));
        }
        return resp;
    }

    public MapRTabletScanner getTabletScanner(Path tableURI, byte[] startKey) throws IOException {
        MapRTabletScanner scanner = new MapRTabletScanner(this, tableURI, startKey);
        return scanner;
    }

    public Dbserver.TabletStatResponse getTabletStat(Path tablePath, Common.FidMsg tabletFid) throws IOException {
        ClusterData clusterData = this.lookupClient(tablePath);
        if (clusterData == null) {
            throw new IOException("Failed to create maprclient for path: " + tablePath.toString());
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        MapRFileSystem.initError(err);
        Dbserver.TabletStatResponse resp = clusterData.client.getTabletStat(tabletFid, err);
        if (err.error != 0 || resp == null) {
            String fid = tabletFid.getCid() + "." + tabletFid.getCinum() + "." + tabletFid.getUniq();
            throw new IOException("Failed to get tablet stat for fid: " + fid);
        }
        return resp;
    }

    public void addTableReplica(Path tableURI, Dbserver.TableReplicaDesc desc) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.addTableReplica(tableName, desc, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to add replica for table: " + tableName + ", Error: Operation not permitted, " + "need M7/H7 license with DB Replication " + "support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new IOException("Failed to add replica for table: " + tableName + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
    }

    public void editTableReplica(Path tableURI, String clusterName, String replicaPath, boolean allowAllCfs, Dbserver.TableReplicaDesc desc) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.editTableReplica(tableName, clusterName, replicaPath, allowAllCfs, desc, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to edit replica for table: " + tableName + ", Error: Operation not permitted, " + "need M7/H7 license with ACE support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new IOException("Failed to edit replica for table: " + tableName + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
    }

    public Dbserver.TableReplicaListResponse listTableReplicas(Path tableURI, boolean wantStats, boolean refreshNow) throws IOException {
        Dbserver.TableReplicaListResponse resp;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            resp = clusterData.client.listTableReplicas(tableName, wantStats, refreshNow, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            tableURI = new Path(err.trailpath);
            tableName = this.getName(tableURI);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new IOException("Failed to list replicas for table: " + tableName + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
        return resp;
    }

    public void removeTableReplica(Path tableURI, Dbserver.TableReplicaDesc desc) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.removeTableReplica(tableName, desc, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to remove replica for table: " + tableName + ", Error: Operation not permitted, " + "need M7/H7 license with ACE support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new IOException("Failed to remove replica for table: " + tableName + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
    }

    public void addTableUpstream(Path tableURI, Dbserver.TableUpstreamDesc desc) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.addTableUpstream(tableName, desc, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to add upstream for table: " + tableName + ", Error: Operation not permitted, " + "need M7/H7 license with DB Replication " + "support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new IOException("Failed to add upstream for table: " + tableName + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
    }

    public Dbserver.TableUpstreamListResponse listTableUpstreams(Path tableURI) throws IOException {
        Dbserver.TableUpstreamListResponse resp;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            resp = clusterData.client.listTableUpstreams(tableName, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            tableURI = new Path(err.trailpath);
            tableName = this.getName(tableURI);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new IOException("Failed to list upstreams for table: " + tableName + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
        return resp;
    }

    public void removeTableUpstream(Path tableURI, Dbserver.TableUpstreamDesc desc) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.removeTableUpstream(tableName, desc, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to remove upstream for table: " + tableName + ", Error: Operation not permitted, " + "need M7/H7 license with ACE support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new IOException("Failed to remove upstream for table: " + tableName + ", Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
    }

    public String getServerForCid(int cid, String cluster) throws IOException {
        ClusterConf.ClusterEntry centry;
        ClusterData clusterData;
        if (cid < 0) {
            throw new IOException("Invalid cid: " + cid);
        }
        if (cluster == null || cluster.isEmpty()) {
            cluster = this.clusterName;
        }
        if ((clusterData = this.lookupClient(centry = clusterConf.getClusterEntryByName(this, cluster))) == null) {
            throw new IOException("Failed to create maprclient for cluster " + cluster);
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        MapRFileSystem.initError(err);
        String server = clusterData.client.getServerForCid(cid, err);
        if (err.error != 0 || server == null) {
            throw new IOException("Failed to get Server for cid: " + cid + ", cluster: " + cluster + " Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
        return server;
    }

    public String getClusterName(URI p) throws IOException {
        ClusterConf.ClusterEntry centry = clusterConf.getClusterByPath(this, p, this.uri, this.clusterName);
        if (centry != null) {
            return centry.getClusterName();
        }
        throw new IOException("Could not get cluster for " + this.uri + "Please check if $MAPR_HOME/conf/mapr-clusters.conf has valid entries.");
    }

    public String getServerForCid(int cid) throws IOException {
        return this.getServerForCid(cid, this.clusterName);
    }

    @Override
    public FSDataInputStream openFid2(PathId pfid, String file, int readAheadBytesHint) throws IOException {
        ClusterData clusterData;
        if (readAheadBytesHint < 0) {
            throw new IOException("readAheadBytesHint cannot be negative");
        }
        if (readAheadBytesHint == 0) {
            return this.openFid(pfid.getFid(), file, pfid.getIPs());
        }
        MapRFileSystem.validateFid(pfid.getFid());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("openFid2: " + pfid.toString() + (file != null ? "/" + file : "")));
        }
        if ((clusterData = this.lookupClient(clusterConf.getClusterEntryByName(this, this.clusterName))) == null) {
            throw new IOException("Failed to lookup cluster " + this.clusterName);
        }
        MapRFsInStream is = clusterData.client.openFid2(this.createPathId(), file, readAheadBytesHint, this.userInfo, this.statistics);
        return new MapRFsDataInputStream(is);
    }

    @Override
    public FSDataInputStream openFid(String fid, long[] ips, long chunkSize, long fileSize) throws IOException {
        MapRFileSystem.validateFid(fid);
        if (chunkSize < 0L) {
            throw new IOException("Incorrect chunkSize");
        }
        if (fileSize < 0L) {
            throw new IOException("Incorrect file size");
        }
        ClusterData clusterData = this.lookupClient(clusterConf.getClusterEntryByName(this, this.clusterName));
        if (clusterData == null) {
            return null;
        }
        MapRFsInStream is = clusterData.client.openFid(fid, ips, chunkSize, fileSize, this.userInfo, this.statistics);
        return new MapRFsDataInputStream(is);
    }

    @Override
    public FSDataInputStream openFid(String pfid, String file, long[] ips) throws IOException {
        MapRFileSystem.validateFid(pfid);
        if (file == null || file.isEmpty()) {
            throw new IOException("Invalid file");
        }
        ClusterData clusterData = this.lookupClient(clusterConf.getClusterEntryByName(this, this.clusterName));
        if (clusterData == null) {
            return null;
        }
        MapRFsInStream is = clusterData.client.openFid(pfid, file, ips, this.userInfo, this.statistics);
        return new MapRFsDataInputStream(is);
    }

    @Override
    public FSDataOutputStream createFid(String pfid, String file) throws IOException {
        MapRFileSystem.validateFid(pfid);
        if (file == null || file.isEmpty()) {
            throw new IOException("Invalid file");
        }
        ClusterData clusterData = this.lookupClient(clusterConf.getClusterEntryByName(this, this.clusterName));
        if (clusterData == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createFid: " + pfid + " / " + file));
        }
        MapRFsOutStream os = clusterData.client.createFid(pfid, file, this.shouldUseDefaultBlockSize(), MapRClientImpl.getModeBits(FsPermission.getDefault(), this.getConf()), this.chunkSize, this.userInfo, this.statistics);
        return new MapRFsDataOutputStream(os);
    }

    @Override
    public boolean deleteFid(String pfid, String dir) throws IOException {
        MapRFileSystem.validateFid(pfid);
        ClusterData clusterData = this.lookupClient(clusterConf.getClusterEntryByName(this, this.clusterName));
        if (clusterData == null) {
            return false;
        }
        int error = clusterData.client.deleteFid(pfid, dir, this.userInfo);
        return error == 0;
    }

    @Override
    public String mkdirsFid(String pfid, String dir) throws IOException {
        MapRFileSystem.validateFid(pfid);
        if (dir == null || dir.isEmpty()) {
            throw new IOException("Invalid directory");
        }
        ClusterData clusterData = this.lookupClient(clusterConf.getClusterEntryByName(this, this.clusterName));
        if (clusterData == null) {
            throw new IOException("Unable to connect to MapR cluster!");
        }
        return clusterData.client.mkdirsFid(pfid, dir, this.shouldUseDefaultBlockSize(), MapRClientImpl.getModeBits(FsPermission.getDefault(), this.getConf()), true, this.chunkSize, this.userInfo);
    }

    @Override
    public String mkdirsFid(Path p) throws IOException {
        return this.makeDir(p, this.shouldUseDefaultBlockSize(), MapRClientImpl.getModeBits(FsPermission.getDefault(), this.getConf()), true, this.chunkSize, true, true);
    }

    public Path resolveTablePath(Path path) throws IOException {
        if (!this.exists(path)) {
            return null;
        }
        MapRFileStatus status = this.getMapRFileStatus(path);
        while (status.isSymlink()) {
            Path target = status.getSymlink();
            if (!target.isAbsolute()) {
                target = new Path(status.getPath().getParent(), target);
            }
            if (!this.exists(target)) {
                return null;
            }
            status = this.getMapRFileStatus(target);
        }
        return status.isTable() ? status.getPath() : null;
    }

    public boolean isTable(Path path) throws IOException {
        return this.resolveTablePath(path) != null;
    }

    public String GatewaySourceToString(int source) {
        if (source == Dbserver.GatewayLookupSource.GW_SOURCE_DNS.getNumber()) {
            return "DNS";
        }
        if (source == Dbserver.GatewayLookupSource.GW_SOURCE_CLDB.getNumber()) {
            return "CLDB";
        }
        if (source == Dbserver.GatewayLookupSource.GW_SOURCE_CONF.getNumber()) {
            return "mapr-clusters.conf";
        }
        return "None";
    }

    public IPPort[] getGatewayIps(String file, String dstCluster, boolean skipCache, GatewaySource source) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        IPPort[] ipPorts = null;
        String fileName = this.getName(new Path(file));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(new Path(file))) == null) {
                LOG.error((Object)("Failed to get cluster info for file: " + file));
                throw new IOException("Invalid cluster provided");
            }
            MapRFileSystem.initError(err);
            ipPorts = clusterData.client.getGatewayIps(fileName, dstCluster, skipCache, source, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                file = err.trailpath;
                fileName = this.getName(new Path(file));
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to get gateway Ips. Error: Operation not permitted, need license with MapR-DB support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error == 104) {
            throw new IOException("No valid gateways found. Source tried: " + this.GatewaySourceToString(source.source));
        }
        if (err.error != 0) {
            throw new IOException("Failed to get gateway Ips, Error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
        return ipPorts;
    }

    public IPPort[] getGatewayIps(String file) throws IOException {
        return this.getGatewayIps(file, null, false, null);
    }

    void setStatistics(FileSystem.Statistics stats) {
        this.statistics = stats;
    }

    public boolean getClusterNameUnique() {
        return this.clusterNameUnique;
    }

    public List<ClusterConf.ClusterEntry> getClusterList() {
        return this.localClusterList;
    }

    static {
        ShimLoader.load();
        FileSystem.enableSymlinks();
        LOG = LogFactory.getLog(MapRFileSystem.class);
        FID_PATTERN = Pattern.compile("[0-9]+.[0-9]+.[0-9]+");
        FID_SPLITTER = Pattern.compile("\\.");
        clusterConf = new ClusterConf();
        clusterTable = new HashMap<String, ClusterData>();
        numInstances = 0;
        initialized = false;
        disableNameCache_ = false;
        emptyStringArray = new String[0];
    }

    public static class TableProperties {
        private Dbserver.TableAces aces;
        private Dbserver.TableAttr attr;
        private byte[] uuid;

        TableProperties(Dbserver.TableAttr attr, Dbserver.TableAces aces, byte[] uuid) {
            this.aces = aces;
            this.attr = attr;
            this.uuid = uuid;
        }

        public Dbserver.TableAttr getAttr() {
            return this.attr;
        }

        public Dbserver.TableAces getAces() {
            return this.aces;
        }

        public byte[] getUuid() {
            return this.uuid;
        }
    }

    private class ClusterData {
        public MapRClientImpl client;

        public ClusterData(MapRClientImpl client) {
            this.client = client;
        }
    }
}

