/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.jni.JNIFileStatus;
import com.mapr.fs.jni.MapRConstants;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;

public class MapRFileStatus
extends FileStatus
implements MapRConstants {
    private Path path;
    private FsPermission permission;
    private Path symlink;
    private JNIFileStatus internalStatus;

    public MapRFileStatus() {
        this(new JNIFileStatus());
    }

    public MapRFileStatus(String dir, long time) {
        this(new JNIFileStatus(dir, time));
    }

    public MapRFileStatus(JNIFileStatus proxy) {
        this(proxy, "maprfs");
    }

    public MapRFileStatus(JNIFileStatus proxy, String scheme) {
        this.internalStatus = proxy;
        this.permission = new FsPermission(proxy.mode);
        this.symlink = proxy.symlink != null ? new Path(proxy.symlink) : null;
        this.path = new Path(scheme, proxy.authority, proxy.pathStr);
    }

    public boolean getCompress() {
        return this.internalStatus.compress;
    }

    public String getCompressionName() {
        return this.internalStatus.compressionName;
    }

    public String getCompressString() {
        if (!this.getCompress()) {
            return " U";
        }
        String compName = this.getCompressionName();
        if (compName.equals("lzf")) {
            return " L";
        }
        if (compName.equals("zlib")) {
            return " z";
        }
        return " Z";
    }

    public String getWireSecurity() {
        if (this.internalStatus.wireSecurityEnabled) {
            return " E";
        }
        return " U";
    }

    public int getCid() {
        return this.internalStatus.cid;
    }

    public int getCinum() {
        return this.internalStatus.cinum;
    }

    public int getUniq() {
        return this.internalStatus.uniq;
    }

    public String getFidStr() {
        return this.internalStatus.cid + "." + this.internalStatus.cinum + "." + this.internalStatus.uniq;
    }

    public String getVolName() {
        return this.internalStatus.volInfo != null ? this.internalStatus.volInfo.name : null;
    }

    public int getVolLinkAttrType() {
        return this.internalStatus.volInfo != null ? this.internalStatus.volInfo.linkAttrType : 0;
    }

    @Override
    public long getLen() {
        return this.internalStatus.length;
    }

    @Override
    public boolean isDir() {
        return this.internalStatus.isdir;
    }

    @Override
    public boolean isDirectory() {
        return this.isDir();
    }

    @Override
    public boolean isFile() {
        return !this.isDir() && !this.isSymlink();
    }

    public boolean isRegular() {
        return this.internalStatus.isRegular;
    }

    public boolean isVol() {
        return this.internalStatus.volInfo != null;
    }

    public JNIFileStatus.VolumeInfo getVolumeInfo() {
        return this.internalStatus.volInfo;
    }

    @Override
    public boolean isTable() {
        return this.internalStatus.isTable;
    }

    @Override
    public long getBlockSize() {
        return this.internalStatus.chunkSize;
    }

    @Override
    public short getReplication() {
        return this.internalStatus.block_replication;
    }

    @Override
    public long getModificationTime() {
        return this.internalStatus.modification_time;
    }

    @Override
    public long getAccessTime() {
        return this.internalStatus.access_time;
    }

    @Override
    public FsPermission getPermission() {
        return this.permission;
    }

    @Override
    public String getOwner() {
        return this.internalStatus.owner;
    }

    @Override
    public String getGroup() {
        return this.internalStatus.group;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public void setPath(Path p) {
        this.path = p;
    }

    @Override
    protected void setPermission(FsPermission permission) {
        this.permission = permission == null ? FsPermission.getDefault() : permission;
    }

    @Override
    protected void setOwner(String owner) {
        this.internalStatus.owner = owner == null ? "" : owner;
    }

    @Override
    protected void setGroup(String group) {
        this.internalStatus.group = group == null ? "" : group;
    }

    @Override
    public boolean isSymlink() {
        return this.symlink != null;
    }

    @Override
    public Path getSymlink() throws IOException {
        if (!this.isSymlink()) {
            throw new IOException("Path " + this.path + " is not a symbolic link");
        }
        return this.symlink;
    }

    @Override
    public void setSymlink(Path p) {
        this.symlink = p;
    }

    private boolean compareFids(MapRFileStatus other) {
        return this.getCid() == other.getCid() && this.getCinum() == other.getCinum() && this.getUniq() == other.getUniq();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.getPath().toString());
        out.writeLong(this.internalStatus.length);
        out.writeBoolean(this.internalStatus.isdir);
        out.writeShort(this.internalStatus.block_replication);
        out.writeLong(this.internalStatus.chunkSize);
        out.writeLong(this.internalStatus.modification_time);
        out.writeLong(this.internalStatus.access_time);
        this.permission.write(out);
        Text.writeString(out, this.internalStatus.owner);
        Text.writeString(out, this.internalStatus.group);
        out.writeBoolean(this.isSymlink());
        if (this.isSymlink()) {
            Text.writeString(out, this.getSymlink().toString());
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        String strPath = Text.readString(in);
        this.path = new Path(strPath);
        this.internalStatus.length = in.readLong();
        this.internalStatus.isdir = in.readBoolean();
        this.internalStatus.block_replication = in.readShort();
        this.internalStatus.chunkSize = in.readLong();
        this.internalStatus.modification_time = in.readLong();
        this.internalStatus.access_time = in.readLong();
        this.permission.readFields(in);
        this.internalStatus.owner = Text.readString(in);
        this.internalStatus.group = Text.readString(in);
        this.symlink = in.readBoolean() ? new Path(Text.readString(in)) : null;
    }

    @Override
    public int compareTo(Object o) {
        FileStatus other = (FileStatus)o;
        return this.getPath().compareTo(other.getPath());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileStatus)) {
            return false;
        }
        FileStatus other = (FileStatus)o;
        return this.getPath().equals(other.getPath());
    }

    @Override
    public int hashCode() {
        return this.getPath().hashCode();
    }

    public static MapRFileStatus getStatus(JNIFileStatus status) {
        return MapRFileStatus.getStatus(status, "maprfs");
    }

    public static MapRFileStatus getStatus(JNIFileStatus status, String scheme) {
        if (status == null) {
            return null;
        }
        return new MapRFileStatus(status, scheme);
    }

    public static MapRFileStatus[] getStatus(JNIFileStatus[] statuses) {
        return MapRFileStatus.getStatus(statuses, "maprfs");
    }

    public static MapRFileStatus[] getStatus(JNIFileStatus[] statuses, String scheme) {
        if (statuses == null) {
            return null;
        }
        MapRFileStatus[] s2 = new MapRFileStatus[statuses.length];
        for (int i = 0; i < statuses.length; ++i) {
            s2[i] = new MapRFileStatus(statuses[i], scheme);
        }
        return s2;
    }
}

