/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.security.JNISecurity;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;

public class ClusterConf
implements MapRConstants {
    private static final Log LOG = LogFactory.getLog(ClusterConf.class);
    private String clusterConfFile;
    long cldbInfoRefreshPeriod = 600000L;
    private List<ClusterEntry> clusterList = new ArrayList<ClusterEntry>();

    public static long ipToLong(String addr) throws UnknownHostException {
        long result = 0L;
        String[] addrArray = InetAddress.getByName(addr).getHostAddress().split("\\.");
        for (int i = 3; i >= 0; --i) {
            result |= Long.parseLong(addrArray[3 - i]) << i * 8;
        }
        return result & 0xFFFFFFFFFFFFFFFFL;
    }

    private void addIpPortToList(List<IpPort> ipList, String addrArr, String cName) {
        for (String addr : addrArr.split(";")) {
            IpPort ipPort;
            if ((addr = addr.trim()).isEmpty()) continue;
            int idx = addr.indexOf(",");
            String hostname = null;
            if (idx != -1) {
                hostname = addr.substring(0, idx);
                addr = addr.substring(idx + 1);
            }
            if (addr.contains(":")) {
                String[] arr = addr.split(":");
                int port = Integer.parseInt(arr[1]);
                if (port < 0 || port > 65535) {
                    if (cName == null || cName.isEmpty()) continue;
                    System.err.println("Invalid port # for cluster " + cName);
                    continue;
                }
                ipPort = new IpPort(hostname, arr[0], port);
            } else {
                ipPort = new IpPort(hostname, addr, 7222);
            }
            ipList.add(ipPort);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClusterEntry(MapRFileSystem fs, String cName, String[] cldbLocations) {
        List<ClusterEntry> clusters = fs != null && !fs.getClusterNameUnique() ? fs.getClusterList() : this.clusterList;
        List<ClusterEntry> list = clusters;
        synchronized (list) {
            Iterator<ClusterEntry> iter = clusters.iterator();
            while (iter.hasNext()) {
                ClusterEntry centry = iter.next();
                if (!centry.getClusterName().equals(cName)) continue;
                iter.remove();
            }
            ArrayList<IpPort> ipList = new ArrayList<IpPort>();
            try {
                for (String cldb : cldbLocations) {
                    this.addIpPortToList(ipList, cldb, null);
                }
                if (ipList.size() != 0) {
                    ClusterEntry centry = new ClusterEntry(cName, ipList);
                    clusters.add(centry);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void updateClusterEntry(String cName, String[] cldbLocations) {
        this.updateClusterEntry(null, cName, cldbLocations);
    }

    public ClusterConf() {
        this.readAndUpdateCldbInfo(false, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readAndUpdateCldbInfo(boolean searchForSingleCluster, String searchClusterName, List<IpPort> inputIpList) {
        boolean foundSearchCluster = false;
        List<ClusterEntry> list = this.clusterList;
        synchronized (list) {
            String maprHome = System.getProperty("mapr.home.dir");
            if (maprHome == null && (maprHome = System.getenv("MAPR_HOME")) == null) {
                maprHome = "/opt/mapr/";
            }
            if (maprHome.startsWith("\"")) {
                maprHome = maprHome.substring(1, maprHome.length() - 1);
            }
            this.clusterConfFile = maprHome + "/conf/mapr-clusters.conf";
            try {
                FileReader fr = new FileReader(this.clusterConfFile);
                if (fr != null) {
                    String strLine;
                    BufferedReader b = new BufferedReader(fr);
                    while ((strLine = b.readLine()) != null) {
                        List<Object> ipList;
                        String[] tokens;
                        if ((strLine = strLine.trim()).isEmpty() || strLine.startsWith("#") || (tokens = strLine.split("[\\s]+")).length < 2) continue;
                        String clusterName = tokens[0];
                        if (searchForSingleCluster) {
                            if (!clusterName.equals(searchClusterName)) continue;
                            foundSearchCluster = true;
                            ipList = inputIpList;
                        } else {
                            ipList = new ArrayList();
                        }
                        for (int i = 1; i < tokens.length; ++i) {
                            if (tokens[i].contains("=")) {
                                String[] arr = tokens[i].split("=");
                                if (arr.length == 2 && JNISecurity.SetClusterOption(clusterName, arr[0], arr[1]) == 0) continue;
                                LOG.error((Object)("Invalid Conf options:" + tokens[i] + " for cluster " + clusterName));
                                continue;
                            }
                            this.addIpPortToList(ipList, tokens[i], clusterName);
                        }
                        if (!searchForSingleCluster && ipList.size() != 0) {
                            ClusterEntry centry = new ClusterEntry(clusterName, ipList);
                            this.clusterList.add(centry);
                        }
                        JNISecurity.SetParsingDone();
                        if (!foundSearchCluster) continue;
                        break;
                    }
                    b.close();
                    if (!foundSearchCluster) {
                        return -1;
                    }
                }
            }
            catch (FileNotFoundException fe) {
            }
            catch (Exception e) {
                this.clusterList.clear();
                System.err.println("Failed to build cluster list from " + this.clusterConfFile);
                System.err.println(e.getLocalizedMessage());
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterEntry getFirstClusterEntry(MapRFileSystem fs) {
        List<ClusterEntry> clusters = fs != null && !fs.getClusterNameUnique() ? fs.getClusterList() : this.clusterList;
        List<ClusterEntry> list = clusters;
        synchronized (list) {
            if (clusters.size() == 0) {
                return null;
            }
            return clusters.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterEntry getClusterEntryByAddr(MapRFileSystem fs, String ip, int port) {
        List<ClusterEntry> clusters = fs != null && !fs.getClusterNameUnique() ? fs.getClusterList() : this.clusterList;
        List<ClusterEntry> list = clusters;
        synchronized (list) {
            for (ClusterEntry centry : clusters) {
                for (IpPort ipPort : centry.getIpList()) {
                    if (!ipPort.getAddr().equalsIgnoreCase(ip) || ipPort.getPort() != port) continue;
                    return centry;
                }
            }
            ArrayList<IpPort> ipList = new ArrayList<IpPort>();
            IpPort ipPort = new IpPort("", ip, port);
            ipList.add(ipPort);
            String clusterName = ip + ":" + port;
            try {
                ClusterEntry centry = new ClusterEntry(clusterName, ipList);
                clusters.add(centry);
                return centry;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public ClusterEntry getClusterEntryByAddr(String ip, int port) {
        return this.getClusterEntryByAddr(null, ip, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterEntry getClusterEntryByName(MapRFileSystem fs, String clusterName) {
        List<ClusterEntry> clusters = fs != null && !fs.getClusterNameUnique() ? fs.getClusterList() : this.clusterList;
        List<ClusterEntry> list = clusters;
        synchronized (list) {
            for (ClusterEntry centry : clusters) {
                if (!centry.getClusterName().equals(clusterName)) continue;
                return centry;
            }
        }
        return null;
    }

    public ClusterEntry getClusterEntryByName(String clusterName) {
        return this.getClusterEntryByName(null, clusterName);
    }

    private int getPort(int port) {
        if (port < 0) {
            port = 7222;
        } else if (port == 0 || port > 65535) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Invalid port " + port + " specified in " + this.clusterConfFile + ", using default port " + 7222 + " instead"));
            }
            port = 7222;
        }
        return port;
    }

    public ClusterEntry getClusterByUri(MapRFileSystem fs, URI name) throws IOException {
        return this.fastClusterByPath(fs, name, null);
    }

    public ClusterEntry getClusterByUri(URI name) throws IOException {
        return this.getClusterByUri(null, name);
    }

    private ClusterEntry fastClusterByPath(MapRFileSystem fs, URI pathURI, String fsClusterName) throws IOException {
        ClusterEntry centry = null;
        if (pathURI.getHost() == null) {
            String exceptMsg = null;
            if (fsClusterName == null) {
                exceptMsg = "No default cluster in " + this.clusterConfFile;
                String rawPath = pathURI.getPath();
                if (rawPath.matches("^/mapr/.+")) {
                    String clusterName = rawPath.split("/")[2];
                    centry = this.getClusterEntryByName(clusterName);
                } else {
                    centry = this.getFirstClusterEntry(fs);
                }
            } else {
                exceptMsg = "Cluster " + fsClusterName + " not found in " + this.clusterConfFile;
                centry = this.getClusterEntryByName(fs, fsClusterName);
            }
            if (centry == null) {
                throw new IOException(exceptMsg);
            }
        } else if (pathURI.getPort() != -1) {
            centry = this.getClusterEntryByAddr(fs, pathURI.getHost(), this.getPort(pathURI.getPort()));
        } else {
            centry = this.getClusterEntryByName(fs, pathURI.getHost());
            if (centry == null) {
                centry = this.getClusterEntryByAddr(fs, pathURI.getHost(), 7222);
            }
        }
        return centry;
    }

    public ClusterEntry getClusterByPath(MapRFileSystem fs, URI p, URI fsUri, String fsClusterName) throws IOException {
        String rawPath = p.getPath();
        if (!rawPath.startsWith("/") || !rawPath.startsWith("/mapr")) {
            return this.fastClusterByPath(fs, p, fsClusterName);
        }
        if (rawPath.matches("^/mapr/.+")) {
            String clusterName = rawPath.split("/")[2];
            ClusterEntry centry = this.getClusterEntryByName(fs, clusterName);
            if (centry == null) {
                throw new IOException("Cluster " + clusterName + " has no entry in " + this.clusterConfFile);
            }
            return centry;
        }
        if (rawPath.equals("/mapr") || rawPath.equals("/mapr/")) {
            throw new IOException("Invalid path " + rawPath + ". " + "The correct format for fully-qualified names is: " + "/mapr/" + "<cluster>/<path>");
        }
        return this.fastClusterByPath(fs, p, fsClusterName);
    }

    public ClusterEntry getClusterByPath(URI p, URI fsUri, String fsClusterName) throws IOException {
        return this.getClusterByPath(null, p, fsUri, fsClusterName);
    }

    public List<ClusterEntry> getClusterList() {
        return this.clusterList;
    }

    public class ClusterEntry {
        private String clusterName;
        private List<IpPort> ipList;
        private long[] ips = null;
        long cldbInfoUpdatedTime;

        public ClusterEntry(String clusterName, List<IpPort> ipList) throws UnknownHostException {
            this.clusterName = clusterName;
            this.ipList = ipList;
            this.cldbInfoUpdatedTime = System.currentTimeMillis();
        }

        public String getClusterName() {
            return this.clusterName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rereadConf() throws IOException {
            ClusterEntry clusterEntry = this;
            synchronized (clusterEntry) {
                this.ipList.clear();
                if (ClusterConf.this.readAndUpdateCldbInfo(true, this.clusterName, this.ipList) == -1) {
                    throw new IOException("Could not resolve any CLDB hostnames for the cluster: " + this.clusterName);
                }
                this.ips = null;
                this.cldbInfoUpdatedTime = System.currentTimeMillis();
            }
            LOG.info((Object)("Updated centry for the cluster " + this.clusterName));
        }

        public List<IpPort> getIpList() {
            return this.ipList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long[] getIPs() throws IOException {
            long duration = System.currentTimeMillis() - this.cldbInfoUpdatedTime;
            if (duration >= ClusterConf.this.cldbInfoRefreshPeriod) {
                this.rereadConf();
            }
            if (this.ips == null) {
                ClusterEntry clusterEntry = this;
                synchronized (clusterEntry) {
                    ArrayList<Long> arr = new ArrayList<Long>();
                    for (IpPort ipPort : this.ipList) {
                        try {
                            long val = (ClusterConf.ipToLong(ipPort.getAddr()) << 32) + ((long)ipPort.getPort() & 0xFFFFL);
                            arr.add(val);
                        }
                        catch (UnknownHostException e) {
                            if (!LOG.isWarnEnabled()) continue;
                            LOG.warn((Object)("Could not resolve CLDB hostname " + ipPort.getAddr() + ", for cluster: " + this.clusterName));
                        }
                    }
                    if (!arr.isEmpty()) {
                        Collections.shuffle(arr);
                        this.ips = new long[arr.size()];
                        for (int i = 0; i < arr.size(); ++i) {
                            this.ips[i] = (Long)arr.get(i);
                        }
                    }
                }
            }
            if (this.ips == null) {
                throw new IOException("Could not resolve any CLDB hostnames for cluster: " + this.clusterName);
            }
            return this.ips;
        }
    }

    public class IpPort {
        private final String addr;
        private final int port;

        public IpPort(String hname, String addr, int port) {
            this.addr = addr == null || addr.length() == 0 ? hname : addr;
            this.port = port;
        }

        public String getAddr() {
            return this.addr;
        }

        public int getPort() {
            return this.port;
        }
    }
}

