/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.proto.Dbserver;
import com.mapr.security.UnixUserGroupHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import oadd.com.google.common.collect.ImmutableMap;
import oadd.com.google.protobuf.ByteString;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import oadd.org.json.JSONException;
import oadd.org.json.JSONObject;

public class AceHelper {
    public static final Log LOG = LogFactory.getLog(AceHelper.class);
    private static String CurrentPermission;
    private static int index;
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    private static final String APPENDPERM = "appendperm";
    private static final String BULKLOADPERM = "bulkloadperm";
    private static final String SPLITMERGEPERM = "splitmergeperm";
    private static final String COMPRESSIONPERM = "compressionperm";
    private static final String DELETEFAMILYPERM = "deletefamilyperm";
    private static final String ENCRYPTPERM = "encryptperm";
    private static final String MEMORYPERM = "memoryperm";
    private static final String CREATERENAMEFAMILYPERM = "createrenamefamilyperm";
    private static final String PACKPERM = "packperm";
    private static final String READPERM = "readperm";
    private static final String VERSIONSPERM = "versionperm";
    private static final String WRITEPERM = "writeperm";
    private static final String ACEADMINPERM = "adminaccessperm";
    private static final String REPLPERM = "replperm";
    private static final String VERSIONDEFAULTPERM = "defaultversionperm";
    private static final String COMPRESSIONDEFAULTPERM = "defaultcompressionperm";
    private static final String MEMORYDEFAULTPERM = "defaultmemoryperm";
    private static final String WRITEDEFAULTPERM = "defaultwriteperm";
    private static final String APPENDDEFAULTPERM = "defaultappendperm";
    private static final String READDEFAULTPERM = "defaultreadperm";
    private static final String ENCRYPTDEFAULTPERM = "defaultencryptperm";
    private static UnixUserGroupHelper ugHelper;
    public static final Map<Dbserver.DBAccessType, String> tblPermissionMap;
    public static final Map<String, Dbserver.DBAccessType> tblAccessTypeMap;
    public static final Map<Dbserver.DBAccessType, String> cfDefPermissionMap;
    public static final Map<Dbserver.DBAccessType, String> cfPermissionMap;
    public static final Map<String, Dbserver.DBAccessType> cfAccessTypeMap;
    public static final Map<Dbserver.DBAccessType, String> colPermissionMap;
    public static final Map<String, Dbserver.DBAccessType> colAccessTypeMap;
    public static final Set<String> TABLE_PERMISSIONS;
    public static final Set<String> FAMILY_PERMISSIONS;
    public static final Set<String> COLUMN_PERMISSIONS;

    public static String getPermissionsListForShellHelp() {
        return "  For tables:\n    \"splitmergeperm\"          Split and Merge Permission settings\n    \"bulkloadperm\"            Bulk load Permission settings\n    \"deletefamilyperm\"        Delete Family Permission settings\n    \"createrenamefamilyperm\"  Add/Rename Family Permission settings\n    \"packperm\"                Pack Permission settings\n    \"adminaccessperm\"         Modify Admin access Permission settings\n    \"replperm\"                Modfiy Replication Admin settings\n    \"defaultappendperm\"       CF Append Default Permission\n    \"defaultcompressionperm\"  CF Compression Default Permission\n    \"defaultencryptperm\"      CF Encrypt Default Permission\n    \"defaultmemoryperm\"       CF Memory Default Permission\n    \"defaultreadperm\"         CF Read Default Permission\n    \"defaultversionperm\"      CF Set Versions/TTL Default Permission\n    \"defaultwriteperm\"        CF Write Default Permission\n\n  For column families:\n    \"appendperm\"              Append Permissions\n    \"compressionperm\"         Compression Permissions\n    \"encryptperm\"             Encrypt Permissions\n    \"memoryperm\"              Memory Permissions\n    \"readperm\"                Read Permissions\n    \"versionperm\"             Set Versions/TTL Permissions\n    \"writeperm\"               Write Permissions\n\n  For column qualifiers:\n    \"appendperm\"              Append Permissions\n    \"encryptperm\"             Encrypt Permissions\n    \"readperm\"                Read Permissions\n    \"writeperm\"               Write Permissions";
    }

    public static String toInfix(String postfix) throws IOException {
        if (postfix == null || postfix.length() == 0) {
            return "";
        }
        Stack<String> expression = new Stack<String>();
        for (String token : postfix.split(" ")) {
            String opp;
            boolean isOper;
            if (token.equals("&")) {
                isOper = true;
                opp = "|";
            } else if (token.equals("|")) {
                isOper = true;
                opp = "&";
            } else if (token.equals("!")) {
                isOper = true;
                opp = "";
            } else {
                isOper = false;
                opp = "";
            }
            if (isOper) {
                if (expression.empty()) {
                    AceHelper.conversionError("Unbalanced expression");
                }
                String popped_expression = (String)expression.pop();
                if (!opp.equals("")) {
                    if (expression.empty()) {
                        AceHelper.conversionError("Unbalanced expression");
                    }
                    String popped_expression_2 = (String)expression.pop();
                    if (popped_expression.contains(opp) && !popped_expression.startsWith("!(")) {
                        popped_expression = "(" + popped_expression + ")";
                    }
                    if (popped_expression_2.contains(opp) && !popped_expression.startsWith("!(")) {
                        popped_expression_2 = "(" + popped_expression_2 + ")";
                    }
                    expression.push(popped_expression_2 + " " + token + " " + popped_expression);
                    continue;
                }
                if (popped_expression.contains("&") || popped_expression.contains("|")) {
                    expression.push(token + "(" + popped_expression + ")");
                    continue;
                }
                expression.push(token + popped_expression);
                continue;
            }
            if (token.isEmpty()) continue;
            expression.push(AceHelper.convertToName(token));
        }
        if (expression.size() != 1) {
            AceHelper.conversionError("Converting expression contains more expressions than operators");
        }
        return (String)expression.pop();
    }

    private static void conversionError(String message) throws IOException {
        throw new IOException("An error has occurred " + message);
    }

    public static String toPostfix(String permission) throws IOException {
        if (permission == null || permission.length() == 0) {
            return "";
        }
        if ((permission = permission.trim()).equals("p")) {
            return permission;
        }
        Stack<Character> operatorStack = new Stack<Character>();
        StringBuilder current = new StringBuilder();
        StringBuilder result = new StringBuilder(permission.length());
        int subexpr = 0;
        HashMap<Integer, Character> subexprOper = new HashMap<Integer, Character>();
        String operOrder = null;
        boolean expectOper = false;
        CurrentPermission = permission;
        for (int i = 0; i < permission.length(); ++i) {
            index = i;
            char ch = permission.charAt(i);
            operOrder = AceHelper.getOperatorPrecedence(Character.valueOf(ch));
            if (operOrder != null) {
                if (current.length() > 0) {
                    result.append((CharSequence)AceHelper.checkExpression(current));
                    current = new StringBuilder();
                    expectOper = true;
                }
                if (!operOrder.equals("")) {
                    if (operOrder.equals("!")) {
                        AceHelper.runCheck(expectOper || current.length() > 0, "Expected 'not' to proceed expression");
                    } else {
                        AceHelper.runCheck(!expectOper, "Expected expression, operator '" + ch + "' was given");
                        if (!subexprOper.containsKey(subexpr)) {
                            subexprOper.put(subexpr, Character.valueOf(ch));
                        } else {
                            AceHelper.runCheck(((Character)subexprOper.get(subexpr)).charValue() != ch, "Cannot combine & and | without using parenthesies ( )");
                        }
                    }
                    result.append((CharSequence)AceHelper.checkStack(operOrder, operatorStack));
                    expectOper = false;
                    operatorStack.push(Character.valueOf(ch));
                    continue;
                }
                if (ch == '(') {
                    AceHelper.runCheck(expectOper, "Expected parentheses to follow operator");
                    operatorStack.push(Character.valueOf(ch));
                    ++subexpr;
                    continue;
                }
                if (ch != ')') continue;
                AceHelper.runCheck(!expectOper, "Expected expression to proceed end parentheses");
                expectOper = true;
                result.append((CharSequence)AceHelper.checkStack("!&|", operatorStack));
                subexprOper.remove(subexpr);
                AceHelper.runCheck(--subexpr < 0, "Mismatched parenthesies");
                operatorStack.pop();
                continue;
            }
            AceHelper.runCheck(expectOper, "Expected operator and got expression instead");
            expectOper = false;
            current.append(ch);
        }
        if (current.length() > 0) {
            result.append((CharSequence)AceHelper.checkExpression(current));
            expectOper = true;
        }
        while (!operatorStack.empty()) {
            if (((Character)operatorStack.peek()).charValue() != '(') {
                result.append(" ");
                result.append(operatorStack.pop());
                continue;
            }
            operatorStack.pop();
        }
        AceHelper.runCheck(!expectOper, "Expression ended with operator");
        AceHelper.runCheck(subexpr != 0, "Mismatched parentheses");
        index = -1;
        CurrentPermission = null;
        return result.toString().trim();
    }

    private static StringBuilder checkStack(String validators, Stack<Character> oper) {
        StringBuilder result = new StringBuilder();
        while (!oper.empty() && validators.indexOf(oper.peek().charValue()) > -1) {
            result.append(" ");
            result.append(oper.pop());
        }
        return result;
    }

    private static String getOperatorPrecedence(Character ch) {
        switch (ch.charValue()) {
            case ' ': 
            case '(': 
            case ')': {
                return "";
            }
            case '&': {
                return "!&";
            }
            case '!': {
                return "!";
            }
            case '|': {
                return "!&|";
            }
        }
        return null;
    }

    private static String convertToName(String current) throws IOException {
        String idToName = current;
        if (ugHelper == null) {
            ugHelper = new UnixUserGroupHelper();
        }
        try {
            if (current.charAt(0) == 'u') {
                idToName = "u:" + ugHelper.getUsername(Integer.parseInt(current.substring(2)));
            } else if (current.charAt(0) == 'g') {
                idToName = "g:" + ugHelper.getGroupname(Integer.parseInt(current.substring(2)));
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("Error processing \"" + current + "\". Cannot extract uid/gid from this value.");
        }
        catch (SecurityException se) {
            LOG.error((Object)("Error processing ID: \"" + current + "\" : " + se.getMessage()));
            return current;
        }
        return idToName;
    }

    private static StringBuilder convertToId(StringBuilder current) throws IOException {
        if (ugHelper == null) {
            ugHelper = new UnixUserGroupHelper();
        }
        String id = current.substring(2);
        try {
            try {
                current = new StringBuilder(current.charAt(0) + ":" + Integer.parseInt(id));
            }
            catch (NumberFormatException e) {
                if (current.charAt(0) == 'u') {
                    current = new StringBuilder("u:" + ugHelper.getUserId(id));
                } else if (current.charAt(0) == 'g') {
                    current = new StringBuilder("g:" + ugHelper.getGroupId(id));
                }
            }
        }
        catch (SecurityException se) {
            throw new IOException("Error occured. " + se.getMessage());
        }
        return current;
    }

    private static StringBuilder checkExpression(StringBuilder current) throws IOException {
        AceHelper.runCheck("ugrp".indexOf(current.charAt(0)) == -1, "Expected permission to start with one of 'ugrp'");
        if (current.charAt(0) == 'p') {
            AceHelper.runCheck(true, "Expected 'p' to be by itself.");
        } else {
            AceHelper.runCheck(current.length() < 2 || current.charAt(1) != ':', "Expected ':' to follow 'urg'");
            AceHelper.runCheck(current.length() < 3, "Expected user/group/role name to follow ':'");
            if (current.charAt(0) != 'r') {
                current = AceHelper.convertToId(current);
            }
        }
        current.insert(0, " ");
        return current;
    }

    private static void runCheck(boolean check, String message) throws IOException {
        if (check) {
            throw new IOException("Error occured '" + CurrentPermission.substring(0, index) + ANSI_RED + "[" + ANSI_RESET + CurrentPermission.charAt(index) + ANSI_RED + "]" + ANSI_RESET + CurrentPermission.substring(index + 1) + "' at position '" + index + "'. " + message);
        }
    }

    public static ArrayList<Dbserver.AccessControlExpression> getColumnPermission(JSONObject json) throws IOException, JSONException {
        ArrayList<Dbserver.AccessControlExpression> ace = new ArrayList<Dbserver.AccessControlExpression>();
        for (Map.Entry<Dbserver.DBAccessType, String> entry : colPermissionMap.entrySet()) {
            String val = entry.getValue();
            if (!json.has(val)) continue;
            ace.add(Dbserver.AccessControlExpression.newBuilder().setAccessType(entry.getKey()).setBooleanExpression(ByteString.copyFromUtf8(AceHelper.toPostfix(json.getString(val)))).build());
        }
        return ace;
    }

    public static Dbserver.TableAces getTablePermission(DBPermission dbperm) throws IOException {
        return Dbserver.TableAces.newBuilder().addAllAces(AceHelper.getPermission(dbperm, tblPermissionMap)).addAllDefaultColumnFamilyAces(AceHelper.getPermission(dbperm, cfDefPermissionMap)).build();
    }

    public static ArrayList<Dbserver.AccessControlExpression> getColumnPermission(DBPermission dbperm) throws IOException {
        return AceHelper.getPermission(dbperm, colPermissionMap);
    }

    public static ArrayList<Dbserver.AccessControlExpression> getCfPermission(DBPermission dbperm) throws IOException {
        return AceHelper.getPermission(dbperm, cfPermissionMap);
    }

    private static ArrayList<Dbserver.AccessControlExpression> getPermission(DBPermission cliClass, Map<Dbserver.DBAccessType, String> permissionMap) throws IOException {
        ArrayList<Dbserver.AccessControlExpression> ace = new ArrayList<Dbserver.AccessControlExpression>();
        for (Map.Entry<Dbserver.DBAccessType, String> entry : permissionMap.entrySet()) {
            String val = cliClass.getCliParam(entry.getValue());
            if (val == null) continue;
            ace.add(Dbserver.AccessControlExpression.newBuilder().setAccessType(entry.getKey()).setBooleanExpression(ByteString.copyFromUtf8(AceHelper.toPostfix(val))).build());
        }
        return ace;
    }

    static {
        ugHelper = null;
        tblPermissionMap = new ImmutableMap.Builder<Dbserver.DBAccessType, String>().put(Dbserver.DBAccessType.ForcePack, PACKPERM).put(Dbserver.DBAccessType.SplitMerge, SPLITMERGEPERM).put(Dbserver.DBAccessType.SchemaAddRenameFamily, CREATERENAMEFAMILYPERM).put(Dbserver.DBAccessType.SchemaRemoveFamily, DELETEFAMILYPERM).put(Dbserver.DBAccessType.TableSchemaAceAdmin, ACEADMINPERM).put(Dbserver.DBAccessType.BulkLoad, BULKLOADPERM).put(Dbserver.DBAccessType.Repl, REPLPERM).build();
        tblAccessTypeMap = new ImmutableMap.Builder<String, Dbserver.DBAccessType>().put(PACKPERM, Dbserver.DBAccessType.ForcePack).put(SPLITMERGEPERM, Dbserver.DBAccessType.SplitMerge).put(CREATERENAMEFAMILYPERM, Dbserver.DBAccessType.SchemaAddRenameFamily).put(DELETEFAMILYPERM, Dbserver.DBAccessType.SchemaRemoveFamily).put(ACEADMINPERM, Dbserver.DBAccessType.TableSchemaAceAdmin).put(BULKLOADPERM, Dbserver.DBAccessType.BulkLoad).put(REPLPERM, Dbserver.DBAccessType.Repl).build();
        cfDefPermissionMap = new ImmutableMap.Builder<Dbserver.DBAccessType, String>().put(Dbserver.DBAccessType.FamilySetMinMaxVersions, VERSIONDEFAULTPERM).put(Dbserver.DBAccessType.FamilySetCompressions, COMPRESSIONDEFAULTPERM).put(Dbserver.DBAccessType.FamilyPinCFInMemory, MEMORYDEFAULTPERM).put(Dbserver.DBAccessType.FamilyReadData, READDEFAULTPERM).put(Dbserver.DBAccessType.FamilyWriteData, WRITEDEFAULTPERM).put(Dbserver.DBAccessType.FamilyAppendData, APPENDDEFAULTPERM).put(Dbserver.DBAccessType.FamilyEncryptData, ENCRYPTDEFAULTPERM).build();
        cfPermissionMap = new ImmutableMap.Builder<Dbserver.DBAccessType, String>().put(Dbserver.DBAccessType.FamilySetMinMaxVersions, VERSIONSPERM).put(Dbserver.DBAccessType.FamilySetCompressions, COMPRESSIONPERM).put(Dbserver.DBAccessType.FamilyPinCFInMemory, MEMORYPERM).put(Dbserver.DBAccessType.FamilyReadData, READPERM).put(Dbserver.DBAccessType.FamilyWriteData, WRITEPERM).put(Dbserver.DBAccessType.FamilyAppendData, APPENDPERM).put(Dbserver.DBAccessType.FamilyEncryptData, ENCRYPTPERM).build();
        cfAccessTypeMap = new ImmutableMap.Builder<String, Dbserver.DBAccessType>().put(VERSIONSPERM, Dbserver.DBAccessType.FamilySetMinMaxVersions).put(COMPRESSIONPERM, Dbserver.DBAccessType.FamilySetCompressions).put(MEMORYPERM, Dbserver.DBAccessType.FamilyPinCFInMemory).put(READPERM, Dbserver.DBAccessType.FamilyReadData).put(WRITEPERM, Dbserver.DBAccessType.FamilyWriteData).put(APPENDPERM, Dbserver.DBAccessType.FamilyAppendData).put(ENCRYPTPERM, Dbserver.DBAccessType.FamilyEncryptData).build();
        colPermissionMap = new ImmutableMap.Builder<Dbserver.DBAccessType, String>().put(Dbserver.DBAccessType.ColumnReadData, READPERM).put(Dbserver.DBAccessType.ColumnWriteData, WRITEPERM).put(Dbserver.DBAccessType.ColumnAppendData, APPENDPERM).put(Dbserver.DBAccessType.ColumnEncrypt, ENCRYPTPERM).build();
        colAccessTypeMap = new ImmutableMap.Builder<String, Dbserver.DBAccessType>().put(READPERM, Dbserver.DBAccessType.ColumnReadData).put(WRITEPERM, Dbserver.DBAccessType.ColumnWriteData).put(APPENDPERM, Dbserver.DBAccessType.ColumnAppendData).put(ENCRYPTPERM, Dbserver.DBAccessType.ColumnEncrypt).build();
        TABLE_PERMISSIONS = new HashSet<String>(){
            {
                this.addAll(tblPermissionMap.values());
                this.addAll(cfDefPermissionMap.values());
            }
        };
        FAMILY_PERMISSIONS = new HashSet<String>(){
            {
                this.addAll(cfPermissionMap.values());
            }
        };
        COLUMN_PERMISSIONS = new HashSet<String>(){
            {
                this.addAll(colPermissionMap.values());
            }
        };
    }

    public static interface DBPermission {
        public String getCliParam(String var1) throws IOException;
    }
}

