/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.threadpool;

import com.mapr.baseutils.threadpool.HealthCheck;
import com.mapr.baseutils.threadpool.ThreadPoolGrowth;
import com.mapr.baseutils.threadpool.TimeStampedRunnableTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import oadd.org.apache.log4j.Logger;

public class GrowingThreadPool
extends ThreadPoolExecutor
implements HealthCheck {
    ThreadPoolGrowth[] growth;
    String poolName;
    ThreadPoolGrowth[] tmpGrowth;
    int minPoolSize;
    int curGrowthIndex;
    int curPoolSize;
    int backLog;
    long busySince;
    int maxPoolSize;
    long lastMsgPrintTime;
    private static final Logger LOG = Logger.getLogger(GrowingThreadPool.class);

    public GrowingThreadPool(String name, int numThreads, ThreadPoolGrowth[] growth) {
        super(numThreads, numThreads, Long.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new MyThreadFactory(name));
        this.poolName = name;
        this.growth = growth;
        this.tmpGrowth = null;
        this.backLog = 5;
        this.minPoolSize = this.getCorePoolSize();
        this.curGrowthIndex = 0;
        this.curPoolSize = this.minPoolSize;
        this.busySince = System.currentTimeMillis();
        this.maxPoolSize = Integer.MAX_VALUE;
        this.lastMsgPrintTime = 0L;
    }

    boolean needsIncrease(long waitTime) {
        if (this.curPoolSize >= this.maxPoolSize) {
            long curTime = System.currentTimeMillis();
            if (curTime - this.lastMsgPrintTime > 15000L) {
                this.lastMsgPrintTime = curTime;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Queue size of " + this.poolName + " is " + this.getQueue().size() + " wait time is " + waitTime + "ms"));
                }
            }
            return false;
        }
        return waitTime >= (long)this.growth[this.curGrowthIndex].getIncrementWaitTime();
    }

    void increaseThreadPoolSize() {
        if (this.curPoolSize >= this.maxPoolSize) {
            return;
        }
        int incrementBy = this.growth[this.curGrowthIndex].getIncrement();
        int waitTime = this.growth[this.curGrowthIndex].getIncrementWaitTime();
        this.curPoolSize += incrementBy;
        if (this.curPoolSize > this.maxPoolSize) {
            this.curPoolSize = this.maxPoolSize;
        }
        while (this.curPoolSize >= this.growth[this.curGrowthIndex + 1].getCurSize()) {
            ++this.curGrowthIndex;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Increasing pool size for " + this.poolName + " to " + this.curPoolSize + ", after waiting " + waitTime + "ms"));
        }
        this.setMaximumPoolSize(this.curPoolSize);
        this.setCorePoolSize(this.curPoolSize);
    }

    boolean needsDecrease(long waitTime) {
        return this.curPoolSize > this.minPoolSize && waitTime >= (long)this.growth[this.curGrowthIndex].getDecrementWaitTime();
    }

    void decreaseThreadPoolSize() {
        int decrementBy = this.growth[this.curGrowthIndex].getDecrement();
        int waitTime = this.growth[this.curGrowthIndex].getDecrementWaitTime();
        int newGrowthIndex = this.curGrowthIndex;
        int newPoolSize = this.curPoolSize - decrementBy;
        if (newPoolSize < this.minPoolSize) {
            newPoolSize = this.minPoolSize;
        }
        while (newPoolSize < this.growth[newGrowthIndex].getCurSize()) {
            if (newGrowthIndex == 0) {
                LOG.warn((Object)("decreaseThreadPoolSize: cannot reduce pool size for " + this.poolName + " since new thread pool size is too small"));
                return;
            }
            --newGrowthIndex;
        }
        this.curPoolSize = newPoolSize;
        this.curGrowthIndex = newGrowthIndex;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Reducing pool size for " + this.poolName + " to " + this.curPoolSize + ", after waiting " + waitTime + "ms"));
        }
        this.setCorePoolSize(this.curPoolSize);
        this.setMaximumPoolSize(this.curPoolSize);
    }

    void modifyGrowthRate() {
        if (this.tmpGrowth == null) {
            return;
        }
        if (this.tmpGrowth.length < 2) {
            LOG.warn((Object)("modifyGrowthRate: ignoring the new growth rate for " + this.poolName + " since new growth rate array is too small"));
            this.tmpGrowth = null;
            return;
        }
        int i = 0;
        while (this.curPoolSize >= this.tmpGrowth[i + 1].getCurSize()) {
            if (++i != this.tmpGrowth.length - 1) continue;
            LOG.warn((Object)("modifyGrowthRate: ignoring the new growth rate for " + this.poolName + " since new growth rate is invalid"));
            this.tmpGrowth = null;
            return;
        }
        this.growth = this.tmpGrowth;
        this.curGrowthIndex = i;
        this.tmpGrowth = null;
    }

    @Override
    public void healthCheck() {
        this.modifyGrowthRate();
        TimeStampedRunnableTask task = (TimeStampedRunnableTask)this.getQueue().peek();
        long curTime = System.currentTimeMillis();
        if (task != null) {
            this.busySince = curTime;
            if (this.needsIncrease(curTime - task.arrTime())) {
                this.increaseThreadPoolSize();
            }
        } else if (this.needsDecrease(curTime - this.busySince)) {
            this.busySince = curTime;
            this.decreaseThreadPoolSize();
        }
    }

    public void changeGrowthRate(ThreadPoolGrowth[] newGrowth) {
        this.tmpGrowth = newGrowth;
    }

    public void setMaxPoolSize(int maxSize) {
        this.maxPoolSize = maxSize;
    }

    public void setBacklog(int val) {
        this.backLog = val;
    }

    public int getNumOfFreeSlots() {
        return this.maxPoolSize - this.getActiveCount() + (this.backLog - this.getQueue().size());
    }

    public boolean canProcessRequest() {
        if (this.curPoolSize < this.maxPoolSize) {
            return true;
        }
        if (this.getActiveCount() < this.curPoolSize) {
            return true;
        }
        return this.getQueue().size() < this.backLog;
    }

    static class MyThreadFactory
    implements ThreadFactory {
        int thrCount = 0;
        String thrPrefix;

        MyThreadFactory(String poolName) {
            this.thrPrefix = poolName + "-";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Thread newThread(Runnable r) {
            int thrId = 0;
            MyThreadFactory myThreadFactory = this;
            synchronized (myThreadFactory) {
                ++this.thrCount;
                thrId = this.thrCount;
            }
            try {
                return new Thread(r, this.thrPrefix + thrId);
            }
            catch (OutOfMemoryError oom) {
                LOG.fatal((Object)"Unable to create new thread, exiting the process");
                System.exit(1);
                return null;
            }
        }
    }
}

