/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import oadd.org.apache.log4j.Appender;
import oadd.org.apache.log4j.BasicConfigurator;
import oadd.org.apache.log4j.ConsoleAppender;
import oadd.org.apache.log4j.Layout;
import oadd.org.apache.log4j.Logger;
import oadd.org.apache.log4j.TTCCLayout;

public class TimeTrace {
    private static final String DATE_FOMRAT = "yyyy-MM-dd HH:mm:ss,SSS";
    private static final Logger LOG = Logger.getLogger(TimeTrace.class);
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private static boolean shouldLog = false;
    private static boolean shouldPrint = true;
    private static ThreadLocal<Long> threshold_ = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return 0L;
        }
    };
    private static ThreadLocal<Map<String, Long>> traceMap = new ThreadLocal<Map<String, Long>>(){

        @Override
        protected Map<String, Long> initialValue() {
            return new HashMap<String, Long>();
        }
    };

    public static void setShouldLog(boolean shouldLog) {
        TimeTrace.shouldLog = shouldLog;
    }

    public static void setShouldPrint(boolean shouldPrint) {
        TimeTrace.shouldPrint = shouldPrint;
    }

    public static void setThreshold(long threshold) {
        threshold_.set(threshold);
    }

    public static void startTrace(String traceName) {
        TimeTrace.startTrace(traceName, threshold_.get());
    }

    public static void startTrace(String traceName, long threshold) {
        if (threshold > 0L) {
            Map<String, Long> map = traceMap.get();
            map.put(traceName, System.nanoTime());
        }
    }

    public static void endTrace(String traceName) {
        TimeTrace.endTrace(traceName, threshold_.get(), null, (Object[])null);
    }

    public static void endTrace(String traceName, long threshold) {
        TimeTrace.endTrace(traceName, threshold, null, (Object[])null);
    }

    public static void endTrace(String traceName, String msg, Object ... args) {
        TimeTrace.endTrace(traceName, threshold_.get(), msg, args);
    }

    public static void endTrace(String traceName, long threshold, String msg, Object ... args) {
        if (threshold > 0L) {
            long endTime = System.nanoTime();
            Map<String, Long> map = traceMap.get();
            Long startTime = map.remove(traceName);
            if (startTime != null) {
                long timeInMilliSec = (endTime - startTime) / 1000000L;
                if (timeInMilliSec >= threshold) {
                    String traceMessage = String.format("[Trace '%s' duration: %dms] %s", traceName, timeInMilliSec, msg == null ? "" : String.format(msg, args));
                    if (shouldPrint) {
                        System.out.println(String.format("%s %s", df.format(System.currentTimeMillis()), traceMessage));
                    }
                    if (shouldLog) {
                        LOG.info((Object)traceMessage);
                    }
                }
            } else {
                String traceMessage = String.format("Trace '%s' was not started.", traceName);
                if (shouldPrint) {
                    System.out.println(String.format("%s [Trace Warning] %s", df.format(System.currentTimeMillis()), traceMessage));
                }
                if (shouldLog) {
                    LOG.warn((Object)traceMessage);
                }
            }
        }
    }

    public static void main(String[] args) {
        TTCCLayout layout = new TTCCLayout(DATE_FOMRAT);
        layout.setCategoryPrefixing(false);
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)layout));
        TimeTrace.setShouldLog(true);
        TimeTrace.setShouldPrint(false);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(50, 50, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(50, true), new ThreadPoolExecutor.CallerRunsPolicy());
        while (true) {
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    TimeTrace.setThreshold(500L);
                    TimeTrace.startTrace("XYZ");
                    TimeTrace.startTrace("ABC");
                    try {
                        Thread.sleep((int)(Math.random() * 1000.0));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    TimeTrace.endTrace("ABC", "" + Thread.currentThread().getId(), new Object[0]);
                    TimeTrace.endTrace("XYZ", "Thread='%s', Key='%s'", Thread.currentThread().getName(), "DADASD");
                }
            });
        }
    }
}

