/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import hive.com.google.common.base.Function;
import hive.org.apache.calcite.plan.hep.HepRelVertex;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.metadata.BuiltInMetadata;
import hive.org.apache.calcite.rel.metadata.Metadata;
import hive.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMdUniqueKeys;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.util.BitSets;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.ImmutableBitSet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.plan.ColStatistics;

public class HiveRelMdUniqueKeys {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.UNIQUE_KEYS.method, new HiveRelMdUniqueKeys());

    public Set<ImmutableBitSet> getUniqueKeys(Project rel, boolean ignoreNulls) {
        HiveTableScan tScan = HiveRelMdUniqueKeys.getTableScan(rel.getInput(), false);
        if (tScan == null) {
            Function<RelNode, Metadata> fn = RelMdUniqueKeys.SOURCE.apply(rel.getClass(), BuiltInMetadata.UniqueKeys.class);
            return ((BuiltInMetadata.UniqueKeys)fn.apply(rel)).getUniqueKeys(ignoreNulls);
        }
        HashMap<Integer, Integer> posMap = new HashMap<Integer, Integer>();
        int projectPos = 0;
        int colStatsPos = 0;
        BitSet projectedCols = new BitSet();
        for (RexNode r : rel.getProjects()) {
            if (r instanceof RexInputRef) {
                projectedCols.set(((RexInputRef)r).getIndex());
                posMap.put(colStatsPos, projectPos);
                ++colStatsPos;
            }
            ++projectPos;
        }
        double numRows = tScan.getRows();
        List<ColStatistics> colStats = tScan.getColStat(BitSets.toList(projectedCols));
        HashSet<ImmutableBitSet> keys = new HashSet<ImmutableBitSet>();
        colStatsPos = 0;
        for (ColStatistics cStat : colStats) {
            boolean isKey = false;
            if ((double)cStat.getCountDistint() >= numRows) {
                isKey = true;
            }
            if (!isKey && cStat.getRange() != null && cStat.getRange().maxValue != null && cStat.getRange().minValue != null) {
                double r = cStat.getRange().maxValue.doubleValue() - cStat.getRange().minValue.doubleValue() + 1.0;
                boolean bl = isKey = Math.abs(numRows - r) < 1.0E-5;
            }
            if (isKey) {
                ImmutableBitSet key = ImmutableBitSet.of((Integer)posMap.get(colStatsPos));
                keys.add(key);
            }
            ++colStatsPos;
        }
        return keys;
    }

    static HiveTableScan getTableScan(RelNode r, boolean traverseProject) {
        while (r != null && !(r instanceof HiveTableScan)) {
            if (r instanceof HepRelVertex) {
                r = ((HepRelVertex)r).getCurrentRel();
                continue;
            }
            if (r instanceof Filter) {
                r = ((Filter)r).getInput();
                continue;
            }
            if (traverseProject && r instanceof Project) {
                r = ((Project)r).getInput();
                continue;
            }
            r = null;
        }
        return r == null ? null : (HiveTableScan)r;
    }
}

