/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.InvalidRelException;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelCollations;
import hive.org.apache.calcite.rel.RelDistribution;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.RelWriter;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.util.ImmutableBitSet;
import hive.org.apache.calcite.util.ImmutableIntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveCostModel;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveDefaultCostModel;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;

public class HiveJoin
extends Join
implements HiveRelNode {
    public static final RelFactories.JoinFactory HIVE_JOIN_FACTORY = new HiveJoinFactoryImpl();
    private final boolean leftSemiJoin;
    private final HiveCalciteUtil.JoinPredicateInfo joinPredInfo = HiveCalciteUtil.JoinPredicateInfo.constructJoinPredicateInfo(this);
    private HiveCostModel.JoinAlgorithm joinAlgorithm;
    private RelOptCost joinCost;

    public static HiveJoin getJoin(RelOptCluster cluster, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, boolean leftSemiJoin) {
        try {
            Set<String> variablesStopped = Collections.emptySet();
            HiveJoin join = new HiveJoin(cluster, null, left, right, condition, joinType, variablesStopped, HiveDefaultCostModel.DefaultJoinAlgorithm.INSTANCE, leftSemiJoin);
            return join;
        }
        catch (InvalidRelException e) {
            throw new RuntimeException(e);
        }
    }

    protected HiveJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped, HiveCostModel.JoinAlgorithm joinAlgo, boolean leftSemiJoin) throws InvalidRelException {
        super(cluster, TraitsUtil.getDefaultTraitSet(cluster), left, right, condition, joinType, variablesStopped);
        this.joinAlgorithm = joinAlgo;
        this.leftSemiJoin = leftSemiJoin;
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }

    @Override
    public final HiveJoin copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        try {
            Set<String> variablesStopped = Collections.emptySet();
            return new HiveJoin(this.getCluster(), traitSet, left, right, conditionExpr, joinType, variablesStopped, this.joinAlgorithm, this.leftSemiJoin);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    public HiveCalciteUtil.JoinPredicateInfo getJoinPredicateInfo() {
        return this.joinPredInfo;
    }

    public void setJoinAlgorithm(HiveCostModel.JoinAlgorithm joinAlgorithm) {
        this.joinAlgorithm = joinAlgorithm;
    }

    public HiveCostModel.JoinAlgorithm getJoinAlgorithm() {
        return this.joinAlgorithm;
    }

    public ImmutableList<RelCollation> getCollation() {
        return this.joinAlgorithm.getCollation(this);
    }

    public RelDistribution getDistribution() {
        return this.joinAlgorithm.getDistribution(this);
    }

    public Double getMemory() {
        return this.joinAlgorithm.getMemory(this);
    }

    public Double getCumulativeMemoryWithinPhaseSplit() {
        return this.joinAlgorithm.getCumulativeMemoryWithinPhaseSplit(this);
    }

    public Boolean isPhaseTransition() {
        return this.joinAlgorithm.isPhaseTransition(this);
    }

    public Integer getSplitCount() {
        return this.joinAlgorithm.getSplitCount(this);
    }

    public MapJoinStreamingRelation getStreamingSide() {
        Double leftInputSize = RelMetadataQuery.memory(this.left);
        Double rightInputSize = RelMetadataQuery.memory(this.right);
        if (leftInputSize == null && rightInputSize == null) {
            return MapJoinStreamingRelation.NONE;
        }
        if (leftInputSize != null && (rightInputSize == null || leftInputSize < rightInputSize)) {
            return MapJoinStreamingRelation.RIGHT_RELATION;
        }
        if (rightInputSize != null && (leftInputSize == null || rightInputSize <= leftInputSize)) {
            return MapJoinStreamingRelation.LEFT_RELATION;
        }
        return MapJoinStreamingRelation.NONE;
    }

    public RelNode getStreamingInput() {
        MapJoinStreamingRelation mapJoinStreamingSide = this.getStreamingSide();
        RelNode smallInput = mapJoinStreamingSide == MapJoinStreamingRelation.LEFT_RELATION ? this.getRight() : (mapJoinStreamingSide == MapJoinStreamingRelation.RIGHT_RELATION ? this.getLeft() : null);
        return smallInput;
    }

    public ImmutableBitSet getSortedInputs() {
        ImmutableBitSet.Builder sortedInputsBuilder = new ImmutableBitSet.Builder();
        HiveCalciteUtil.JoinPredicateInfo joinPredInfo = HiveCalciteUtil.JoinPredicateInfo.constructJoinPredicateInfo(this);
        ArrayList<ImmutableIntList> joinKeysInChildren = new ArrayList<ImmutableIntList>();
        joinKeysInChildren.add(ImmutableIntList.copyOf(joinPredInfo.getProjsFromLeftPartOfJoinKeysInChildSchema()));
        joinKeysInChildren.add(ImmutableIntList.copyOf(joinPredInfo.getProjsFromRightPartOfJoinKeysInChildSchema()));
        for (int i = 0; i < this.getInputs().size(); ++i) {
            boolean correctOrderFound = RelCollations.contains(RelMetadataQuery.collations(this.getInputs().get(i)), (ImmutableIntList)joinKeysInChildren.get(i));
            if (!correctOrderFound) continue;
            sortedInputsBuilder.set(i);
        }
        return sortedInputsBuilder.build();
    }

    public void setJoinCost(RelOptCost joinCost) {
        this.joinCost = joinCost;
    }

    public boolean isLeftSemiJoin() {
        return this.leftSemiJoin;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return RelMetadataQuery.getNonCumulativeCost(this);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("algorithm", this.joinAlgorithm == null ? "none" : this.joinAlgorithm).item("cost", this.joinCost == null ? "not available" : this.joinCost);
    }

    @Override
    public RelDataType deriveRowType() {
        if (this.leftSemiJoin) {
            return HiveJoin.deriveJoinRowType(this.left.getRowType(), null, JoinRelType.INNER, this.getCluster().getTypeFactory(), null, Collections.emptyList());
        }
        return super.deriveRowType();
    }

    private static class HiveJoinFactoryImpl
    implements RelFactories.JoinFactory {
        private HiveJoinFactoryImpl() {
        }

        @Override
        public RelNode createJoin(RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped, boolean semiJoinDone) {
            return HiveJoin.getJoin(left.getCluster(), left, right, condition, joinType, false);
        }
    }

    public static enum MapJoinStreamingRelation {
        NONE,
        LEFT_RELATION,
        RIGHT_RELATION;

    }
}

