/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import hive.org.apache.calcite.util.ImmutableBitSet;
import hive.org.apache.calcite.util.Util;
import java.util.ArrayList;
import java.util.List;

public class HiveRelOptUtil
extends RelOptUtil {
    public static RexNode splitJoinCondition(List<RelDataTypeField> sysFieldList, RelNode leftRel, RelNode rightRel, RexNode condition, List<RexNode> leftJoinKeys, List<RexNode> rightJoinKeys, List<Integer> filterNulls, List<SqlOperator> rangeOp) {
        return HiveRelOptUtil.splitJoinCondition(sysFieldList, ImmutableList.of(leftRel, rightRel), condition, ImmutableList.of(leftJoinKeys, rightJoinKeys), filterNulls, rangeOp);
    }

    public static RexNode splitJoinCondition(List<RelDataTypeField> sysFieldList, List<RelNode> inputs, RexNode condition, List<List<RexNode>> joinKeys, List<Integer> filterNulls, List<SqlOperator> rangeOp) {
        ArrayList<RexNode> nonEquiList = new ArrayList<RexNode>();
        HiveRelOptUtil.splitJoinCondition(sysFieldList, inputs, condition, joinKeys, filterNulls, rangeOp, nonEquiList);
        return RexUtil.composeConjunction(inputs.get(0).getCluster().getRexBuilder(), nonEquiList, false);
    }

    private static void splitJoinCondition(List<RelDataTypeField> sysFieldList, List<RelNode> inputs, RexNode condition, List<List<RexNode>> joinKeys, List<Integer> filterNulls, List<SqlOperator> rangeOp, List<RexNode> nonEquiList) {
        int sysFieldCount = sysFieldList.size();
        RelOptCluster cluster = inputs.get(0).getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RelDataTypeFactory typeFactory = cluster.getTypeFactory();
        int[] firstFieldInputs = new int[inputs.size()];
        int totalFieldCount = 0;
        for (int i = 0; i < inputs.size(); ++i) {
            firstFieldInputs[i] = totalFieldCount + sysFieldCount;
            totalFieldCount += sysFieldCount + inputs.get(i).getRowType().getFieldCount();
        }
        int[] adjustments = new int[totalFieldCount];
        for (int i = 0; i < inputs.size(); ++i) {
            int limit = i == inputs.size() - 1 ? totalFieldCount : firstFieldInputs[i + 1];
            for (int j = firstFieldInputs[i]; j < limit; ++j) {
                adjustments[j] = -firstFieldInputs[i];
            }
        }
        if (condition instanceof RexCall) {
            RexCall call = (RexCall)condition;
            if (call.getOperator() == SqlStdOperatorTable.AND) {
                for (RexNode operand : call.getOperands()) {
                    HiveRelOptUtil.splitJoinCondition(sysFieldList, inputs, operand, joinKeys, filterNulls, rangeOp, nonEquiList);
                }
                return;
            }
            RexNode leftKey = null;
            RexNode rightKey = null;
            int leftInput = 0;
            int rightInput = 0;
            List<RelDataTypeField> leftFields = null;
            List<RelDataTypeField> rightFields = null;
            boolean reverse = false;
            SqlKind kind = call.getKind();
            if (kind == SqlKind.EQUALS || filterNulls != null && kind == SqlKind.IS_NOT_DISTINCT_FROM || rangeOp != null && rangeOp.isEmpty() && (kind == SqlKind.GREATER_THAN || kind == SqlKind.GREATER_THAN_OR_EQUAL || kind == SqlKind.LESS_THAN || kind == SqlKind.LESS_THAN_OR_EQUAL)) {
                List<RexNode> operands = call.getOperands();
                RexNode op0 = operands.get(0);
                RexNode op1 = operands.get(1);
                ImmutableBitSet projRefs0 = RelOptUtil.InputFinder.bits(op0);
                ImmutableBitSet projRefs1 = RelOptUtil.InputFinder.bits(op1);
                boolean foundBothInputs = false;
                for (int i = 0; i < inputs.size() && !foundBothInputs; ++i) {
                    int upperLimit;
                    int lowerLimit = firstFieldInputs[i];
                    int n = upperLimit = i == inputs.size() - 1 ? totalFieldCount : firstFieldInputs[i + 1];
                    if (projRefs0.nextSetBit(lowerLimit) != -1 && projRefs0.nextSetBit(upperLimit) == -1 && projRefs0.nextSetBit(0) == projRefs0.nextSetBit(lowerLimit) && projRefs0.nextSetBit(lowerLimit) < upperLimit) {
                        if (leftKey == null) {
                            leftKey = op0;
                            leftInput = i;
                            leftFields = inputs.get(leftInput).getRowType().getFieldList();
                            continue;
                        }
                        rightKey = op0;
                        rightInput = i;
                        rightFields = inputs.get(rightInput).getRowType().getFieldList();
                        reverse = true;
                        foundBothInputs = true;
                        continue;
                    }
                    if (projRefs1.nextSetBit(lowerLimit) == -1 || projRefs1.nextSetBit(upperLimit) != -1 || projRefs1.nextSetBit(0) != projRefs1.nextSetBit(lowerLimit) || projRefs1.nextSetBit(lowerLimit) >= upperLimit) continue;
                    if (leftKey == null) {
                        leftKey = op1;
                        leftInput = i;
                        leftFields = inputs.get(leftInput).getRowType().getFieldList();
                        continue;
                    }
                    rightKey = op1;
                    rightInput = i;
                    rightFields = inputs.get(rightInput).getRowType().getFieldList();
                    foundBothInputs = true;
                }
                if (leftKey != null && rightKey != null) {
                    RelDataType rightKeyType;
                    rightKey = rightKey.accept(new RelOptUtil.RexInputConverter(rexBuilder, rightFields, rightFields, adjustments));
                    RelDataType leftKeyType = (leftKey = leftKey.accept(new RelOptUtil.RexInputConverter(rexBuilder, leftFields, leftFields, adjustments))).getType();
                    if (leftKeyType != (rightKeyType = rightKey.getType())) {
                        RelDataType targetKeyType = typeFactory.leastRestrictive(ImmutableList.of(leftKeyType, rightKeyType));
                        if (targetKeyType == null) {
                            throw Util.newInternal("Cannot find common type for join keys " + leftKey + " (type " + leftKeyType + ") and " + rightKey + " (type " + rightKeyType + ")");
                        }
                        if (leftKeyType != targetKeyType) {
                            leftKey = rexBuilder.makeCast(targetKeyType, leftKey);
                        }
                        if (rightKeyType != targetKeyType) {
                            rightKey = rexBuilder.makeCast(targetKeyType, rightKey);
                        }
                    }
                }
            }
            if (rangeOp == null && (leftKey == null || rightKey == null)) {
                ImmutableBitSet projRefs = RelOptUtil.InputFinder.bits(condition);
                leftKey = null;
                rightKey = null;
                boolean foundInput = false;
                for (int i = 0; i < inputs.size() && !foundInput; ++i) {
                    int upperLimit;
                    int lowerLimit = firstFieldInputs[i];
                    int n = upperLimit = i == inputs.size() - 1 ? totalFieldCount : firstFieldInputs[i + 1];
                    if (projRefs.nextSetBit(lowerLimit) >= upperLimit) continue;
                    leftInput = i;
                    leftFields = inputs.get(leftInput).getRowType().getFieldList();
                    leftKey = condition.accept(new RelOptUtil.RexInputConverter(rexBuilder, leftFields, leftFields, adjustments));
                    rightKey = rexBuilder.makeLiteral(true);
                    kind = SqlKind.EQUALS;
                    foundInput = true;
                }
            }
            if (leftKey != null && rightKey != null) {
                HiveRelOptUtil.addJoinKey(joinKeys.get(leftInput), leftKey, rangeOp != null && !rangeOp.isEmpty());
                HiveRelOptUtil.addJoinKey(joinKeys.get(rightInput), rightKey, rangeOp != null && !rangeOp.isEmpty());
                if (filterNulls != null && kind == SqlKind.EQUALS) {
                    filterNulls.add(joinKeys.get(leftInput).size() - 1);
                }
                if (rangeOp != null && kind != SqlKind.EQUALS && kind != SqlKind.IS_DISTINCT_FROM) {
                    if (reverse) {
                        kind = HiveRelOptUtil.reverse(kind);
                    }
                    rangeOp.add(HiveRelOptUtil.op(kind, call.getOperator()));
                }
                return;
            }
        }
        nonEquiList.add(condition);
    }

    private static SqlKind reverse(SqlKind kind) {
        switch (kind) {
            case GREATER_THAN: {
                return SqlKind.LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlKind.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return SqlKind.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlKind.GREATER_THAN_OR_EQUAL;
            }
        }
        return kind;
    }

    private static SqlOperator op(SqlKind kind, SqlOperator operator) {
        switch (kind) {
            case EQUALS: {
                return SqlStdOperatorTable.EQUALS;
            }
            case NOT_EQUALS: {
                return SqlStdOperatorTable.NOT_EQUALS;
            }
            case GREATER_THAN: {
                return SqlStdOperatorTable.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return SqlStdOperatorTable.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
            }
            case IS_DISTINCT_FROM: {
                return SqlStdOperatorTable.IS_DISTINCT_FROM;
            }
            case IS_NOT_DISTINCT_FROM: {
                return SqlStdOperatorTable.IS_NOT_DISTINCT_FROM;
            }
        }
        return operator;
    }

    private static void addJoinKey(List<RexNode> joinKeyList, RexNode key, boolean preserveLastElementInList) {
        if (!joinKeyList.isEmpty() && preserveLastElementInList) {
            joinKeyList.add(joinKeyList.size() - 1, key);
        } else {
            joinKeyList.add(key);
        }
    }
}

