/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import hive.com.google.common.cache.Cache;
import hive.com.google.common.cache.CacheBuilder;
import hive.com.google.common.collect.Lists;
import hive.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.StatsProvidingRecordReader;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.Metadata;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcRawRecordMerger;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.ql.io.orc.StripeStatistics;
import org.apache.hadoop.hive.ql.io.orc.VectorizedOrcAcidRowReader;
import org.apache.hadoop.hive.ql.io.orc.VectorizedOrcInputFormat;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.StringUtils;

public class OrcInputFormat
implements InputFormat<NullWritable, OrcStruct>,
InputFormatChecker,
VectorizedInputFormatInterface,
AcidInputFormat<NullWritable, OrcStruct>,
CombineHiveInputFormat.AvoidSplitCombination {
    private static final Log LOG = LogFactory.getLog(OrcInputFormat.class);
    private static boolean isDebugEnabled = LOG.isDebugEnabled();
    static final HadoopShims SHIMS = ShimLoader.getHadoopShims();
    static final String MIN_SPLIT_SIZE = SHIMS.getHadoopConfNames().get("MAPREDMINSPLITSIZE");
    static final String MAX_SPLIT_SIZE = SHIMS.getHadoopConfNames().get("MAPREDMAXSPLITSIZE");
    private static final long DEFAULT_MIN_SPLIT_SIZE = 0x1000000L;
    private static final long DEFAULT_MAX_SPLIT_SIZE = 0x10000000L;
    private static final PerfLogger perfLogger = PerfLogger.getPerfLogger();
    private static final String CLASS_NAME = ReaderImpl.class.getName();
    private static final double MIN_INCLUDED_LOCATION = 0.8;

    @Override
    public boolean shouldSkipCombine(Path path, Configuration conf) throws IOException {
        return conf.get("hive.doing.acid") != null || AcidUtils.isAcid(path, conf);
    }

    private static int getRootColumn(boolean isOriginal) {
        return isOriginal ? 0 : 6;
    }

    public static RecordReader createReaderFromFile(Reader file, Configuration conf, long offset, long length) throws IOException {
        Reader.Options options = new Reader.Options().range(offset, length);
        boolean isOriginal = OrcInputFormat.isOriginal(file);
        List<OrcProto.Type> types = file.getTypes();
        options.include(OrcInputFormat.genIncludedColumns(types, conf, isOriginal));
        OrcInputFormat.setSearchArgument(options, types, conf, isOriginal);
        return file.rowsOptions(options);
    }

    public static boolean isOriginal(Reader file) {
        return !file.hasMetadataValue("hive.acid.key.index");
    }

    private static void includeColumnRecursive(List<OrcProto.Type> types, boolean[] result, int typeId, int rootColumn) {
        result[typeId - rootColumn] = true;
        OrcProto.Type type = types.get(typeId);
        int children = type.getSubtypesCount();
        for (int i = 0; i < children; ++i) {
            OrcInputFormat.includeColumnRecursive(types, result, type.getSubtypes(i), rootColumn);
        }
    }

    public static boolean[] genIncludedColumns(List<OrcProto.Type> types, List<Integer> included, boolean isOriginal) {
        int rootColumn = OrcInputFormat.getRootColumn(isOriginal);
        int numColumns = types.size() - rootColumn;
        boolean[] result = new boolean[numColumns];
        result[0] = true;
        OrcProto.Type root = types.get(rootColumn);
        for (int i = 0; i < root.getSubtypesCount(); ++i) {
            if (!included.contains(i)) continue;
            OrcInputFormat.includeColumnRecursive(types, result, root.getSubtypes(i), rootColumn);
        }
        return result;
    }

    public static boolean[] genIncludedColumns(List<OrcProto.Type> types, Configuration conf, boolean isOriginal) {
        if (!ColumnProjectionUtils.isReadAllColumns(conf)) {
            List<Integer> included = ColumnProjectionUtils.getReadColumnIDs(conf);
            return OrcInputFormat.genIncludedColumns(types, included, isOriginal);
        }
        return null;
    }

    public static String[] getSargColumnNames(String[] originalColumnNames, List<OrcProto.Type> types, boolean[] includedColumns, boolean isOriginal) {
        int rootColumn = OrcInputFormat.getRootColumn(isOriginal);
        String[] columnNames = new String[types.size() - rootColumn];
        int i = 0;
        for (int columnId : types.get(rootColumn).getSubtypesList()) {
            if (includedColumns != null && !includedColumns[columnId - rootColumn]) continue;
            columnNames[columnId - rootColumn] = originalColumnNames[i++];
        }
        return columnNames;
    }

    static void setSearchArgument(Reader.Options options, List<OrcProto.Type> types, Configuration conf, boolean isOriginal) {
        String columnNamesString = conf.get("hive.io.file.readcolumn.names");
        if (columnNamesString == null) {
            LOG.debug((Object)"No ORC pushdown predicate - no column names");
            options.searchArgument(null, null);
            return;
        }
        SearchArgument sarg = SearchArgumentFactory.createFromConf(conf);
        if (sarg == null) {
            LOG.debug((Object)"No ORC pushdown predicate");
            options.searchArgument(null, null);
            return;
        }
        LOG.info((Object)("ORC pushdown predicate: " + sarg));
        options.searchArgument(sarg, OrcInputFormat.getSargColumnNames(columnNamesString.split(","), types, options.getInclude(), isOriginal));
    }

    @Override
    public boolean validateInput(FileSystem fs, HiveConf conf, ArrayList<FileStatus> files) throws IOException {
        if (Utilities.isVectorMode(conf)) {
            return new VectorizedOrcInputFormat().validateInput(fs, conf, files);
        }
        if (files.size() <= 0) {
            return false;
        }
        for (FileStatus file : files) {
            try {
                OrcFile.createReader(file.getPath(), OrcFile.readerOptions(conf).filesystem(fs));
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    static Path[] getInputPaths(Configuration conf) throws IOException {
        String dirs = conf.get("mapred.input.dir");
        if (dirs == null) {
            throw new IOException("Configuration mapred.input.dir is not defined.");
        }
        String[] list = StringUtils.split((String)dirs);
        Path[] result = new Path[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = new Path(StringUtils.unEscapeString((String)list[i]));
        }
        return result;
    }

    static List<OrcSplit> generateSplitsInfo(Configuration conf) throws IOException {
        Context context = new Context(conf);
        ArrayList<OrcSplit> splits = Lists.newArrayList();
        ArrayList<Future<?>> pathFutures = Lists.newArrayList();
        ArrayList<Future<?>> splitFutures = Lists.newArrayList();
        for (Path dir : OrcInputFormat.getInputPaths(conf)) {
            FileSystem fs = dir.getFileSystem(conf);
            FileGenerator fileGenerator = new FileGenerator(context, fs, dir);
            pathFutures.add(Context.threadPool.submit(fileGenerator));
        }
        try {
            for (Future future : pathFutures) {
                SplitStrategy splitStrategy = (SplitStrategy)future.get();
                if (isDebugEnabled) {
                    LOG.debug((Object)splitStrategy);
                }
                if (splitStrategy instanceof ETLSplitStrategy) {
                    List splitInfos = splitStrategy.getSplits();
                    for (SplitInfo splitInfo : splitInfos) {
                        splitFutures.add(Context.threadPool.submit(new SplitGenerator(splitInfo)));
                    }
                    continue;
                }
                splits.addAll(splitStrategy.getSplits());
            }
            for (Future future : splitFutures) {
                splits.addAll((Collection)future.get());
            }
        }
        catch (Exception e) {
            OrcInputFormat.cancelFutures(pathFutures);
            OrcInputFormat.cancelFutures(splitFutures);
            throw new RuntimeException("serious problem", e);
        }
        if (context.cacheStripeDetails) {
            LOG.info((Object)("FooterCacheHitRatio: " + context.cacheHitCounter.get() + "/" + context.numFilesCounter.get()));
        }
        if (isDebugEnabled) {
            for (OrcSplit orcSplit : splits) {
                LOG.debug((Object)((Object)((Object)orcSplit) + " projected_columns_uncompressed_size: " + orcSplit.getProjectedColumnsUncompressedSize()));
            }
        }
        return splits;
    }

    private static void cancelFutures(List<Future<?>> futures) {
        for (Future<?> future : futures) {
            future.cancel(true);
        }
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        perfLogger.PerfLogBegin(CLASS_NAME, "OrcGetSplits");
        List<OrcSplit> result = OrcInputFormat.generateSplitsInfo((Configuration)job);
        perfLogger.PerfLogEnd(CLASS_NAME, "OrcGetSplits");
        return result.toArray(new InputSplit[result.size()]);
    }

    private org.apache.hadoop.mapred.RecordReader<NullWritable, OrcStruct> createVectorizedReader(InputSplit split, JobConf conf, Reporter reporter) throws IOException {
        return new VectorizedOrcInputFormat().getRecordReader(split, conf, reporter);
    }

    public org.apache.hadoop.mapred.RecordReader<NullWritable, OrcStruct> getRecordReader(InputSplit inputSplit, JobConf conf, Reporter reporter) throws IOException {
        boolean vectorMode = Utilities.isVectorMode((Configuration)conf);
        if (inputSplit.getClass() == FileSplit.class) {
            if (vectorMode) {
                return this.createVectorizedReader(inputSplit, conf, reporter);
            }
            return new OrcRecordReader(OrcFile.createReader(((FileSplit)inputSplit).getPath(), OrcFile.readerOptions((Configuration)conf)), (Configuration)conf, (FileSplit)inputSplit);
        }
        OrcSplit split = (OrcSplit)inputSplit;
        reporter.setStatus(inputSplit.toString());
        AcidInputFormat.Options options = new AcidInputFormat.Options((Configuration)conf).reporter(reporter);
        AcidInputFormat.RowReader<OrcStruct> inner = this.getReader(inputSplit, options);
        if (split.isOriginal() && split.getDeltas().isEmpty()) {
            if (vectorMode) {
                return this.createVectorizedReader(inputSplit, conf, reporter);
            }
            return new NullKeyRecordReader(inner, (Configuration)conf);
        }
        if (vectorMode) {
            return new VectorizedOrcAcidRowReader(inner, (Configuration)conf, (FileSplit)inputSplit);
        }
        return new NullKeyRecordReader(inner, (Configuration)conf);
    }

    @Override
    public AcidInputFormat.RowReader<OrcStruct> getReader(InputSplit inputSplit, AcidInputFormat.Options options) throws IOException {
        Reader reader;
        int bucket;
        OrcSplit split = (OrcSplit)inputSplit;
        Path path = split.getPath();
        Path root = split.hasBase() ? (split.isOriginal() ? path.getParent() : path.getParent().getParent()) : path;
        Path[] deltas = AcidUtils.deserializeDeltas(root, split.getDeltas());
        Configuration conf = options.getConfiguration();
        Reader.Options readOptions = new Reader.Options();
        readOptions.range(split.getStart(), split.getLength());
        if (split.hasBase()) {
            bucket = AcidUtils.parseBaseBucketFilename(split.getPath(), conf).getBucket();
            reader = OrcFile.createReader(path, OrcFile.readerOptions(conf));
            List<OrcProto.Type> types = reader.getTypes();
            readOptions.include(OrcInputFormat.genIncludedColumns(types, conf, split.isOriginal()));
            OrcInputFormat.setSearchArgument(readOptions, types, conf, split.isOriginal());
        } else {
            bucket = (int)split.getStart();
            reader = null;
        }
        String txnString = conf.get("hive.txn.valid.txns", "9223372036854775807:");
        ValidReadTxnList validTxnList = new ValidReadTxnList(txnString);
        final OrcRawRecordMerger records = new OrcRawRecordMerger(conf, true, reader, split.isOriginal(), bucket, validTxnList, readOptions, deltas);
        return new AcidInputFormat.RowReader<OrcStruct>(){
            OrcStruct innerRecord;
            {
                this.innerRecord = records.createValue();
            }

            @Override
            public ObjectInspector getObjectInspector() {
                return ((StructObjectInspector)records.getObjectInspector()).getAllStructFieldRefs().get(5).getFieldObjectInspector();
            }

            public boolean next(RecordIdentifier recordIdentifier, OrcStruct orcStruct) throws IOException {
                boolean result;
                while ((result = records.next(recordIdentifier, this.innerRecord)) && OrcRecordUpdater.getOperation(this.innerRecord) == 2) {
                }
                if (result) {
                    orcStruct.linkFields(OrcRecordUpdater.getRow(this.innerRecord));
                }
                return result;
            }

            public RecordIdentifier createKey() {
                return records.createKey();
            }

            public OrcStruct createValue() {
                return new OrcStruct(records.getColumns());
            }

            public long getPos() throws IOException {
                return records.getPos();
            }

            public void close() throws IOException {
                records.close();
            }

            public float getProgress() throws IOException {
                return records.getProgress();
            }
        };
    }

    static Path findOriginalBucket(FileSystem fs, Path directory, int bucket) throws IOException {
        for (FileStatus stat : fs.listStatus(directory)) {
            String name = stat.getPath().getName();
            String numberPart = name.substring(0, name.indexOf(95));
            if (!org.apache.commons.lang3.StringUtils.isNumeric(numberPart) || Integer.parseInt(numberPart) != bucket) continue;
            return stat.getPath();
        }
        throw new IllegalArgumentException("Can't find bucket " + bucket + " in " + directory);
    }

    @Override
    public AcidInputFormat.RawReader<OrcStruct> getRawReader(Configuration conf, boolean collapseEvents, int bucket, ValidTxnList validTxnList, Path baseDirectory, Path[] deltaDirectory) throws IOException {
        Reader reader = null;
        boolean isOriginal = false;
        if (baseDirectory != null) {
            Path bucketFile;
            if (baseDirectory.getName().startsWith("base_")) {
                bucketFile = AcidUtils.createBucketFile(baseDirectory, bucket);
            } else {
                isOriginal = true;
                bucketFile = OrcInputFormat.findOriginalBucket(baseDirectory.getFileSystem(conf), baseDirectory, bucket);
            }
            reader = OrcFile.createReader(bucketFile, OrcFile.readerOptions(conf));
        }
        return new OrcRawRecordMerger(conf, collapseEvents, reader, isOriginal, bucket, validTxnList, new Reader.Options(), deltaDirectory);
    }

    public static final class NullKeyRecordReader
    implements AcidInputFormat.AcidRecordReader<NullWritable, OrcStruct> {
        private final RecordIdentifier id;
        private final AcidInputFormat.RowReader<OrcStruct> inner;

        @Override
        public RecordIdentifier getRecordIdentifier() {
            return this.id;
        }

        private NullKeyRecordReader(AcidInputFormat.RowReader<OrcStruct> inner, Configuration conf) {
            this.inner = inner;
            this.id = (RecordIdentifier)inner.createKey();
        }

        public boolean next(NullWritable nullWritable, OrcStruct orcStruct) throws IOException {
            return this.inner.next(this.id, orcStruct);
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public OrcStruct createValue() {
            return (OrcStruct)this.inner.createValue();
        }

        public long getPos() throws IOException {
            return this.inner.getPos();
        }

        public void close() throws IOException {
            this.inner.close();
        }

        public float getProgress() throws IOException {
            return this.inner.getProgress();
        }
    }

    private static class FileInfo {
        long modificationTime;
        long size;
        List<StripeInformation> stripeInfos;
        ReaderImpl.FileMetaInfo fileMetaInfo;
        Metadata metadata;
        List<OrcProto.Type> types;
        private OrcFile.WriterVersion writerVersion;

        FileInfo(long modificationTime, long size, List<StripeInformation> stripeInfos, Metadata metadata, List<OrcProto.Type> types, ReaderImpl.FileMetaInfo fileMetaInfo, OrcFile.WriterVersion writerVersion) {
            this.modificationTime = modificationTime;
            this.size = size;
            this.stripeInfos = stripeInfos;
            this.fileMetaInfo = fileMetaInfo;
            this.metadata = metadata;
            this.types = types;
            this.writerVersion = writerVersion;
        }
    }

    static final class SplitGenerator
    implements Callable<List<OrcSplit>> {
        private final Context context;
        private final FileSystem fs;
        private final FileStatus file;
        private final long blockSize;
        private final TreeMap<Long, BlockLocation> locations;
        private final FileInfo fileInfo;
        private List<StripeInformation> stripes;
        private ReaderImpl.FileMetaInfo fileMetaInfo;
        private Metadata metadata;
        private List<OrcProto.Type> types;
        private final boolean isOriginal;
        private final List<Long> deltas;
        private final boolean hasBase;
        private OrcFile.WriterVersion writerVersion;
        private long projColsUncompressedSize;
        private List<OrcSplit> deltaSplits;

        public SplitGenerator(SplitInfo splitInfo) throws IOException {
            this.context = splitInfo.context;
            this.fs = splitInfo.fs;
            this.file = splitInfo.file;
            this.blockSize = this.file.getBlockSize();
            this.fileInfo = splitInfo.fileInfo;
            this.locations = SHIMS.getLocationsWithOffset(this.fs, this.file);
            this.isOriginal = splitInfo.isOriginal;
            this.deltas = splitInfo.deltas;
            this.hasBase = splitInfo.hasBase;
            this.projColsUncompressedSize = -1L;
            this.deltaSplits = splitInfo.getSplits();
        }

        Path getPath() {
            return this.file.getPath();
        }

        public String toString() {
            return "splitter(" + this.file.getPath() + ")";
        }

        static long getOverlap(long offset1, long length1, long offset2, long length2) {
            long end1 = offset1 + length1;
            long end2 = offset2 + length2;
            if (end2 <= offset1 || end1 <= offset2) {
                return 0L;
            }
            return Math.min(end1, end2) - Math.max(offset1, offset2);
        }

        OrcSplit createSplit(long offset, long length, ReaderImpl.FileMetaInfo fileMetaInfo) throws IOException {
            String[] hosts;
            Map.Entry<Long, BlockLocation> startEntry = this.locations.floorEntry(offset);
            BlockLocation start = startEntry.getValue();
            if (offset + length <= start.getOffset() + start.getLength()) {
                hosts = start.getHosts();
            } else {
                Map.Entry<Long, BlockLocation> endEntry = this.locations.floorEntry(offset + length);
                BlockLocation end = endEntry.getValue();
                NavigableMap<Long, BlockLocation> navigableMap = this.locations.subMap(startEntry.getKey(), true, endEntry.getKey(), true);
                HashMap<String, LongWritable> sizes = new HashMap<String, LongWritable>();
                long maxSize = 0L;
                for (BlockLocation block : navigableMap.values()) {
                    long overlap = SplitGenerator.getOverlap(offset, length, block.getOffset(), block.getLength());
                    if (overlap > 0L) {
                        for (String host : block.getHosts()) {
                            LongWritable val = (LongWritable)sizes.get(host);
                            if (val == null) {
                                val = new LongWritable();
                                sizes.put(host, val);
                            }
                            val.set(val.get() + overlap);
                            maxSize = Math.max(maxSize, val.get());
                        }
                        continue;
                    }
                    throw new IOException("File " + this.file.getPath().toString() + " should have had overlap on block starting at " + block.getOffset());
                }
                long threshold = (long)((double)maxSize * 0.8);
                ArrayList<String> hostList = new ArrayList<String>();
                for (BlockLocation block : navigableMap.values()) {
                    for (String host : block.getHosts()) {
                        if (!sizes.containsKey(host)) continue;
                        if (((LongWritable)sizes.get(host)).get() >= threshold) {
                            hostList.add(host);
                        }
                        sizes.remove(host);
                    }
                }
                hosts = new String[hostList.size()];
                hostList.toArray(hosts);
            }
            return new OrcSplit(this.file.getPath(), offset, length, hosts, fileMetaInfo, this.isOriginal, this.hasBase, this.deltas, this.projColsUncompressedSize);
        }

        @Override
        public List<OrcSplit> call() throws IOException {
            this.populateAndCacheStripeDetails();
            ArrayList<OrcSplit> splits = Lists.newArrayList();
            boolean[] includeStripe = null;
            if (this.deltas.isEmpty()) {
                Reader.Options options = new Reader.Options();
                options.include(OrcInputFormat.genIncludedColumns(this.types, this.context.conf, this.isOriginal));
                OrcInputFormat.setSearchArgument(options, this.types, this.context.conf, this.isOriginal);
                if (options.getSearchArgument() != null && this.writerVersion != OrcFile.WriterVersion.ORIGINAL) {
                    SearchArgument sarg = options.getSearchArgument();
                    List<PredicateLeaf> sargLeaves = sarg.getLeaves();
                    List<StripeStatistics> stripeStats = this.metadata.getStripeStatistics();
                    int[] filterColumns = RecordReaderImpl.mapSargColumns(sargLeaves, options.getColumnNames(), OrcInputFormat.getRootColumn(this.isOriginal));
                    if (stripeStats != null) {
                        includeStripe = new boolean[this.stripes.size()];
                        for (int i = 0; i < this.stripes.size(); ++i) {
                            boolean bl = includeStripe[i] = i >= stripeStats.size() || this.isStripeSatisfyPredicate(stripeStats.get(i), sarg, filterColumns);
                            if (!LOG.isDebugEnabled() || includeStripe[i]) continue;
                            LOG.debug((Object)("Eliminating ORC stripe-" + i + " of file '" + this.file.getPath() + "'  as it did not satisfy " + "predicate condition."));
                        }
                    }
                }
            }
            if (includeStripe == null) {
                includeStripe = new boolean[this.stripes.size()];
                Arrays.fill(includeStripe, true);
            }
            long currentOffset = -1L;
            long currentLength = 0L;
            int idx = -1;
            for (StripeInformation stripe : this.stripes) {
                if (!includeStripe[++idx]) {
                    if (currentOffset == -1L) continue;
                    splits.add(this.createSplit(currentOffset, currentLength, this.fileMetaInfo));
                    currentOffset = -1L;
                    continue;
                }
                if (currentOffset != -1L && currentLength > this.context.minSize && currentOffset / this.blockSize != stripe.getOffset() / this.blockSize) {
                    splits.add(this.createSplit(currentOffset, currentLength, this.fileMetaInfo));
                    currentOffset = -1L;
                }
                if (currentOffset == -1L) {
                    currentOffset = stripe.getOffset();
                    currentLength = stripe.getLength();
                } else {
                    currentLength = stripe.getOffset() + stripe.getLength() - currentOffset;
                }
                if (currentLength < this.context.maxSize) continue;
                splits.add(this.createSplit(currentOffset, currentLength, this.fileMetaInfo));
                currentOffset = -1L;
            }
            if (currentOffset != -1L) {
                splits.add(this.createSplit(currentOffset, currentLength, this.fileMetaInfo));
            }
            splits.addAll(this.deltaSplits);
            return splits;
        }

        private void populateAndCacheStripeDetails() throws IOException {
            Reader orcReader = OrcFile.createReader(this.file.getPath(), OrcFile.readerOptions(this.context.conf).filesystem(this.fs));
            List<String> projCols = ColumnProjectionUtils.getReadColumnNames(this.context.conf);
            this.projColsUncompressedSize = orcReader.getRawDataSizeOfColumns(projCols);
            if (this.fileInfo != null) {
                this.stripes = this.fileInfo.stripeInfos;
                this.fileMetaInfo = this.fileInfo.fileMetaInfo;
                this.metadata = this.fileInfo.metadata;
                this.types = this.fileInfo.types;
                this.writerVersion = this.fileInfo.writerVersion;
                if (this.fileMetaInfo == null && this.context.footerInSplits) {
                    this.fileInfo.fileMetaInfo = ((ReaderImpl)orcReader).getFileMetaInfo();
                    this.fileInfo.metadata = orcReader.getMetadata();
                    this.fileInfo.types = orcReader.getTypes();
                    this.fileInfo.writerVersion = orcReader.getWriterVersion();
                }
            } else {
                this.stripes = orcReader.getStripes();
                this.metadata = orcReader.getMetadata();
                this.types = orcReader.getTypes();
                this.writerVersion = orcReader.getWriterVersion();
                ReaderImpl.FileMetaInfo fileMetaInfo = this.fileMetaInfo = this.context.footerInSplits ? ((ReaderImpl)orcReader).getFileMetaInfo() : null;
                if (this.context.cacheStripeDetails) {
                    Context.footerCache.put(this.file.getPath(), new FileInfo(this.file.getModificationTime(), this.file.getLen(), this.stripes, this.metadata, this.types, this.fileMetaInfo, this.writerVersion));
                }
            }
        }

        private boolean isStripeSatisfyPredicate(StripeStatistics stripeStatistics, SearchArgument sarg, int[] filterColumns) {
            List<PredicateLeaf> predLeaves = sarg.getLeaves();
            SearchArgument.TruthValue[] truthValues = new SearchArgument.TruthValue[predLeaves.size()];
            for (int pred = 0; pred < truthValues.length; ++pred) {
                if (filterColumns[pred] != -1) {
                    ColumnStatistics stats = stripeStatistics.getColumnStatistics()[filterColumns[pred]];
                    truthValues[pred] = RecordReaderImpl.evaluatePredicate(stats, predLeaves.get(pred), null);
                    continue;
                }
                truthValues[pred] = SearchArgument.TruthValue.YES_NO_NULL;
            }
            return sarg.evaluate(truthValues).isNeeded();
        }
    }

    static final class FileGenerator
    implements Callable<SplitStrategy> {
        private final Context context;
        private final FileSystem fs;
        private final Path dir;

        FileGenerator(Context context, FileSystem fs, Path dir) {
            this.context = context;
            this.fs = fs;
            this.dir = dir;
        }

        @Override
        public SplitStrategy call() throws IOException {
            SplitStrategy<OrcSplit> splitStrategy;
            boolean isOriginal;
            AcidUtils.Directory dirInfo = AcidUtils.getAcidState(this.dir, this.context.conf, this.context.transactionList);
            List<Long> deltas = AcidUtils.serializeDeltas(dirInfo.getCurrentDirectories());
            Path base = dirInfo.getBaseDirectory();
            List<FileStatus> original = dirInfo.getOriginalFiles();
            boolean[] covered = new boolean[this.context.numBuckets];
            boolean bl = isOriginal = base == null;
            if (base != null || !original.isEmpty()) {
                List<FileStatus> children = original;
                if (base != null) {
                    children = SHIMS.listLocatedStatus(this.fs, base, AcidUtils.hiddenFileFilter);
                }
                long totalFileSize = 0L;
                for (FileStatus child : children) {
                    totalFileSize += child.getLen();
                    AcidOutputFormat.Options opts = AcidUtils.parseBaseBucketFilename(child.getPath(), this.context.conf);
                    int b = opts.getBucket();
                    if (b < 0 || b >= covered.length) continue;
                    covered[b] = true;
                }
                int numFiles = children.size();
                long avgFileSize = totalFileSize / (long)numFiles;
                switch (this.context.splitStrategyKind) {
                    case BI: {
                        splitStrategy = new BISplitStrategy(this.context, this.fs, this.dir, children, isOriginal, deltas, covered);
                        break;
                    }
                    case ETL: {
                        splitStrategy = new ETLSplitStrategy(this.context, this.fs, this.dir, children, isOriginal, deltas, covered);
                        break;
                    }
                    default: {
                        if (avgFileSize > this.context.maxSize) {
                            splitStrategy = new ETLSplitStrategy(this.context, this.fs, this.dir, children, isOriginal, deltas, covered);
                            break;
                        }
                        splitStrategy = new BISplitStrategy(this.context, this.fs, this.dir, children, isOriginal, deltas, covered);
                        break;
                    }
                }
            } else {
                splitStrategy = new ACIDSplitStrategy(this.dir, this.context.numBuckets, deltas, covered);
            }
            return splitStrategy;
        }
    }

    static class ACIDSplitStrategy
    implements SplitStrategy<OrcSplit> {
        Path dir;
        List<Long> deltas;
        boolean[] covered;
        int numBuckets;

        public ACIDSplitStrategy(Path dir, int numBuckets, List<Long> deltas, boolean[] covered) {
            this.dir = dir;
            this.numBuckets = numBuckets;
            this.deltas = deltas;
            this.covered = covered;
        }

        @Override
        public List<OrcSplit> getSplits() throws IOException {
            ArrayList<OrcSplit> splits = Lists.newArrayList();
            if (!this.deltas.isEmpty()) {
                for (int b = 0; b < this.numBuckets; ++b) {
                    if (this.covered[b]) continue;
                    splits.add(new OrcSplit(this.dir, b, 0L, new String[0], null, false, false, this.deltas, -1L));
                }
            }
            return splits;
        }

        public String toString() {
            return ACIDSplitStrategy.class.getSimpleName() + " strategy for " + this.dir;
        }
    }

    static final class BISplitStrategy
    extends ACIDSplitStrategy {
        List<FileStatus> fileStatuses;
        boolean isOriginal;
        List<Long> deltas;
        FileSystem fs;
        Context context;
        Path dir;

        public BISplitStrategy(Context context, FileSystem fs, Path dir, List<FileStatus> fileStatuses, boolean isOriginal, List<Long> deltas, boolean[] covered) {
            super(dir, context.numBuckets, deltas, covered);
            this.context = context;
            this.fileStatuses = fileStatuses;
            this.isOriginal = isOriginal;
            this.deltas = deltas;
            this.fs = fs;
            this.dir = dir;
        }

        @Override
        public List<OrcSplit> getSplits() throws IOException {
            ArrayList<OrcSplit> splits = Lists.newArrayList();
            for (FileStatus fileStatus : this.fileStatuses) {
                String[] hosts = SHIMS.getLocationsWithOffset(this.fs, fileStatus).firstEntry().getValue().getHosts();
                OrcSplit orcSplit = new OrcSplit(fileStatus.getPath(), 0L, fileStatus.getLen(), hosts, null, this.isOriginal, true, this.deltas, -1L);
                splits.add(orcSplit);
            }
            splits.addAll(super.getSplits());
            return splits;
        }

        @Override
        public String toString() {
            return BISplitStrategy.class.getSimpleName() + " strategy for " + this.dir;
        }
    }

    static final class ETLSplitStrategy
    implements SplitStrategy<SplitInfo> {
        Context context;
        FileSystem fs;
        List<FileStatus> files;
        boolean isOriginal;
        List<Long> deltas;
        Path dir;
        boolean[] covered;

        public ETLSplitStrategy(Context context, FileSystem fs, Path dir, List<FileStatus> children, boolean isOriginal, List<Long> deltas, boolean[] covered) {
            this.context = context;
            this.dir = dir;
            this.fs = fs;
            this.files = children;
            this.isOriginal = isOriginal;
            this.deltas = deltas;
            this.covered = covered;
        }

        private FileInfo verifyCachedFileInfo(FileStatus file) {
            this.context.numFilesCounter.incrementAndGet();
            FileInfo fileInfo = (FileInfo)Context.footerCache.getIfPresent(file.getPath());
            if (fileInfo != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Info cached for path: " + file.getPath()));
                }
                if (fileInfo.modificationTime == file.getModificationTime() && fileInfo.size == file.getLen()) {
                    this.context.cacheHitCounter.incrementAndGet();
                    return fileInfo;
                }
                Context.footerCache.invalidate(file.getPath());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Meta-Info for : " + file.getPath() + " changed. CachedModificationTime: " + fileInfo.modificationTime + ", CurrentModificationTime: " + file.getModificationTime() + ", CachedLength: " + fileInfo.size + ", CurrentLength: " + file.getLen()));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Info not cached for path: " + file.getPath()));
            }
            return null;
        }

        @Override
        public List<SplitInfo> getSplits() throws IOException {
            ArrayList<SplitInfo> result = Lists.newArrayList();
            for (FileStatus file : this.files) {
                FileInfo info = null;
                if (this.context.cacheStripeDetails) {
                    info = this.verifyCachedFileInfo(file);
                }
                if (file.getLen() <= 0L) continue;
                result.add(new SplitInfo(this.context, this.fs, file, info, this.isOriginal, this.deltas, true, this.dir, this.covered));
            }
            return result;
        }

        public String toString() {
            return ETLSplitStrategy.class.getSimpleName() + " strategy for " + this.dir;
        }
    }

    static final class SplitInfo
    extends ACIDSplitStrategy {
        private final Context context;
        private final FileSystem fs;
        private final FileStatus file;
        private final FileInfo fileInfo;
        private final boolean isOriginal;
        private final List<Long> deltas;
        private final boolean hasBase;

        SplitInfo(Context context, FileSystem fs, FileStatus file, FileInfo fileInfo, boolean isOriginal, List<Long> deltas, boolean hasBase, Path dir, boolean[] covered) throws IOException {
            super(dir, context.numBuckets, deltas, covered);
            this.context = context;
            this.fs = fs;
            this.file = file;
            this.fileInfo = fileInfo;
            this.isOriginal = isOriginal;
            this.deltas = deltas;
            this.hasBase = hasBase;
        }
    }

    static interface SplitStrategy<T> {
        public List<T> getSplits() throws IOException;
    }

    static class Context {
        private final Configuration conf;
        private static Cache<Path, FileInfo> footerCache;
        private static ExecutorService threadPool;
        private final int numBuckets;
        private final long maxSize;
        private final long minSize;
        private final boolean footerInSplits;
        private final boolean cacheStripeDetails;
        private final AtomicInteger cacheHitCounter = new AtomicInteger(0);
        private final AtomicInteger numFilesCounter = new AtomicInteger(0);
        private ValidTxnList transactionList;
        private SplitStrategyKind splitStrategyKind;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Context(Configuration conf) {
            this.conf = conf;
            this.minSize = conf.getLong(MIN_SPLIT_SIZE, 0x1000000L);
            this.maxSize = conf.getLong(MAX_SPLIT_SIZE, 0x10000000L);
            String ss = conf.get(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY.varname);
            if (ss == null || ss.equals(SplitStrategyKind.HYBRID.name())) {
                this.splitStrategyKind = SplitStrategyKind.HYBRID;
            } else {
                LOG.info((Object)("Enforcing " + ss + " ORC split strategy"));
                this.splitStrategyKind = SplitStrategyKind.valueOf(ss);
            }
            this.footerInSplits = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_ORC_INCLUDE_FILE_FOOTER_IN_SPLITS);
            this.numBuckets = Math.max(conf.getInt("bucket_count", 0), 0);
            LOG.debug((Object)("Number of buckets specified by conf file is " + this.numBuckets));
            int cacheStripeDetailsSize = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_ORC_CACHE_STRIPE_DETAILS_SIZE);
            int numThreads = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_ORC_COMPUTE_SPLITS_NUM_THREADS);
            this.cacheStripeDetails = cacheStripeDetailsSize > 0;
            Class<Context> clazz = Context.class;
            synchronized (Context.class) {
                if (threadPool == null) {
                    threadPool = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ORC_GET_SPLITS #%d").build());
                }
                if (footerCache == null && this.cacheStripeDetails) {
                    footerCache = CacheBuilder.newBuilder().concurrencyLevel(numThreads).initialCapacity(cacheStripeDetailsSize).softValues().build();
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                String value = conf.get("hive.txn.valid.txns", "9223372036854775807:");
                this.transactionList = new ValidReadTxnList(value);
                return;
            }
        }

        static {
            threadPool = null;
        }
    }

    private static class OrcRecordReader
    implements org.apache.hadoop.mapred.RecordReader<NullWritable, OrcStruct>,
    StatsProvidingRecordReader {
        private final RecordReader reader;
        private final long offset;
        private final long length;
        private final int numColumns;
        private float progress = 0.0f;
        private final Reader file;
        private final SerDeStats stats;

        OrcRecordReader(Reader file, Configuration conf, FileSplit split) throws IOException {
            List<OrcProto.Type> types = file.getTypes();
            this.file = file;
            this.numColumns = types.size() == 0 ? 0 : types.get(0).getSubtypesCount();
            this.offset = split.getStart();
            this.length = split.getLength();
            this.reader = OrcInputFormat.createReaderFromFile(file, conf, this.offset, this.length);
            this.stats = new SerDeStats();
        }

        public boolean next(NullWritable key, OrcStruct value) throws IOException {
            if (this.reader.hasNext()) {
                this.reader.next(value);
                this.progress = this.reader.getProgress();
                return true;
            }
            return false;
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public OrcStruct createValue() {
            return new OrcStruct(this.numColumns);
        }

        public long getPos() throws IOException {
            return this.offset + (long)(this.progress * (float)this.length);
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException {
            return this.progress;
        }

        @Override
        public SerDeStats getStats() {
            this.stats.setRawDataSize(this.file.getRawDataSize());
            this.stats.setRowCount(this.file.getNumberOfRows());
            return this.stats;
        }
    }

    static enum SplitStrategyKind {
        HYBRID,
        BI,
        ETL;

    }
}

