/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import hive.com.google.common.collect.Lists;
import hive.com.google.common.collect.MapMaker;
import hive.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.io.StatsProvidingRecordReader;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.StatsNoJobWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.ReflectionUtil;

public class StatsNoJobTask
extends Task<StatsNoJobWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Log LOG = LogFactory.getLog(StatsNoJobTask.class);
    private static ConcurrentMap<String, Partition> partUpdates;
    private static Table table;
    private static String tableFullName;
    private static JobConf jc;
    private static final PathFilter hiddenFileFilter;

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext driverContext) {
        super.initialize(conf, queryPlan, driverContext);
        jc = new JobConf((Configuration)conf);
    }

    @Override
    public int execute(DriverContext driverContext) {
        LOG.info((Object)"Executing stats (no job) task");
        String tableName = "";
        ExecutorService threadPool = null;
        try {
            tableName = ((StatsNoJobWork)this.work).getTableSpecs().tableName;
            table = this.db.getTable(tableName);
            int numThreads = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.HIVE_STATS_GATHER_NUM_THREADS);
            tableFullName = table.getDbName() + "." + table.getTableName();
            threadPool = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("StatsNoJobTask-Thread-%d").build());
            partUpdates = new MapMaker().concurrencyLevel(numThreads).makeMap();
            LOG.info((Object)("Initialized threadpool for stats computation with " + numThreads + " threads"));
        }
        catch (HiveException e) {
            LOG.error((Object)("Cannot get table " + tableName), (Throwable)e);
            this.console.printError("Cannot get table " + tableName, e.toString());
        }
        return this.aggregateStats(threadPool);
    }

    @Override
    public StageType getType() {
        return StageType.STATS;
    }

    @Override
    public String getName() {
        return "STATS-NO-JOB";
    }

    private int aggregateStats(ExecutorService threadPool) {
        int ret;
        block9: {
            ret = 0;
            try {
                Collection<Partition> partitions = null;
                partitions = ((StatsNoJobWork)this.work).getPrunedPartitionList() == null ? this.getPartitionsList() : ((StatsNoJobWork)this.work).getPrunedPartitionList().getPartitions();
                if (partitions == null) {
                    org.apache.hadoop.hive.metastore.api.Table tTable = table.getTTable();
                    Map parameters = tTable.getParameters();
                    try {
                        String msg;
                        Path dir = new Path(tTable.getSd().getLocation());
                        long numRows = 0L;
                        long rawDataSize = 0L;
                        long fileSize = 0L;
                        long numFiles = 0L;
                        FileSystem fs = dir.getFileSystem((Configuration)this.conf);
                        List<FileStatus> fileList = ShimLoader.getHadoopShims().listLocatedStatus(fs, dir, hiddenFileFilter);
                        boolean statsAvailable = false;
                        for (FileStatus file : fileList) {
                            FileSplit dummySplit;
                            if (file.isDir()) continue;
                            InputFormat inputFormat = ReflectionUtil.newInstance(table.getInputFormatClass(), (Configuration)jc);
                            RecordReader recordReader = inputFormat.getRecordReader((InputSplit)(dummySplit = new FileSplit(file.getPath(), 0L, 0L, new String[]{table.getDataLocation().toString()})), jc, Reporter.NULL);
                            if (recordReader instanceof StatsProvidingRecordReader) {
                                StatsProvidingRecordReader statsRR = (StatsProvidingRecordReader)recordReader;
                                numRows += statsRR.getStats().getRowCount();
                                rawDataSize += statsRR.getStats().getRawDataSize();
                                fileSize += file.getLen();
                                ++numFiles;
                                statsAvailable = true;
                            }
                            recordReader.close();
                        }
                        if (statsAvailable) {
                            parameters.put("numRows", String.valueOf(numRows));
                            parameters.put("rawDataSize", String.valueOf(rawDataSize));
                            parameters.put("totalSize", String.valueOf(fileSize));
                            parameters.put("numFiles", String.valueOf(numFiles));
                            parameters.put("STATS_GENERATED_VIA_STATS_TASK", "true");
                            this.db.alterTable(tableFullName, new Table(tTable));
                            msg = "Table " + tableFullName + " stats: [" + this.toString(parameters) + ']';
                            LOG.debug((Object)msg);
                            this.console.printInfo(msg);
                            break block9;
                        }
                        msg = "Table " + tableFullName + " does not provide stats.";
                        LOG.debug((Object)msg);
                    }
                    catch (Exception e) {
                        this.console.printInfo("[Warning] could not update stats for " + tableFullName + ".", "Failed with exception " + e.getMessage() + "\n" + StringUtils.stringifyException((Throwable)e));
                    }
                    break block9;
                }
                for (Partition partn : partitions) {
                    threadPool.execute(new StatsCollection(partn));
                }
                LOG.debug((Object)"Stats collection waiting for threadpool to shutdown..");
                this.shutdownAndAwaitTermination(threadPool);
                LOG.debug((Object)"Stats collection threadpool shutdown successful.");
                ret = this.updatePartitions();
            }
            catch (Exception e) {
                if (!((StatsNoJobWork)this.work).isStatsReliable()) break block9;
                ret = -1;
            }
        }
        return ret;
    }

    private int updatePartitions() throws InvalidOperationException, HiveException {
        if (!partUpdates.isEmpty()) {
            ArrayList updatedParts = Lists.newArrayList(partUpdates.values());
            if (updatedParts.contains(null) && ((StatsNoJobWork)this.work).isStatsReliable()) {
                LOG.debug((Object)"Stats requested to be reliable. Empty stats found and hence failing the task.");
                return -1;
            }
            LOG.debug((Object)"Bulk updating partitions..");
            this.db.alterPartitions(tableFullName, Lists.newArrayList(partUpdates.values()));
            LOG.debug((Object)("Bulk updated " + partUpdates.values().size() + " partitions."));
        }
        return 0;
    }

    private void shutdownAndAwaitTermination(ExecutorService threadPool) {
        threadPool.shutdown();
        try {
            if (!threadPool.awaitTermination(100L, TimeUnit.SECONDS)) {
                threadPool.shutdownNow();
                if (!threadPool.awaitTermination(100L, TimeUnit.SECONDS)) {
                    LOG.debug((Object)"Stats collection thread pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            threadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private String toString(Map<String, String> parameters) {
        StringBuilder builder = new StringBuilder();
        for (String statType : StatsSetupConst.supportedStats) {
            String value = parameters.get(statType);
            if (value == null) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(statType).append('=').append(value);
        }
        return builder.toString();
    }

    private List<Partition> getPartitionsList() throws HiveException {
        if (((StatsNoJobWork)this.work).getTableSpecs() != null) {
            BaseSemanticAnalyzer.TableSpec tblSpec = ((StatsNoJobWork)this.work).getTableSpecs();
            table = tblSpec.tableHandle;
            if (!table.isPartitioned()) {
                return null;
            }
            return tblSpec.partitions;
        }
        return null;
    }

    static {
        jc = null;
        hiddenFileFilter = new PathFilter(){

            public boolean accept(Path p) {
                String name = p.getName();
                return !name.startsWith("_") && !name.startsWith(".");
            }
        };
    }

    class StatsCollection
    implements Runnable {
        private Partition partn;

        public StatsCollection(Partition part) {
            this.partn = part;
        }

        @Override
        public void run() {
            block6: {
                org.apache.hadoop.hive.metastore.api.Partition tPart = this.partn.getTPartition();
                Map parameters = tPart.getParameters();
                try {
                    String msg;
                    String threadName;
                    Path dir = new Path(tPart.getSd().getLocation());
                    long numRows = 0L;
                    long rawDataSize = 0L;
                    long fileSize = 0L;
                    long numFiles = 0L;
                    FileSystem fs = dir.getFileSystem((Configuration)StatsNoJobTask.this.conf);
                    List<FileStatus> fileList = ShimLoader.getHadoopShims().listLocatedStatus(fs, dir, hiddenFileFilter);
                    boolean statsAvailable = false;
                    for (FileStatus file : fileList) {
                        if (file.isDir()) continue;
                        InputFormat inputFormat = ReflectionUtil.newInstance(this.partn.getInputFormatClass(), (Configuration)jc);
                        FileSplit dummySplit = new FileSplit(file.getPath(), 0L, 0L, new String[]{this.partn.getLocation()});
                        RecordReader recordReader = inputFormat.getRecordReader((InputSplit)dummySplit, jc, Reporter.NULL);
                        if (recordReader instanceof StatsProvidingRecordReader) {
                            StatsProvidingRecordReader statsRR = (StatsProvidingRecordReader)recordReader;
                            rawDataSize += statsRR.getStats().getRawDataSize();
                            numRows += statsRR.getStats().getRowCount();
                            fileSize += file.getLen();
                            ++numFiles;
                            statsAvailable = true;
                        }
                        recordReader.close();
                    }
                    if (statsAvailable) {
                        parameters.put("numRows", String.valueOf(numRows));
                        parameters.put("rawDataSize", String.valueOf(rawDataSize));
                        parameters.put("totalSize", String.valueOf(fileSize));
                        parameters.put("numFiles", String.valueOf(numFiles));
                        parameters.put("STATS_GENERATED_VIA_STATS_TASK", "true");
                        partUpdates.put(tPart.getSd().getLocation(), new Partition(table, tPart));
                        threadName = Thread.currentThread().getName();
                        msg = "Partition " + tableFullName + this.partn.getSpec() + " stats: [" + this.toString(parameters) + ']';
                        LOG.debug((Object)(threadName + ": " + msg));
                        StatsNoJobTask.this.console.printInfo(msg);
                    } else {
                        threadName = Thread.currentThread().getName();
                        msg = "Partition " + tableFullName + this.partn.getSpec() + " does not provide stats.";
                        LOG.debug((Object)(threadName + ": " + msg));
                    }
                }
                catch (Exception e) {
                    StatsNoJobTask.this.console.printInfo("[Warning] could not update stats for " + tableFullName + this.partn.getSpec() + ".", "Failed with exception " + e.getMessage() + "\n" + StringUtils.stringifyException((Throwable)e));
                    if (!((StatsNoJobWork)StatsNoJobTask.this.work).isStatsReliable()) break block6;
                    partUpdates.put(tPart.getSd().getLocation(), null);
                }
            }
        }

        private String toString(Map<String, String> parameters) {
            StringBuilder builder = new StringBuilder();
            for (String statType : StatsSetupConst.supportedStats) {
                String value = parameters.get(statType);
                if (value == null) continue;
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(statType).append('=').append(value);
            }
            return builder.toString();
        }
    }
}

