/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import hive.com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;

public class MapOperator
extends Operator<MapWork>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final transient LongWritable deserialize_error_count = new LongWritable();
    private final transient LongWritable recordCounter = new LongWritable();
    protected transient long numRows = 0L;
    protected transient long cntr = 1L;
    protected transient long logEveryNRows = 0L;
    private final Map<String, Map<Operator<?>, MapOpCtx>> opCtxMap = new HashMap();
    private final Map<Operator<?>, StructObjectInspector> childrenOpToOI = new HashMap();
    protected transient MapOpCtx[] currentCtxs;
    private final transient Map<String, Path> normalizedPaths = new HashMap<String, Path>();

    @VisibleForTesting
    void initializeAsRoot(JobConf hconf, MapWork mapWork) throws Exception {
        this.setConf(mapWork);
        this.setChildren((Configuration)hconf);
        this.passExecContext(new ExecMapperContext(hconf));
        this.initializeMapOperator((Configuration)hconf);
    }

    private MapOpCtx initObjectInspector(Configuration hconf, MapOpCtx opCtx, StructObjectInspector tableRowOI) throws Exception {
        TableScanOperator tsOp;
        TableScanDesc tsDesc;
        PartitionDesc pd = opCtx.partDesc;
        TableDesc td = pd.getTableDesc();
        Properties overlayedProps = SerDeUtils.createOverlayedProperties(td.getProperties(), pd.getProperties());
        LinkedHashMap<String, String> partSpec = pd.getPartSpec();
        opCtx.tableName = String.valueOf(overlayedProps.getProperty("name"));
        opCtx.partName = String.valueOf(partSpec);
        opCtx.deserializer = pd.getDeserializer(hconf);
        StructObjectInspector partRawRowObjectInspector = (StructObjectInspector)opCtx.deserializer.getObjectInspector();
        opCtx.partTblObjectInspectorConverter = ObjectInspectorConverters.getConverter(partRawRowObjectInspector, tableRowOI);
        String pcols = overlayedProps.getProperty("partition_columns");
        if (pcols != null && pcols.length() > 0) {
            String pcolTypes;
            String[] partKeyTypes;
            String[] partKeys = pcols.trim().split("/");
            if (partKeys.length > (partKeyTypes = (pcolTypes = overlayedProps.getProperty("partition_columns.types")).trim().split(":")).length) {
                throw new HiveException("Internal error : partKeys length, " + partKeys.length + " greater than partKeyTypes length, " + partKeyTypes.length);
            }
            ArrayList<String> partNames = new ArrayList<String>(partKeys.length);
            Object[] partValues = new Object[partKeys.length];
            ArrayList<ObjectInspector> partObjectInspectors = new ArrayList<ObjectInspector>(partKeys.length);
            for (int i = 0; i < partKeys.length; ++i) {
                String key = partKeys[i];
                partNames.add(key);
                AbstractPrimitiveWritableObjectInspector oi = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(TypeInfoFactory.getPrimitiveTypeInfo(partKeyTypes[i]));
                partValues[i] = partSpec == null ? null : ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)oi).convert(partSpec.get(key));
                partObjectInspectors.add(oi);
            }
            opCtx.rowWithPart = new Object[]{null, partValues};
            opCtx.partObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(partNames, partObjectInspectors);
        }
        if (opCtx.op instanceof TableScanOperator && (tsDesc = (TableScanDesc)(tsOp = (TableScanOperator)opCtx.op).getConf()) != null && tsDesc.hasVirtualCols()) {
            opCtx.vcs = tsDesc.getVirtualCols();
            opCtx.vcValues = new Object[opCtx.vcs.size()];
            opCtx.vcsObjectInspector = VirtualColumn.getVCSObjectInspector(opCtx.vcs);
            opCtx.rowWithPartAndVC = opCtx.isPartitioned() ? Arrays.copyOfRange(opCtx.rowWithPart, 0, 3) : new Object[2];
        }
        if (!opCtx.hasVC() && !opCtx.isPartitioned()) {
            opCtx.rowObjectInspector = tableRowOI;
            return opCtx;
        }
        ArrayList<StructObjectInspector> inspectors = new ArrayList<StructObjectInspector>();
        inspectors.add(tableRowOI);
        if (opCtx.isPartitioned()) {
            inspectors.add(opCtx.partObjectInspector);
        }
        if (opCtx.hasVC()) {
            inspectors.add(opCtx.vcsObjectInspector);
        }
        opCtx.rowObjectInspector = ObjectInspectorFactory.getUnionStructObjectInspector(inspectors);
        return opCtx;
    }

    private Map<TableDesc, StructObjectInspector> getConvertedOI(Configuration hconf) throws HiveException {
        HashMap<TableDesc, StructObjectInspector> tableDescOI = new HashMap<TableDesc, StructObjectInspector>();
        HashSet<TableDesc> identityConverterTableDesc = new HashSet<TableDesc>();
        try {
            HashMap<ObjectInspector, Boolean> oiSettableProperties = new HashMap<ObjectInspector, Boolean>();
            for (String onefile : ((MapWork)this.conf).getPathToAliases().keySet()) {
                PartitionDesc pd = ((MapWork)this.conf).getPathToPartitionInfo().get(onefile);
                TableDesc tableDesc = pd.getTableDesc();
                Deserializer partDeserializer = pd.getDeserializer(hconf);
                StructObjectInspector partRawRowObjectInspector = (StructObjectInspector)partDeserializer.getObjectInspector();
                StructObjectInspector tblRawRowObjectInspector = (StructObjectInspector)tableDescOI.get(tableDesc);
                if (tblRawRowObjectInspector != null && !identityConverterTableDesc.contains(tableDesc)) continue;
                Deserializer tblDeserializer = tableDesc.getDeserializer(hconf);
                tblRawRowObjectInspector = (StructObjectInspector)ObjectInspectorConverters.getConvertedOI(partRawRowObjectInspector, tblDeserializer.getObjectInspector(), oiSettableProperties);
                if (identityConverterTableDesc.contains(tableDesc)) {
                    if (!partRawRowObjectInspector.equals(tblRawRowObjectInspector)) {
                        identityConverterTableDesc.remove(tableDesc);
                    }
                } else if (partRawRowObjectInspector.equals(tblRawRowObjectInspector)) {
                    identityConverterTableDesc.add(tableDesc);
                }
                tableDescOI.put(tableDesc, tblRawRowObjectInspector);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return tableDescOI;
    }

    public void setChildren(Configuration hconf) throws Exception {
        ArrayList<Operator<? extends OperatorDesc>> children = new ArrayList<Operator<? extends OperatorDesc>>();
        Map<TableDesc, StructObjectInspector> convertedOI = this.getConvertedOI(hconf);
        for (Map.Entry<String, ArrayList<String>> entry : ((MapWork)this.conf).getPathToAliases().entrySet()) {
            String onefile = entry.getKey();
            List aliases = entry.getValue();
            PartitionDesc partDesc = ((MapWork)this.conf).getPathToPartitionInfo().get(onefile);
            for (String alias : aliases) {
                Map<Operator<?>, MapOpCtx> contexts;
                Operator<? extends OperatorDesc> op = ((MapWork)this.conf).getAliasToWork().get(alias);
                if (this.isLogDebugEnabled) {
                    this.LOG.debug((Object)("Adding alias " + alias + " to work list for file " + onefile));
                }
                if ((contexts = this.opCtxMap.get(onefile)) == null) {
                    contexts = new LinkedHashMap();
                    this.opCtxMap.put(onefile, contexts);
                }
                if (contexts.containsKey(op)) continue;
                MapOpCtx context = new MapOpCtx(alias, op, partDesc);
                StructObjectInspector tableRowOI = convertedOI.get(partDesc.getTableDesc());
                contexts.put(op, this.initObjectInspector(hconf, context, tableRowOI));
                if (children.contains(op)) continue;
                op.setParentOperators(new ArrayList<Operator<? extends OperatorDesc>>(1));
                op.getParentOperators().add(this);
                children.add(op);
            }
        }
        this.initOperatorContext(children);
        this.setChildOperators(children);
    }

    private void initOperatorContext(List<Operator<? extends OperatorDesc>> children) throws HiveException {
        for (Map<Operator<?>, MapOpCtx> contexts : this.opCtxMap.values()) {
            for (MapOpCtx context : contexts.values()) {
                if (!children.contains(context.op)) continue;
                StructObjectInspector prev = this.childrenOpToOI.put(context.op, context.rowObjectInspector);
                if (prev != null && !prev.equals(context.rowObjectInspector)) {
                    throw new HiveException("Conflict on row inspector for " + context.alias);
                }
                if (!this.isLogDebugEnabled) continue;
                this.LOG.debug((Object)("dump " + context.op + " " + context.rowObjectInspector.getTypeName()));
            }
        }
    }

    private String getNominalPath(Path fpath) {
        String nominal = null;
        boolean schemaless = fpath.toUri().getScheme() == null;
        for (String onefile : ((MapWork)this.conf).getPathToAliases().keySet()) {
            Path onepath = this.normalizePath(onefile, schemaless);
            Path curfpath = fpath;
            if (!schemaless && onepath.toUri().getScheme() == null) {
                curfpath = new Path(fpath.toUri().getPath());
            }
            if (onepath.toUri().relativize(curfpath.toUri()).equals(curfpath.toUri())) continue;
            if (nominal != null) {
                throw new IllegalStateException("Ambiguous input path " + fpath);
            }
            nominal = onefile;
        }
        if (nominal == null) {
            throw new IllegalStateException("Invalid input path " + fpath);
        }
        return nominal;
    }

    @Override
    public Collection<Future<?>> initializeOp(Configuration hconf) throws HiveException {
        return super.initializeOp(hconf);
    }

    public void initializeMapOperator(Configuration hconf) throws HiveException {
        this.state = Operator.State.INIT;
        this.statsMap.put(Counter.DESERIALIZE_ERRORS.toString(), this.deserialize_error_count);
        this.numRows = 0L;
        this.cntr = 1L;
        this.logEveryNRows = HiveConf.getLongVar(hconf, HiveConf.ConfVars.HIVE_LOG_N_RECORDS);
        String context = hconf.get("__hive.context.name", "");
        if (context != null && !context.isEmpty()) {
            context = "_" + context.replace(" ", "_");
        }
        this.statsMap.put((Object)((Object)Counter.RECORDS_IN) + context, this.recordCounter);
        for (Map.Entry<Operator<?>, StructObjectInspector> entry : this.childrenOpToOI.entrySet()) {
            Operator<?> child = entry.getKey();
            child.initialize(hconf, new ObjectInspector[]{entry.getValue()});
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        this.recordCounter.set(this.numRows);
        super.closeOp(abort);
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        super.cleanUpInputFileChangedOp();
        Path fpath = this.getExecContext().getCurrentInputPath();
        String nominalPath = this.getNominalPath(fpath);
        Map<Operator<?>, MapOpCtx> contexts = this.opCtxMap.get(nominalPath);
        if (this.isLogInfoEnabled) {
            StringBuilder builder = new StringBuilder();
            for (MapOpCtx context : contexts.values()) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(context.alias);
            }
            if (this.isLogDebugEnabled) {
                this.LOG.debug((Object)("Processing alias(es) " + builder.toString() + " for file " + fpath));
            }
        }
        for (Map.Entry<Operator<?>, MapOpCtx> entry : contexts.entrySet()) {
            Operator<?> operator = entry.getKey();
            MapOpCtx context = entry.getValue();
            operator.setInputContext(nominalPath, context.tableName, context.partName);
        }
        this.currentCtxs = contexts.values().toArray(new MapOpCtx[contexts.size()]);
    }

    private Path normalizePath(String onefile, boolean schemaless) {
        Path path = this.normalizedPaths.get(onefile);
        if (path == null) {
            path = new Path(onefile);
            if (schemaless && path.toUri().getScheme() != null) {
                path = new Path(path.toUri().getPath());
            }
            this.normalizedPaths.put(onefile, path);
        }
        return path;
    }

    public void process(Writable value) throws HiveException {
        ExecMapperContext context = this.getExecContext();
        if (context != null && context.inputFileChanged()) {
            this.cleanUpInputFileChanged();
        }
        int childrenDone = 0;
        for (MapOpCtx current : this.currentCtxs) {
            Object row = null;
            try {
                row = current.readRow(value, context);
                if (current.forward(row)) continue;
                ++childrenDone;
            }
            catch (Exception e) {
                String message = this.toErrorMessage(value, row, current.rowObjectInspector);
                if (row == null) {
                    this.deserialize_error_count.set(this.deserialize_error_count.get() + 1L);
                    throw new HiveException("Hive Runtime Error while processing writable " + message, e);
                }
                throw new HiveException("Hive Runtime Error while processing row " + message, e);
            }
        }
        this.rowsForwarded(childrenDone, 1);
    }

    protected final void rowsForwarded(int childrenDone, int rows) {
        this.numRows += (long)rows;
        if (this.isLogInfoEnabled) {
            while (this.numRows >= this.cntr) {
                long l = this.cntr = this.logEveryNRows == 0L ? this.cntr * 10L : this.numRows + this.logEveryNRows;
                if (this.cntr < 0L || this.numRows < 0L) {
                    this.cntr = 1L;
                    this.numRows = 0L;
                }
                this.LOG.info((Object)(this.toString() + ": records read - " + this.numRows));
            }
        }
        if (childrenDone == this.currentCtxs.length) {
            this.setDone(true);
        }
    }

    private String toErrorMessage(Writable value, Object row, ObjectInspector inspector) {
        try {
            if (row != null) {
                return SerDeUtils.getJSONString(row, inspector);
            }
            return String.valueOf(value);
        }
        catch (Exception e) {
            return "[Error getting row data with exception " + StringUtils.stringifyException((Throwable)e) + " ]";
        }
    }

    public static Object[] populateVirtualColumnValues(ExecMapperContext ctx, List<VirtualColumn> vcs, Object[] vcValues, Deserializer deserializer) {
        if (vcs == null) {
            return vcValues;
        }
        if (vcValues == null) {
            vcValues = new Object[vcs.size()];
        }
        for (int i = 0; i < vcs.size(); ++i) {
            LongWritable old;
            long current;
            VirtualColumn vc = vcs.get(i);
            if (vc.equals(VirtualColumn.FILENAME)) {
                if (!ctx.inputFileChanged()) continue;
                vcValues[i] = new Text(ctx.getCurrentInputPath().toString());
                continue;
            }
            if (vc.equals(VirtualColumn.BLOCKOFFSET)) {
                current = ctx.getIoCxt().getCurrentBlockStart();
                old = (LongWritable)vcValues[i];
                if (old == null) {
                    old = new LongWritable(current);
                    vcValues[i] = old;
                    continue;
                }
                if (current == old.get()) continue;
                old.set(current);
                continue;
            }
            if (vc.equals(VirtualColumn.ROWOFFSET)) {
                current = ctx.getIoCxt().getCurrentRow();
                old = (LongWritable)vcValues[i];
                if (old == null) {
                    old = new LongWritable(current);
                    vcValues[i] = old;
                    continue;
                }
                if (current == old.get()) continue;
                old.set(current);
                continue;
            }
            if (vc.equals(VirtualColumn.RAWDATASIZE)) {
                LongWritable old2;
                current = 0L;
                SerDeStats stats = deserializer.getSerDeStats();
                if (stats != null) {
                    current = stats.getRawDataSize();
                }
                if ((old2 = (LongWritable)vcValues[i]) == null) {
                    old2 = new LongWritable(current);
                    vcValues[i] = old2;
                    continue;
                }
                if (current == old2.get()) continue;
                old2.set(current);
                continue;
            }
            if (!vc.equals(VirtualColumn.ROWID)) continue;
            if (ctx.getIoCxt().getRecordIdentifier() == null) {
                vcValues[i] = null;
                continue;
            }
            if (vcValues[i] == null) {
                vcValues[i] = new Object[RecordIdentifier.Field.values().length];
            }
            RecordIdentifier.StructInfo.toArray(ctx.getIoCxt().getRecordIdentifier(), (Object[])vcValues[i]);
            ctx.getIoCxt().setRecordIdentifier(null);
        }
        return vcValues;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        throw new HiveException("Hive 2 Internal error: should not be called!");
    }

    @Override
    public String getName() {
        return MapOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "MAP";
    }

    @Override
    public OperatorType getType() {
        return null;
    }

    public void initializeContexts() {
        Path fpath = this.getExecContext().getCurrentInputPath();
        String nominalPath = this.getNominalPath(fpath);
        Map<Operator<?>, MapOpCtx> contexts = this.opCtxMap.get(nominalPath);
        this.currentCtxs = contexts.values().toArray(new MapOpCtx[contexts.size()]);
    }

    public Deserializer getCurrentDeserializer() {
        return this.currentCtxs[0].deserializer;
    }

    protected static class MapOpCtx {
        final String alias;
        final Operator<?> op;
        final PartitionDesc partDesc;
        StructObjectInspector partObjectInspector;
        StructObjectInspector vcsObjectInspector;
        StructObjectInspector rowObjectInspector;
        ObjectInspectorConverters.Converter partTblObjectInspectorConverter;
        Object[] rowWithPart;
        Object[] rowWithPartAndVC;
        Deserializer deserializer;
        String tableName;
        String partName;
        List<VirtualColumn> vcs;
        Object[] vcValues;

        public MapOpCtx(String alias, Operator<?> op, PartitionDesc partDesc) {
            this.alias = alias;
            this.op = op;
            this.partDesc = partDesc;
        }

        private boolean isPartitioned() {
            return this.partObjectInspector != null;
        }

        private boolean hasVC() {
            return this.vcsObjectInspector != null;
        }

        private Object readRow(Writable value, ExecMapperContext context) throws SerDeException {
            Object deserialized = this.deserializer.deserialize(value);
            Object row = this.partTblObjectInspectorConverter.convert(deserialized);
            if (this.hasVC()) {
                this.rowWithPartAndVC[0] = row;
                if (context != null) {
                    MapOperator.populateVirtualColumnValues(context, this.vcs, this.vcValues, this.deserializer);
                }
                int vcPos = this.isPartitioned() ? 2 : 1;
                this.rowWithPartAndVC[vcPos] = this.vcValues;
                return this.rowWithPartAndVC;
            }
            if (this.isPartitioned()) {
                this.rowWithPart[0] = row;
                return this.rowWithPart;
            }
            return row;
        }

        public boolean forward(Object row) throws HiveException {
            if (this.op.getDone()) {
                return false;
            }
            this.op.process(row, 0);
            return true;
        }
    }

    public static enum Counter {
        DESERIALIZE_ERRORS,
        RECORDS_IN;

    }
}

