/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.hadoop.metadata;

import hive.parquet.column.Encoding;
import hive.parquet.column.statistics.Statistics;
import hive.parquet.hadoop.metadata.ColumnChunkMetaData;
import hive.parquet.hadoop.metadata.ColumnChunkProperties;
import hive.parquet.hadoop.metadata.ColumnPath;
import hive.parquet.hadoop.metadata.CompressionCodecName;
import hive.parquet.schema.PrimitiveType;
import java.util.Set;

class LongColumnChunkMetaData
extends ColumnChunkMetaData {
    private final long firstDataPageOffset;
    private final long dictionaryPageOffset;
    private final long valueCount;
    private final long totalSize;
    private final long totalUncompressedSize;
    private final Statistics statistics;

    LongColumnChunkMetaData(ColumnPath path, PrimitiveType.PrimitiveTypeName type, CompressionCodecName codec, Set<Encoding> encodings, Statistics statistics, long firstDataPageOffset, long dictionaryPageOffset, long valueCount, long totalSize, long totalUncompressedSize) {
        super(ColumnChunkProperties.get(path, type, codec, encodings));
        this.firstDataPageOffset = firstDataPageOffset;
        this.dictionaryPageOffset = dictionaryPageOffset;
        this.valueCount = valueCount;
        this.totalSize = totalSize;
        this.totalUncompressedSize = totalUncompressedSize;
        this.statistics = statistics;
    }

    @Override
    public long getFirstDataPageOffset() {
        return this.firstDataPageOffset;
    }

    @Override
    public long getDictionaryPageOffset() {
        return this.dictionaryPageOffset;
    }

    @Override
    public long getValueCount() {
        return this.valueCount;
    }

    @Override
    public long getTotalUncompressedSize() {
        return this.totalUncompressedSize;
    }

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }
}

