/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.hadoop.example;

import hive.parquet.Preconditions;
import hive.parquet.example.data.Group;
import hive.parquet.example.data.GroupWriter;
import hive.parquet.hadoop.api.WriteSupport;
import hive.parquet.io.api.RecordConsumer;
import hive.parquet.schema.MessageType;
import hive.parquet.schema.MessageTypeParser;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;

public class GroupWriteSupport
extends WriteSupport<Group> {
    public static final String PARQUET_EXAMPLE_SCHEMA = "hive.parquet.example.schema";
    private MessageType schema;
    private GroupWriter groupWriter;

    public static void setSchema(MessageType schema, Configuration configuration) {
        configuration.set(PARQUET_EXAMPLE_SCHEMA, schema.toString());
    }

    public static MessageType getSchema(Configuration configuration) {
        return MessageTypeParser.parseMessageType(Preconditions.checkNotNull(configuration.get(PARQUET_EXAMPLE_SCHEMA), PARQUET_EXAMPLE_SCHEMA));
    }

    @Override
    public WriteSupport.WriteContext init(Configuration configuration) {
        this.schema = GroupWriteSupport.getSchema(configuration);
        return new WriteSupport.WriteContext(this.schema, new HashMap<String, String>());
    }

    @Override
    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.groupWriter = new GroupWriter(recordConsumer, this.schema);
    }

    @Override
    public void write(Group record) {
        this.groupWriter.write(record);
    }
}

