/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.filter2.predicate;

import hive.parquet.Preconditions;
import hive.parquet.column.ColumnDescriptor;
import hive.parquet.filter2.predicate.FilterPredicate;
import hive.parquet.filter2.predicate.Operators;
import hive.parquet.filter2.predicate.UserDefinedPredicate;
import hive.parquet.filter2.predicate.ValidTypeMap;
import hive.parquet.hadoop.metadata.ColumnPath;
import hive.parquet.schema.MessageType;
import hive.parquet.schema.OriginalType;
import java.util.HashMap;
import java.util.Map;

public class SchemaCompatibilityValidator
implements FilterPredicate.Visitor<Void> {
    private final Map<ColumnPath, Class<?>> columnTypesEncountered = new HashMap();
    private final Map<ColumnPath, ColumnDescriptor> columnsAccordingToSchema = new HashMap<ColumnPath, ColumnDescriptor>();
    private final Map<ColumnPath, OriginalType> originalTypes = new HashMap<ColumnPath, OriginalType>();

    public static void validate(FilterPredicate predicate, MessageType schema) {
        Preconditions.checkNotNull(predicate, "predicate");
        Preconditions.checkNotNull(schema, "schema");
        predicate.accept(new SchemaCompatibilityValidator(schema));
    }

    private SchemaCompatibilityValidator(MessageType schema) {
        for (ColumnDescriptor cd : schema.getColumns()) {
            ColumnPath columnPath = ColumnPath.get(cd.getPath());
            this.columnsAccordingToSchema.put(columnPath, cd);
            OriginalType ot = schema.getType(cd.getPath()).getOriginalType();
            if (ot == null) continue;
            this.originalTypes.put(columnPath, ot);
        }
    }

    @Override
    public <T extends Comparable<T>> Void visit(Operators.Eq<T> pred) {
        this.validateColumnFilterPredicate(pred);
        return null;
    }

    @Override
    public <T extends Comparable<T>> Void visit(Operators.NotEq<T> pred) {
        this.validateColumnFilterPredicate(pred);
        return null;
    }

    @Override
    public <T extends Comparable<T>> Void visit(Operators.Lt<T> pred) {
        this.validateColumnFilterPredicate(pred);
        return null;
    }

    @Override
    public <T extends Comparable<T>> Void visit(Operators.LtEq<T> pred) {
        this.validateColumnFilterPredicate(pred);
        return null;
    }

    @Override
    public <T extends Comparable<T>> Void visit(Operators.Gt<T> pred) {
        this.validateColumnFilterPredicate(pred);
        return null;
    }

    @Override
    public <T extends Comparable<T>> Void visit(Operators.GtEq<T> pred) {
        this.validateColumnFilterPredicate(pred);
        return null;
    }

    @Override
    public Void visit(Operators.And and) {
        and.getLeft().accept(this);
        and.getRight().accept(this);
        return null;
    }

    @Override
    public Void visit(Operators.Or or) {
        or.getLeft().accept(this);
        or.getRight().accept(this);
        return null;
    }

    @Override
    public Void visit(Operators.Not not) {
        not.getPredicate().accept(this);
        return null;
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Void visit(Operators.UserDefined<T, U> udp) {
        this.validateColumn(udp.getColumn());
        return null;
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Void visit(Operators.LogicalNotUserDefined<T, U> udp) {
        return udp.getUserDefined().accept(this);
    }

    private <T extends Comparable<T>> void validateColumnFilterPredicate(Operators.ColumnFilterPredicate<T> pred) {
        this.validateColumn(pred.getColumn());
    }

    private <T extends Comparable<T>> void validateColumn(Operators.Column<T> column) {
        ColumnDescriptor descriptor;
        ColumnPath path = column.getColumnPath();
        Class<?> alreadySeen = this.columnTypesEncountered.get(path);
        if (alreadySeen != null && !alreadySeen.equals(column.getColumnType())) {
            throw new IllegalArgumentException("Column: " + path.toDotString() + " was provided with different types in the same predicate." + " Found both: (" + alreadySeen + ", " + column.getColumnType() + ")");
        }
        if (alreadySeen == null) {
            this.columnTypesEncountered.put(path, column.getColumnType());
        }
        if ((descriptor = this.getColumnDescriptor(path)).getMaxRepetitionLevel() > 0) {
            throw new IllegalArgumentException("FilterPredicates do not currently support repeated columns. Column " + path.toDotString() + " is repeated.");
        }
        ValidTypeMap.assertTypeValid(column, descriptor.getType(), this.originalTypes.get(path));
    }

    private ColumnDescriptor getColumnDescriptor(ColumnPath columnPath) {
        ColumnDescriptor cd = this.columnsAccordingToSchema.get(columnPath);
        Preconditions.checkArgument(cd != null, "Column " + columnPath + " was not found in schema!");
        return cd;
    }
}

