/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.column.values.deltastrings;

import hive.parquet.column.values.ValuesReader;
import hive.parquet.column.values.delta.DeltaBinaryPackingValuesReader;
import hive.parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesReader;
import hive.parquet.io.api.Binary;
import java.io.IOException;

public class DeltaByteArrayReader
extends ValuesReader {
    private ValuesReader prefixLengthReader = new DeltaBinaryPackingValuesReader();
    private ValuesReader suffixReader = new DeltaLengthByteArrayValuesReader();
    private Binary previous = Binary.fromByteArray(new byte[0]);

    @Override
    public void initFromPage(int valueCount, byte[] page, int offset) throws IOException {
        this.prefixLengthReader.initFromPage(valueCount, page, offset);
        int next = this.prefixLengthReader.getNextOffset();
        this.suffixReader.initFromPage(valueCount, page, next);
    }

    @Override
    public void skip() {
        this.prefixLengthReader.skip();
        this.suffixReader.skip();
    }

    @Override
    public Binary readBytes() {
        int prefixLength = this.prefixLengthReader.readInteger();
        Binary suffix = this.suffixReader.readBytes();
        int length = prefixLength + suffix.length();
        if (prefixLength != 0) {
            byte[] out = new byte[length];
            System.arraycopy(this.previous.getBytes(), 0, out, 0, prefixLength);
            System.arraycopy(suffix.getBytes(), 0, out, prefixLength, suffix.length());
            this.previous = Binary.fromByteArray(out);
        } else {
            this.previous = suffix;
        }
        return this.previous;
    }
}

