/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.util.mapping;

import hive.org.apache.calcite.util.mapping.IntPair;
import hive.org.apache.calcite.util.mapping.Mapping;
import hive.org.apache.calcite.util.mapping.MappingType;
import hive.org.apache.calcite.util.mapping.Mappings;
import java.util.Iterator;

public abstract class AbstractSourceMapping
extends Mappings.AbstractMapping
implements Mapping {
    private final int sourceCount;
    private final int targetCount;

    public AbstractSourceMapping(int sourceCount, int targetCount) {
        this.sourceCount = sourceCount;
        this.targetCount = targetCount;
    }

    @Override
    public int getSourceCount() {
        return this.sourceCount;
    }

    @Override
    public int getTargetCount() {
        return this.targetCount;
    }

    @Override
    public Mapping inverse() {
        return Mappings.invert(this);
    }

    @Override
    public int size() {
        return this.targetCount;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public MappingType getMappingType() {
        return MappingType.INVERSE_PARTIAL_FUNCTION;
    }

    @Override
    public Iterator<IntPair> iterator() {
        return new Iterator<IntPair>(){
            int source;
            int target = -1;
            {
                this.moveToNext();
            }

            private void moveToNext() {
                while (++this.target < AbstractSourceMapping.this.targetCount) {
                    this.source = AbstractSourceMapping.this.getSourceOpt(this.target);
                    if (this.source < 0) continue;
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                return this.target < AbstractSourceMapping.this.targetCount;
            }

            @Override
            public IntPair next() {
                IntPair p = new IntPair(this.source, this.target);
                this.moveToNext();
                return p;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    @Override
    public abstract int getSourceOpt(int var1);
}

