/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql2rel;

import hive.org.apache.calcite.avatica.util.ByteString;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlIntervalLiteral;
import hive.org.apache.calcite.sql.SqlIntervalQualifier;
import hive.org.apache.calcite.sql.SqlLiteral;
import hive.org.apache.calcite.sql.SqlTimeLiteral;
import hive.org.apache.calcite.sql.SqlTimestampLiteral;
import hive.org.apache.calcite.sql.type.SqlTypeName;
import hive.org.apache.calcite.sql.validate.SqlValidator;
import hive.org.apache.calcite.sql2rel.SqlNodeToRexConverter;
import hive.org.apache.calcite.sql2rel.SqlRexContext;
import hive.org.apache.calcite.sql2rel.SqlRexConvertlet;
import hive.org.apache.calcite.sql2rel.SqlRexConvertletTable;
import hive.org.apache.calcite.util.BitString;
import hive.org.apache.calcite.util.NlsString;
import hive.org.apache.calcite.util.Util;
import java.math.BigDecimal;
import java.util.Calendar;

public class SqlNodeToRexConverterImpl
implements SqlNodeToRexConverter {
    private final SqlRexConvertletTable convertletTable;

    SqlNodeToRexConverterImpl(SqlRexConvertletTable convertletTable) {
        this.convertletTable = convertletTable;
    }

    @Override
    public RexNode convertCall(SqlRexContext cx, SqlCall call) {
        SqlRexConvertlet convertlet = this.convertletTable.get(call);
        if (convertlet != null) {
            return convertlet.convertCall(cx, call);
        }
        throw Util.needToImplement(call);
    }

    @Override
    public RexLiteral convertInterval(SqlRexContext cx, SqlIntervalQualifier intervalQualifier) {
        RexBuilder rexBuilder = cx.getRexBuilder();
        return rexBuilder.makeIntervalLiteral(intervalQualifier);
    }

    @Override
    public RexNode convertLiteral(SqlRexContext cx, SqlLiteral literal) {
        RexBuilder rexBuilder = cx.getRexBuilder();
        RelDataTypeFactory typeFactory = cx.getTypeFactory();
        SqlValidator validator = cx.getValidator();
        Object value = literal.getValue();
        if (value == null) {
            RelDataType type;
            if (literal.getTypeName() == SqlTypeName.BOOLEAN) {
                type = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
                type = typeFactory.createTypeWithNullability(type, true);
            } else {
                type = validator.getValidatedNodeType(literal);
            }
            return rexBuilder.makeCast(type, rexBuilder.constantNull());
        }
        switch (literal.getTypeName()) {
            case DECIMAL: {
                BigDecimal bd = (BigDecimal)value;
                return rexBuilder.makeExactLiteral(bd, literal.createSqlType(typeFactory));
            }
            case DOUBLE: {
                return rexBuilder.makeApproxLiteral((BigDecimal)value);
            }
            case CHAR: {
                return rexBuilder.makeCharLiteral((NlsString)value);
            }
            case BOOLEAN: {
                return rexBuilder.makeLiteral((Boolean)value);
            }
            case BINARY: {
                BitString bitString = (BitString)value;
                Util.permAssert(bitString.getBitCount() % 8 == 0, "incomplete octet");
                ByteString byteString = new ByteString(bitString.getAsByteArray());
                return rexBuilder.makeBinaryLiteral(byteString);
            }
            case SYMBOL: {
                return rexBuilder.makeFlag((Enum)value);
            }
            case TIMESTAMP: {
                return rexBuilder.makeTimestampLiteral((Calendar)value, ((SqlTimestampLiteral)literal).getPrec());
            }
            case TIME: {
                return rexBuilder.makeTimeLiteral((Calendar)value, ((SqlTimeLiteral)literal).getPrec());
            }
            case DATE: {
                return rexBuilder.makeDateLiteral((Calendar)value);
            }
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: {
                SqlIntervalQualifier sqlIntervalQualifier = ((SqlIntervalLiteral.IntervalValue)value).getIntervalQualifier();
                long l = (Long)SqlLiteral.value(literal);
                return rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(l), sqlIntervalQualifier);
            }
        }
        throw Util.unexpected(literal.getTypeName());
    }
}

