/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.validate;

import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlInsert;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.validate.AbstractNamespace;
import hive.org.apache.calcite.sql.validate.SqlModality;
import hive.org.apache.calcite.sql.validate.SqlValidatorImpl;
import hive.org.apache.calcite.sql.validate.SqlValidatorScope;
import hive.org.apache.calcite.util.Static;

public class TableConstructorNamespace
extends AbstractNamespace {
    private final SqlCall values;
    private final SqlValidatorScope scope;

    TableConstructorNamespace(SqlValidatorImpl validator, SqlCall values, SqlValidatorScope scope, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.values = values;
        this.scope = scope;
    }

    @Override
    protected RelDataType validateImpl() {
        RelDataType targetRowType;
        if (this.enclosingNode instanceof SqlInsert) {
            SqlInsert node = (SqlInsert)this.enclosingNode;
            targetRowType = this.validator.getValidatedNodeType(node);
        } else {
            targetRowType = this.validator.getUnknownType();
        }
        this.validator.validateValues(this.values, targetRowType, this.scope);
        RelDataType tableConstructorRowType = this.validator.getTableConstructorRowType(this.values, this.scope);
        if (tableConstructorRowType == null) {
            throw this.validator.newValidationError(this.values, Static.RESOURCE.incompatibleTypes());
        }
        return tableConstructorRowType;
    }

    @Override
    public SqlNode getNode() {
        return this.values;
    }

    public SqlValidatorScope getScope() {
        return this.scope;
    }

    @Override
    public boolean supportsModality(SqlModality modality) {
        return modality == SqlModality.RELATION;
    }
}

