/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.validate;

import hive.com.google.common.collect.ImmutableMap;
import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import hive.org.apache.calcite.linq4j.tree.BlockBuilder;
import hive.org.apache.calcite.linq4j.tree.BlockStatement;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.linq4j.tree.Expressions;
import hive.org.apache.calcite.linq4j.tree.FunctionExpression;
import hive.org.apache.calcite.linq4j.tree.Statement;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import hive.org.apache.calcite.schema.Function;
import hive.org.apache.calcite.schema.FunctionParameter;
import hive.org.apache.calcite.schema.TableMacro;
import hive.org.apache.calcite.schema.TranslatableTable;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlFunction;
import hive.org.apache.calcite.sql.SqlFunctionCategory;
import hive.org.apache.calcite.sql.SqlIdentifier;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlLiteral;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlUtil;
import hive.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import hive.org.apache.calcite.sql.type.SqlOperandTypeInference;
import hive.org.apache.calcite.sql.type.SqlReturnTypeInference;
import hive.org.apache.calcite.util.ImmutableNullableList;
import hive.org.apache.calcite.util.NlsString;
import hive.org.apache.calcite.util.Pair;
import hive.org.apache.calcite.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SqlUserDefinedTableMacro
extends SqlFunction {
    private final TableMacro tableMacro;

    public SqlUserDefinedTableMacro(SqlIdentifier opName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, TableMacro tableMacro) {
        super(Util.last(opName.names), opName, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, operandTypeChecker, null, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        this.tableMacro = tableMacro;
    }

    public TranslatableTable getTable(RelDataTypeFactory typeFactory, List<SqlNode> operandList) {
        List<Object> arguments = SqlUserDefinedTableMacro.convertArguments(typeFactory, operandList, this.tableMacro, this.getNameAsId(), true);
        return this.tableMacro.apply(arguments);
    }

    public static List<Object> convertArguments(RelDataTypeFactory typeFactory, List<SqlNode> operandList, Function function, SqlIdentifier opName, boolean failOnNonLiteral) {
        ArrayList<Object> arguments = new ArrayList<Object>(operandList.size());
        for (Pair<FunctionParameter, SqlNode> pair : Pair.zip(function.getParameters(), operandList)) {
            try {
                Object o = SqlUserDefinedTableMacro.getValue((SqlNode)pair.right);
                Object o2 = SqlUserDefinedTableMacro.coerce(o, ((FunctionParameter)pair.left).getType(typeFactory));
                arguments.add(o2);
            }
            catch (NonLiteralException e) {
                if (failOnNonLiteral) {
                    throw new IllegalArgumentException("All arguments of call to macro " + opName + " should be literal. Actual argument #" + ((FunctionParameter)pair.left).getOrdinal() + " (" + ((FunctionParameter)pair.left).getName() + ") is not literal: " + pair.right);
                }
                arguments.add(null);
            }
        }
        return arguments;
    }

    private static Object getValue(SqlNode right) throws NonLiteralException {
        switch (right.getKind()) {
            case ARRAY_VALUE_CONSTRUCTOR: {
                ArrayList<Object> list = Lists.newArrayList();
                for (SqlNode o : ((SqlCall)right).getOperandList()) {
                    list.add(SqlUserDefinedTableMacro.getValue(o));
                }
                return ImmutableNullableList.copyOf(list);
            }
            case MAP_VALUE_CONSTRUCTOR: {
                ImmutableMap.Builder<Object, Object> builder2 = ImmutableMap.builder();
                List<SqlNode> operands = ((SqlCall)right).getOperandList();
                for (int i = 0; i < operands.size(); i += 2) {
                    SqlNode key = operands.get(i);
                    SqlNode value = operands.get(i + 1);
                    builder2.put(SqlUserDefinedTableMacro.getValue(key), SqlUserDefinedTableMacro.getValue(value));
                }
                return builder2.build();
            }
        }
        if (SqlUtil.isNullLiteral(right, true)) {
            return null;
        }
        if (SqlUtil.isLiteral(right)) {
            return ((SqlLiteral)right).getValue();
        }
        throw new NonLiteralException();
    }

    private static Object coerce(Object o, RelDataType type) {
        if (o == null) {
            return null;
        }
        if (!(type instanceof RelDataTypeFactoryImpl.JavaType)) {
            return null;
        }
        RelDataTypeFactoryImpl.JavaType javaType = (RelDataTypeFactoryImpl.JavaType)type;
        Class clazz = javaType.getJavaClass();
        if (clazz.isAssignableFrom(o.getClass())) {
            return o;
        }
        if (clazz == String.class && o instanceof NlsString) {
            return ((NlsString)o).getValue();
        }
        BlockBuilder bb = new BlockBuilder();
        Expression expr = RexToLixTranslator.convert((Expression)Expressions.constant((Object)o), clazz);
        bb.add((Statement)Expressions.return_(null, (Expression)expr));
        FunctionExpression convert = Expressions.lambda((BlockStatement)bb.toBlock(), Collections.emptyList());
        return convert.compile().dynamicInvoke(new Object[0]);
    }

    private static class NonLiteralException
    extends Exception {
        private NonLiteralException() {
        }
    }
}

