/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.validate;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlIdentifier;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlNodeList;
import hive.org.apache.calcite.sql.SqlSelect;
import hive.org.apache.calcite.sql.SqlWindow;
import hive.org.apache.calcite.sql.parser.SqlParserPos;
import hive.org.apache.calcite.sql.validate.SchemaNamespace;
import hive.org.apache.calcite.sql.validate.SqlMoniker;
import hive.org.apache.calcite.sql.validate.SqlMonikerImpl;
import hive.org.apache.calcite.sql.validate.SqlMonikerType;
import hive.org.apache.calcite.sql.validate.SqlMonotonicity;
import hive.org.apache.calcite.sql.validate.SqlQualified;
import hive.org.apache.calcite.sql.validate.SqlValidator;
import hive.org.apache.calcite.sql.validate.SqlValidatorImpl;
import hive.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import hive.org.apache.calcite.sql.validate.SqlValidatorScope;
import hive.org.apache.calcite.util.Pair;
import hive.org.apache.calcite.util.Static;
import java.util.Collection;
import java.util.List;

public abstract class DelegatingScope
implements SqlValidatorScope {
    protected final SqlValidatorScope parent;
    protected final SqlValidatorImpl validator;

    DelegatingScope(SqlValidatorScope parent) {
        assert (parent != null);
        this.validator = (SqlValidatorImpl)parent.getValidator();
        this.parent = parent;
    }

    @Override
    public void addChild(SqlValidatorNamespace ns, String alias) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqlValidatorNamespace resolve(List<String> names, SqlValidatorScope[] ancestorOut, int[] offsetOut) {
        return this.parent.resolve(names, ancestorOut, offsetOut);
    }

    protected void addColumnNames(SqlValidatorNamespace ns, List<SqlMoniker> colNames) {
        RelDataType rowType;
        try {
            rowType = ns.getRowType();
        }
        catch (Error e) {
            return;
        }
        for (RelDataTypeField field : rowType.getFieldList()) {
            colNames.add(new SqlMonikerImpl(field.getName(), SqlMonikerType.COLUMN));
        }
    }

    @Override
    public void findAllColumnNames(List<SqlMoniker> result) {
        this.parent.findAllColumnNames(result);
    }

    @Override
    public void findAliases(Collection<SqlMoniker> result) {
        this.parent.findAliases(result);
    }

    @Override
    public Pair<String, SqlValidatorNamespace> findQualifyingTableName(String columnName, SqlNode ctx) {
        return this.parent.findQualifyingTableName(columnName, ctx);
    }

    @Override
    public RelDataType resolveColumn(String name, SqlNode ctx) {
        return this.parent.resolveColumn(name, ctx);
    }

    @Override
    public RelDataType nullifyType(SqlNode node, RelDataType type) {
        return this.parent.nullifyType(node, type);
    }

    @Override
    public SqlValidatorNamespace getTableNamespace(List<String> names) {
        return this.parent.getTableNamespace(names);
    }

    @Override
    public SqlValidatorScope getOperandScope(SqlCall call) {
        if (call instanceof SqlSelect) {
            return this.validator.getSelectScope((SqlSelect)call);
        }
        return this;
    }

    @Override
    public SqlValidator getValidator() {
        return this.validator;
    }

    @Override
    public SqlQualified fullyQualify(SqlIdentifier identifier) {
        int i;
        if (identifier.isStar()) {
            return SqlQualified.create(this, 1, null, identifier);
        }
        switch (identifier.names.size()) {
            case 1: {
                String columnName = (String)identifier.names.get(0);
                Pair<String, SqlValidatorNamespace> pair = this.findQualifyingTableName(columnName, identifier);
                String tableName = (String)pair.left;
                SqlValidatorNamespace namespace = (SqlValidatorNamespace)pair.right;
                SqlParserPos pos = identifier.getParserPosition();
                RelDataType fromRowType = namespace.getRowType();
                RelDataTypeField field = this.validator.catalogReader.field(fromRowType, columnName);
                if (field != null && field.getName().startsWith("*") && !columnName.startsWith("*") && this.getStarColumnCount(fromRowType) > 1) {
                    throw this.validator.newValidationError(identifier, Static.RESOURCE.columnAmbiguous(columnName));
                }
                SqlIdentifier expanded = new SqlIdentifier(ImmutableList.of(tableName, field.getName()), null, pos, ImmutableList.of(SqlParserPos.ZERO, pos));
                this.validator.setOriginal(expanded, identifier);
                return SqlQualified.create(this, 1, namespace, expanded);
            }
        }
        SqlValidatorNamespace fromNs = null;
        int size = identifier.names.size();
        for (i = size - 1; i > 0; --i) {
            SqlIdentifier prefix = identifier.getComponent(0, i);
            fromNs = this.resolve(prefix.names, null, null);
            if (fromNs != null) break;
        }
        if (fromNs == null || fromNs instanceof SchemaNamespace) {
            SqlIdentifier prefix1 = identifier.skipLast(1);
            throw this.validator.newValidationError(prefix1, Static.RESOURCE.tableNameNotFound(prefix1.toString()));
        }
        RelDataType fromRowType = fromNs.getRowType();
        for (int j = i; j < size; ++j) {
            SqlIdentifier last = identifier.getComponent(j);
            String columnName = last.getSimple();
            RelDataTypeField field = this.validator.catalogReader.field(fromRowType, columnName);
            if (field == null) {
                throw this.validator.newValidationError(last, Static.RESOURCE.columnNotFoundInTable(columnName, identifier.getComponent(0, j).toString()));
            }
            if (field.getName().startsWith("*") && !columnName.startsWith("*") && this.getStarColumnCount(fromRowType) > 1) {
                throw this.validator.newValidationError(identifier, Static.RESOURCE.columnAmbiguous(columnName));
            }
            identifier = identifier.setName(j, field.getName());
            fromRowType = field.getType();
        }
        return SqlQualified.create(this, i, fromNs, identifier);
    }

    @Override
    public void validateExpr(SqlNode expr) {
    }

    @Override
    public SqlWindow lookupWindow(String name) {
        return this.parent.lookupWindow(name);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlNode expr) {
        return this.parent.getMonotonicity(expr);
    }

    @Override
    public SqlNodeList getOrderList() {
        return this.parent.getOrderList();
    }

    public SqlValidatorScope getParent() {
        return this.parent;
    }

    private int getStarColumnCount(RelDataType rowType) {
        int count = 0;
        for (String fieldName : rowType.getFieldNames()) {
            if (!fieldName.startsWith("*")) continue;
            ++count;
        }
        return count;
    }
}

