/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.type;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.sql.SqlOperatorBinding;
import hive.org.apache.calcite.sql.type.SqlReturnTypeInference;

public class SqlReturnTypeInferenceChain
implements SqlReturnTypeInference {
    private final ImmutableList<SqlReturnTypeInference> rules;

    SqlReturnTypeInferenceChain(SqlReturnTypeInference ... rules) {
        assert (rules != null);
        assert (rules.length > 1);
        for (SqlReturnTypeInference rule : rules) {
            assert (rule != null);
        }
        this.rules = ImmutableList.copyOf(rules);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        for (SqlReturnTypeInference rule : this.rules) {
            RelDataType ret = rule.inferReturnType(opBinding);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }
}

