/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.type;

import hive.org.apache.calcite.sql.SqlOperandCountRange;

public abstract class SqlOperandCountRanges {
    public static SqlOperandCountRange of(int length) {
        return new RangeImpl(length, length);
    }

    public static SqlOperandCountRange between(int min, int max) {
        assert (min < max);
        return new RangeImpl(min, max);
    }

    public static SqlOperandCountRange from(int min) {
        return new RangeImpl(min, -1);
    }

    public static SqlOperandCountRange any() {
        return new RangeImpl(0, -1);
    }

    private static class RangeImpl
    implements SqlOperandCountRange {
        private final int min;
        private final int max;

        public RangeImpl(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public boolean isValidCount(int count) {
            return count >= this.min && (this.max == -1 || count <= this.max);
        }

        @Override
        public int getMin() {
            return this.min;
        }

        @Override
        public int getMax() {
            return this.max;
        }
    }
}

