/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.type;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlCallBinding;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlOperandCountRange;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.type.OperandTypes;
import hive.org.apache.calcite.sql.type.SqlOperandCountRanges;
import hive.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import hive.org.apache.calcite.util.Static;

public class MultisetOperandTypeChecker
implements SqlOperandTypeChecker {
    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlCall call = callBinding.getCall();
        Object op0 = call.operand(0);
        if (!OperandTypes.MULTISET.checkSingleOperandType(callBinding, (SqlNode)op0, 0, throwOnFailure)) {
            return false;
        }
        Object op1 = call.operand(1);
        if (!OperandTypes.MULTISET.checkSingleOperandType(callBinding, (SqlNode)op1, 0, throwOnFailure)) {
            return false;
        }
        RelDataType biggest = callBinding.getTypeFactory().leastRestrictive(ImmutableList.of(callBinding.getValidator().deriveType(callBinding.getScope(), (SqlNode)op0).getComponentType(), callBinding.getValidator().deriveType(callBinding.getScope(), (SqlNode)op1).getComponentType()));
        if (null == biggest) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.typeNotComparable(((SqlNode)op0).getParserPosition().toString(), ((SqlNode)op1).getParserPosition().toString()));
            }
            return false;
        }
        return true;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return "<MULTISET> " + opName + " <MULTISET>";
    }

    @Override
    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }
}

