/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.type;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.sql.SqlOperatorBinding;
import hive.org.apache.calcite.sql.type.SqlReturnTypeInference;
import hive.org.apache.calcite.sql.type.SqlTypeName;
import hive.org.apache.calcite.sql.type.SqlTypeUtil;
import java.util.List;

public class MatchReturnTypeInference
implements SqlReturnTypeInference {
    private final int start;
    private final List<SqlTypeName> typeNames;

    public MatchReturnTypeInference(int start, SqlTypeName ... typeNames) {
        this(start, ImmutableList.copyOf(typeNames));
    }

    public MatchReturnTypeInference(int start, List<SqlTypeName> typeNames) {
        assert (start >= 0);
        assert (null != typeNames);
        assert (typeNames.size() > 0);
        this.start = start;
        this.typeNames = ImmutableList.copyOf(typeNames);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        for (int i = this.start; i < opBinding.getOperandCount(); ++i) {
            RelDataType argType = opBinding.getOperandType(i);
            if (!SqlTypeUtil.isOfSameTypeName(this.typeNames, argType)) continue;
            return argType;
        }
        return null;
    }
}

