/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.parser;

import hive.com.google.common.base.Preconditions;
import hive.org.apache.calcite.avatica.util.Casing;
import hive.org.apache.calcite.avatica.util.Quoting;
import hive.org.apache.calcite.config.Lex;
import hive.org.apache.calcite.runtime.CalciteContextException;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import hive.org.apache.calcite.sql.parser.SqlParseException;
import hive.org.apache.calcite.sql.parser.SqlParserImplFactory;
import hive.org.apache.calcite.sql.parser.impl.SqlParserImpl;
import java.io.StringReader;

public class SqlParser {
    public static final int DEFAULT_IDENTIFIER_MAX_LENGTH = 128;
    private final SqlAbstractParserImpl parser;
    private final String originalInput;

    private SqlParser(String s, SqlAbstractParserImpl parser, Config config) {
        this.originalInput = s;
        this.parser = parser;
        parser.setTabSize(1);
        parser.setQuotedCasing(config.quotedCasing());
        parser.setUnquotedCasing(config.unquotedCasing());
        parser.setIdentifierMaxLength(config.identifierMaxLength());
        switch (config.quoting()) {
            case DOUBLE_QUOTE: {
                parser.switchTo("DQID");
                break;
            }
            case BACK_TICK: {
                parser.switchTo("BTID");
                break;
            }
            case BRACKET: {
                parser.switchTo("DEFAULT");
            }
        }
    }

    public static SqlParser create(String s) {
        return SqlParser.create(s, SqlParser.configBuilder().build());
    }

    public static SqlParser create(String sql, Config config) {
        SqlAbstractParserImpl parser = config.parserFactory().getParser(new StringReader(sql));
        return new SqlParser(sql, parser, config);
    }

    public SqlNode parseExpression() throws SqlParseException {
        try {
            return this.parser.parseSqlExpressionEof();
        }
        catch (Throwable ex) {
            if (ex instanceof CalciteContextException && this.originalInput != null) {
                ((CalciteContextException)ex).setOriginalStatement(this.originalInput);
            }
            throw this.parser.normalizeException(ex);
        }
    }

    public SqlNode parseQuery() throws SqlParseException {
        try {
            return this.parser.parseSqlStmtEof();
        }
        catch (Throwable ex) {
            if (ex instanceof CalciteContextException && this.originalInput != null) {
                ((CalciteContextException)ex).setOriginalStatement(this.originalInput);
            }
            throw this.parser.normalizeException(ex);
        }
    }

    public SqlNode parseStmt() throws SqlParseException {
        try {
            return this.parser.parseSqlStmtEof();
        }
        catch (Throwable ex) {
            if (ex instanceof CalciteContextException && this.originalInput != null) {
                ((CalciteContextException)ex).setOriginalStatement(this.originalInput);
            }
            throw this.parser.normalizeException(ex);
        }
    }

    public SqlAbstractParserImpl.Metadata getMetadata() {
        return this.parser.getMetadata();
    }

    public static ConfigBuilder configBuilder() {
        return new ConfigBuilder();
    }

    public static ConfigBuilder configBuilder(Config config) {
        return new ConfigBuilder().setConfig(config);
    }

    private static class ConfigImpl
    implements Config {
        private final int identifierMaxLength;
        private final boolean caseSensitive;
        private final Casing quotedCasing;
        private final Casing unquotedCasing;
        private final Quoting quoting;
        private final SqlParserImplFactory parserFactory;

        private ConfigImpl(int identifierMaxLength, Casing quotedCasing, Casing unquotedCasing, Quoting quoting, boolean caseSensitive, SqlParserImplFactory parserFactory) {
            this.identifierMaxLength = identifierMaxLength;
            this.caseSensitive = caseSensitive;
            this.quotedCasing = Preconditions.checkNotNull(quotedCasing);
            this.unquotedCasing = Preconditions.checkNotNull(unquotedCasing);
            this.quoting = Preconditions.checkNotNull(quoting);
            this.parserFactory = Preconditions.checkNotNull(parserFactory);
        }

        @Override
        public int identifierMaxLength() {
            return this.identifierMaxLength;
        }

        @Override
        public Casing quotedCasing() {
            return this.quotedCasing;
        }

        @Override
        public Casing unquotedCasing() {
            return this.unquotedCasing;
        }

        @Override
        public Quoting quoting() {
            return this.quoting;
        }

        @Override
        public boolean caseSensitive() {
            return this.caseSensitive;
        }

        @Override
        public SqlParserImplFactory parserFactory() {
            return this.parserFactory;
        }
    }

    public static class ConfigBuilder {
        private Casing quotedCasing;
        private Casing unquotedCasing;
        private Quoting quoting;
        private int identifierMaxLength;
        private boolean caseSensitive;
        private SqlParserImplFactory parserFactory;

        private ConfigBuilder() {
            this.quotedCasing = Lex.ORACLE.quotedCasing;
            this.unquotedCasing = Lex.ORACLE.unquotedCasing;
            this.quoting = Lex.ORACLE.quoting;
            this.identifierMaxLength = 128;
            this.caseSensitive = Lex.ORACLE.caseSensitive;
            this.parserFactory = SqlParserImpl.FACTORY;
        }

        public ConfigBuilder setConfig(Config config) {
            this.quotedCasing = config.quotedCasing();
            this.unquotedCasing = config.unquotedCasing();
            this.quoting = config.quoting();
            this.identifierMaxLength = config.identifierMaxLength();
            this.parserFactory = config.parserFactory();
            return this;
        }

        public ConfigBuilder setQuotedCasing(Casing quotedCasing) {
            this.quotedCasing = Preconditions.checkNotNull(quotedCasing);
            return this;
        }

        public ConfigBuilder setUnquotedCasing(Casing unquotedCasing) {
            this.unquotedCasing = Preconditions.checkNotNull(unquotedCasing);
            return this;
        }

        public ConfigBuilder setQuoting(Quoting quoting) {
            this.quoting = Preconditions.checkNotNull(quoting);
            return this;
        }

        public ConfigBuilder setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public ConfigBuilder setIdentifierMaxLength(int identifierMaxLength) {
            this.identifierMaxLength = identifierMaxLength;
            return this;
        }

        public ConfigBuilder setParserFactory(SqlParserImplFactory factory) {
            this.parserFactory = Preconditions.checkNotNull(factory);
            return this;
        }

        public ConfigBuilder setLex(Lex lex) {
            this.setCaseSensitive(lex.caseSensitive);
            this.setUnquotedCasing(lex.unquotedCasing);
            this.setQuotedCasing(lex.quotedCasing);
            this.setQuoting(lex.quoting);
            return this;
        }

        public Config build() {
            return new ConfigImpl(this.identifierMaxLength, this.quotedCasing, this.unquotedCasing, this.quoting, this.caseSensitive, this.parserFactory);
        }
    }

    public static interface Config {
        public static final Config DEFAULT = SqlParser.configBuilder().build();

        public int identifierMaxLength();

        public Casing quotedCasing();

        public Casing unquotedCasing();

        public Quoting quoting();

        public boolean caseSensitive();

        public SqlParserImplFactory parserFactory();
    }
}

