/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlIdentifier;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.SqlSpecialOperator;
import hive.org.apache.calcite.sql.SqlWriter;
import hive.org.apache.calcite.sql.parser.SqlParserPos;
import hive.org.apache.calcite.sql.validate.SqlValidator;
import hive.org.apache.calcite.sql.validate.SqlValidatorScope;
import java.util.List;

public class SqlSetOption
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("SET_OPTION", SqlKind.SET_OPTION);
    String scope;
    String name;
    SqlNode value;

    public SqlSetOption(SqlParserPos pos, String scope, String name, SqlNode value) {
        super(pos);
        this.scope = scope;
        this.name = name;
        this.value = value;
        assert (scope != null);
        assert (name != null);
        assert (value != null);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.SET_OPTION;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(new SqlIdentifier(this.scope, SqlParserPos.ZERO), new SqlIdentifier(this.name, SqlParserPos.ZERO), this.value);
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.scope = ((SqlIdentifier)operand).getSimple();
                break;
            }
            case 1: {
                this.name = ((SqlIdentifier)operand).getSimple();
                break;
            }
            case 2: {
                this.value = operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ALTER");
        writer.keyword(this.getScope());
        writer.keyword("SET");
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE);
        writer.identifier(this.getName());
        writer.sep("=");
        this.value.unparse(writer, leftPrec, rightPrec);
        writer.endList(frame);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validate(this.value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public SqlNode getValue() {
        return this.value;
    }

    public void setValue(SqlNode value) {
        this.value = value;
    }
}

