/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql;

import hive.com.google.common.collect.ImmutableCollection;
import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlCollation;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlUtil;
import hive.org.apache.calcite.sql.SqlWriter;
import hive.org.apache.calcite.sql.parser.SqlParserPos;
import hive.org.apache.calcite.sql.util.SqlVisitor;
import hive.org.apache.calcite.sql.validate.SqlMonotonicity;
import hive.org.apache.calcite.sql.validate.SqlQualified;
import hive.org.apache.calcite.sql.validate.SqlValidator;
import hive.org.apache.calcite.sql.validate.SqlValidatorScope;
import hive.org.apache.calcite.util.Util;
import java.util.List;

public class SqlIdentifier
extends SqlNode {
    public ImmutableList<String> names;
    final SqlCollation collation;
    private ImmutableList<SqlParserPos> componentPositions;

    public SqlIdentifier(List<String> names, SqlCollation collation, SqlParserPos pos, List<SqlParserPos> componentPositions) {
        super(pos);
        this.names = ImmutableList.copyOf(names);
        this.collation = collation;
        this.componentPositions = componentPositions == null ? null : ImmutableList.copyOf(componentPositions);
        for (String name : names) {
            assert (name != null);
        }
    }

    public SqlIdentifier(List<String> names, SqlParserPos pos) {
        this(names, null, pos, null);
    }

    public SqlIdentifier(String name, SqlCollation collation, SqlParserPos pos) {
        this(ImmutableList.of(name), collation, pos, null);
    }

    public SqlIdentifier(String name, SqlParserPos pos) {
        this(ImmutableList.of(name), null, pos, null);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.IDENTIFIER;
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlIdentifier(this.names, this.collation, pos, this.componentPositions);
    }

    @Override
    public String toString() {
        return Util.sepList(this.names, ".");
    }

    public void setNames(List<String> names, List<SqlParserPos> poses) {
        this.names = ImmutableList.copyOf(names);
        this.componentPositions = poses == null ? null : ImmutableList.copyOf(poses);
    }

    public SqlIdentifier setName(int i, String name) {
        if (!((String)this.names.get(i)).equals(name)) {
            String[] nameArray = this.names.toArray(new String[this.names.size()]);
            nameArray[i] = name;
            return new SqlIdentifier(ImmutableList.copyOf(nameArray), this.collation, this.pos, this.componentPositions);
        }
        return this;
    }

    public SqlParserPos getComponentParserPosition(int i) {
        assert (i >= 0 && i < this.names.size());
        return this.componentPositions == null ? this.getParserPosition() : (SqlParserPos)this.componentPositions.get(i);
    }

    public void assignNamesFrom(SqlIdentifier other) {
        this.setNames(other.names, other.componentPositions);
    }

    public SqlIdentifier getComponent(int ordinal) {
        return this.getComponent(ordinal, ordinal + 1);
    }

    public SqlIdentifier getComponent(int from, int to) {
        SqlParserPos pos;
        List pos2;
        if (this.componentPositions == null) {
            pos2 = null;
            pos = this.pos;
        } else {
            pos2 = this.componentPositions.subList(from, to);
            pos = SqlParserPos.sum(pos2);
        }
        return new SqlIdentifier(this.names.subList(from, to), this.collation, pos, pos2);
    }

    public SqlIdentifier plus(String name, SqlParserPos pos) {
        ImmutableCollection names = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.names)).add(name)).build();
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.componentPositions != null) {
            builder.addAll(this.componentPositions);
        }
        ImmutableCollection componentPositions = ((ImmutableList.Builder)builder.add(pos)).build();
        SqlParserPos pos2 = SqlParserPos.sum(((ImmutableList.Builder)builder.add(this.pos)).build());
        return new SqlIdentifier((List<String>)((Object)names), this.collation, pos2, (List<SqlParserPos>)((Object)componentPositions));
    }

    public SqlIdentifier skipLast(int n) {
        return this.getComponent(0, this.names.size() - n);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.IDENTIFIER);
        for (String name : this.names) {
            writer.sep(".");
            if (name.equals("*")) {
                writer.print(name);
                continue;
            }
            writer.identifier(name);
        }
        if (null != this.collation) {
            this.collation.unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(frame);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateIdentifier(this, scope);
    }

    @Override
    public void validateExpr(SqlValidator validator, SqlValidatorScope scope) {
        SqlCall call = SqlUtil.makeCall(validator.getOperatorTable(), this);
        if (call != null) {
            validator.validateCall(call, scope);
            return;
        }
        validator.validateIdentifier(this, scope);
    }

    @Override
    public boolean equalsDeep(SqlNode node, boolean fail) {
        if (!(node instanceof SqlIdentifier)) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        SqlIdentifier that = (SqlIdentifier)node;
        if (this.names.size() != that.names.size()) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        for (int i = 0; i < this.names.size(); ++i) {
            if (((String)this.names.get(i)).equals(that.names.get(i))) continue;
            assert (!fail) : this + "!=" + node;
            return false;
        }
        return true;
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public SqlCollation getCollation() {
        return this.collation;
    }

    public String getSimple() {
        assert (this.names.size() == 1);
        return (String)this.names.get(0);
    }

    public boolean isStar() {
        return Util.last(this.names).equals("*");
    }

    public boolean isSimple() {
        return this.names.size() == 1 && !((String)this.names.get(0)).equals("*");
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlValidatorScope scope) {
        if (Util.last(this.names).startsWith("*")) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        SqlValidator validator = scope.getValidator();
        SqlCall call = SqlUtil.makeCall(validator.getOperatorTable(), this);
        if (call != null) {
            return call.getMonotonicity(scope);
        }
        SqlQualified qualified = scope.fullyQualify(this);
        SqlIdentifier fqId = qualified.identifier;
        return qualified.namespace.resolve().getMonotonicity(Util.last(fqId.names));
    }
}

