/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.schema.impl;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.schema.Function;
import hive.org.apache.calcite.schema.FunctionParameter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;

public abstract class ReflectiveFunctionBase
implements Function {
    public final Method method;
    public final List<FunctionParameter> parameters;

    public ReflectiveFunctionBase(Method method) {
        this.method = method;
        this.parameters = ReflectiveFunctionBase.toFunctionParameters(method.getParameterTypes());
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return this.parameters;
    }

    public static ImmutableList<FunctionParameter> toFunctionParameters(Class ... types) {
        return ReflectiveFunctionBase.toFunctionParameters(Arrays.asList(types));
    }

    public static ImmutableList<FunctionParameter> toFunctionParameters(Iterable<? extends Class> types) {
        ImmutableList.Builder res = ImmutableList.builder();
        int i = 0;
        for (final Class clazz : types) {
            final int ordinal = i++;
            res.add(new FunctionParameter(){

                @Override
                public int getOrdinal() {
                    return ordinal;
                }

                @Override
                public String getName() {
                    return "arg" + ordinal;
                }

                @Override
                public RelDataType getType(RelDataTypeFactory typeFactory) {
                    return typeFactory.createJavaType(clazz);
                }
            });
        }
        return res.build();
    }

    static boolean classHasPublicZeroArgsConstructor(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
            return true;
        }
        return false;
    }

    static Method findMethod(Class<?> clazz, String name) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }
}

