/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.core.SetOp;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexNode;
import java.util.ArrayList;
import java.util.List;

public class FilterSetOpTransposeRule
extends RelOptRule {
    public static final FilterSetOpTransposeRule INSTANCE = new FilterSetOpTransposeRule(RelFactories.DEFAULT_FILTER_FACTORY);
    private final RelFactories.FilterFactory filterFactory;

    public FilterSetOpTransposeRule(RelFactories.FilterFactory filterFactory) {
        super(FilterSetOpTransposeRule.operand(Filter.class, FilterSetOpTransposeRule.operand(SetOp.class, FilterSetOpTransposeRule.any()), new RelOptRuleOperand[0]));
        this.filterFactory = filterFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filterRel = (Filter)call.rel(0);
        SetOp setOp = (SetOp)call.rel(1);
        RexNode condition = filterRel.getCondition();
        RexBuilder rexBuilder = filterRel.getCluster().getRexBuilder();
        List<RelDataTypeField> origFields = setOp.getRowType().getFieldList();
        int[] adjustments = new int[origFields.size()];
        ArrayList<RelNode> newSetOpInputs = new ArrayList<RelNode>();
        for (RelNode input : setOp.getInputs()) {
            RexNode newCondition = condition.accept(new RelOptUtil.RexInputConverter(rexBuilder, origFields, input.getRowType().getFieldList(), adjustments));
            newSetOpInputs.add(this.filterFactory.createFilter(input, newCondition));
        }
        RelNode newSetOp = setOp.copy(setOp.getTraitSet(), newSetOpInputs);
        call.transformTo(newSetOp);
    }
}

