/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.metadata;

import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.avatica.util.ByteString;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Aggregate;
import hive.org.apache.calcite.rel.core.AggregateCall;
import hive.org.apache.calcite.rel.core.Exchange;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.Intersect;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.Minus;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.SemiJoin;
import hive.org.apache.calcite.rel.core.Sort;
import hive.org.apache.calcite.rel.core.TableScan;
import hive.org.apache.calcite.rel.core.Union;
import hive.org.apache.calcite.rel.core.Values;
import hive.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.ImmutableNullableList;
import hive.org.apache.calcite.util.NlsString;
import hive.org.apache.calcite.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RelMdSize {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Object)new RelMdSize(), BuiltInMethod.AVERAGE_COLUMN_SIZES.method, BuiltInMethod.AVERAGE_ROW_SIZE.method);
    public static final int BYTES_PER_CHARACTER = 2;

    protected RelMdSize() {
    }

    public Double averageRowSize(RelNode rel) {
        List<Double> averageColumnSizes = RelMetadataQuery.getAverageColumnSizes(rel);
        if (averageColumnSizes == null) {
            return null;
        }
        Double d = 0.0;
        List<RelDataTypeField> fields = rel.getRowType().getFieldList();
        for (Pair<Double, RelDataTypeField> p : Pair.zip(averageColumnSizes, fields)) {
            if (p.left == null) {
                d = d + this.averageFieldValueSize((RelDataTypeField)p.right);
                continue;
            }
            d = d + (Double)p.left;
        }
        return d;
    }

    public List<Double> averageColumnSizes(RelNode rel) {
        return null;
    }

    public List<Double> averageColumnSizes(Filter rel) {
        return RelMetadataQuery.getAverageColumnSizes(rel.getInput());
    }

    public List<Double> averageColumnSizes(Sort rel) {
        return RelMetadataQuery.getAverageColumnSizes(rel.getInput());
    }

    public List<Double> averageColumnSizes(Exchange rel) {
        return RelMetadataQuery.getAverageColumnSizes(rel.getInput());
    }

    public List<Double> averageColumnSizes(Project rel) {
        List<Double> inputColumnSizes = RelMetadataQuery.getAverageColumnSizesNotNull(rel.getInput());
        ImmutableNullableList.Builder<Double> sizes = ImmutableNullableList.builder();
        for (RexNode project : rel.getProjects()) {
            sizes.add(this.averageRexSize(project, inputColumnSizes));
        }
        return sizes.build();
    }

    public List<Double> averageColumnSizes(Values rel) {
        List<RelDataTypeField> fields = rel.getRowType().getFieldList();
        ImmutableList.Builder list = ImmutableList.builder();
        for (int i = 0; i < fields.size(); ++i) {
            double d;
            RelDataTypeField field = fields.get(i);
            if (rel.getTuples().isEmpty()) {
                d = this.averageTypeValueSize(field.getType());
            } else {
                d = 0.0;
                for (ImmutableList immutableList : rel.getTuples()) {
                    d += this.typeValueSize(field.getType(), ((RexLiteral)immutableList.get(i)).getValue());
                }
                d /= (double)rel.getTuples().size();
            }
            list.add((Object)d);
        }
        return list.build();
    }

    public List<Double> averageColumnSizes(TableScan rel) {
        List<RelDataTypeField> fields = rel.getRowType().getFieldList();
        ImmutableList.Builder list = ImmutableList.builder();
        for (RelDataTypeField field : fields) {
            list.add(this.averageTypeValueSize(field.getType()));
        }
        return list.build();
    }

    public List<Double> averageColumnSizes(Aggregate rel) {
        List<Double> inputColumnSizes = RelMetadataQuery.getAverageColumnSizesNotNull(rel.getInput());
        ImmutableList.Builder list = ImmutableList.builder();
        Iterator<Object> i$ = rel.getGroupSet().iterator();
        while (i$.hasNext()) {
            int key = i$.next();
            list.add(inputColumnSizes.get(key));
        }
        for (AggregateCall aggregateCall : rel.getAggCallList()) {
            list.add(this.averageTypeValueSize(aggregateCall.type));
        }
        return list.build();
    }

    public List<Double> averageColumnSizes(SemiJoin rel) {
        return this.averageJoinColumnSizes(rel, true);
    }

    public List<Double> averageColumnSizes(Join rel) {
        return this.averageJoinColumnSizes(rel, false);
    }

    private List<Double> averageJoinColumnSizes(Join rel, boolean semijoin) {
        List<Double> rights;
        RelNode left = rel.getLeft();
        RelNode right = rel.getRight();
        List<Double> lefts = RelMetadataQuery.getAverageColumnSizes(left);
        List<Double> list = rights = semijoin ? null : RelMetadataQuery.getAverageColumnSizes(right);
        if (lefts == null && rights == null) {
            return null;
        }
        int fieldCount = rel.getRowType().getFieldCount();
        Double[] sizes = new Double[fieldCount];
        if (lefts != null) {
            lefts.toArray(sizes);
        }
        if (rights != null) {
            int leftCount = left.getRowType().getFieldCount();
            for (int i = 0; i < rights.size(); ++i) {
                sizes[leftCount + i] = rights.get(i);
            }
        }
        return ImmutableNullableList.copyOf(sizes);
    }

    public List<Double> averageColumnSizes(Intersect rel) {
        return RelMetadataQuery.getAverageColumnSizes(rel.getInput(0));
    }

    public List<Double> averageColumnSizes(Minus rel) {
        return RelMetadataQuery.getAverageColumnSizes(rel.getInput(0));
    }

    public List<Double> averageColumnSizes(Union rel) {
        int fieldCount = rel.getRowType().getFieldCount();
        ArrayList<List<Double>> inputColumnSizeList = Lists.newArrayList();
        for (RelNode input : rel.getInputs()) {
            List<Double> inputSizes = RelMetadataQuery.getAverageColumnSizes(input);
            if (inputSizes == null) continue;
            inputColumnSizeList.add(inputSizes);
        }
        switch (inputColumnSizeList.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (List)inputColumnSizeList.get(0);
            }
        }
        ImmutableNullableList.Builder<Double> sizes = ImmutableNullableList.builder();
        int nn = 0;
        for (int i = 0; i < fieldCount; ++i) {
            double d = 0.0;
            int n = 0;
            for (List list : inputColumnSizeList) {
                Double d2 = (Double)list.get(i);
                if (d2 == null) continue;
                d += d2.doubleValue();
                ++n;
                ++nn;
            }
            sizes.add(n > 0 ? Double.valueOf(d / (double)n) : null);
        }
        if (nn == 0) {
            return null;
        }
        return sizes.build();
    }

    protected Double averageFieldValueSize(RelDataTypeField field) {
        return this.averageTypeValueSize(field.getType());
    }

    public Double averageTypeValueSize(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case BOOLEAN: 
            case TINYINT: {
                return 1.0;
            }
            case SMALLINT: {
                return 2.0;
            }
            case INTEGER: 
            case REAL: 
            case DECIMAL: 
            case DATE: 
            case TIME: {
                return 4.0;
            }
            case BIGINT: 
            case DOUBLE: 
            case FLOAT: 
            case TIMESTAMP: 
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return 8.0;
            }
            case BINARY: {
                return type.getPrecision();
            }
            case VARBINARY: {
                return Math.min((double)type.getPrecision(), 100.0);
            }
            case CHAR: {
                return (double)type.getPrecision() * 2.0;
            }
            case VARCHAR: {
                return Math.min((double)type.getPrecision() * 2.0, 100.0);
            }
            case ROW: {
                Double average = 0.0;
                for (RelDataTypeField field : type.getFieldList()) {
                    average = average + this.averageTypeValueSize(field.getType());
                }
                return average;
            }
        }
        return null;
    }

    public double typeValueSize(RelDataType type, Comparable value) {
        if (value == null) {
            return 1.0;
        }
        switch (type.getSqlTypeName()) {
            case BOOLEAN: 
            case TINYINT: {
                return 1.0;
            }
            case SMALLINT: {
                return 2.0;
            }
            case INTEGER: 
            case REAL: 
            case DATE: 
            case TIME: 
            case FLOAT: {
                return 4.0;
            }
            case BIGINT: 
            case DOUBLE: 
            case TIMESTAMP: 
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return 8.0;
            }
            case BINARY: 
            case VARBINARY: {
                return ((ByteString)value).length();
            }
            case CHAR: 
            case VARCHAR: {
                return ((NlsString)value).getValue().length() * 2;
            }
        }
        return 32.0;
    }

    public Double averageRexSize(RexNode node, List<Double> inputColumnSizes) {
        switch (node.getKind()) {
            case INPUT_REF: {
                return inputColumnSizes.get(((RexInputRef)node).getIndex());
            }
            case LITERAL: {
                return this.typeValueSize(node.getType(), ((RexLiteral)node).getValue());
            }
        }
        if (node instanceof RexCall) {
            RexCall call = (RexCall)node;
            for (RexNode operand : call.getOperands()) {
                if (operand.getType().getSqlTypeName() != node.getType().getSqlTypeName()) continue;
                return this.averageRexSize(operand, inputColumnSizes);
            }
        }
        return this.averageTypeValueSize(node.getType());
    }
}

