/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.metadata;

import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Aggregate;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.SemiJoin;
import hive.org.apache.calcite.rel.core.Sort;
import hive.org.apache.calcite.rel.core.Union;
import hive.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMdUtil;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.ImmutableBitSet;
import hive.org.apache.calcite.util.NumberUtil;

public class RelMdRowCount {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.ROW_COUNT.method, new RelMdRowCount());

    public Double getRowCount(Union rel) {
        double nRows = 0.0;
        for (RelNode input : rel.getInputs()) {
            Double partialRowCount = RelMetadataQuery.getRowCount(input);
            if (partialRowCount == null) {
                return null;
            }
            nRows += partialRowCount.doubleValue();
        }
        return nRows;
    }

    public Double getRowCount(Filter rel) {
        return NumberUtil.multiply(RelMetadataQuery.getSelectivity(rel.getInput(), rel.getCondition()), RelMetadataQuery.getRowCount(rel.getInput()));
    }

    public Double getRowCount(Project rel) {
        return RelMetadataQuery.getRowCount(rel.getInput());
    }

    public Double getRowCount(Sort rel) {
        return RelMetadataQuery.getRowCount(rel.getInput());
    }

    public Double getRowCount(SemiJoin rel) {
        RexNode semiJoinSelectivity = RelMdUtil.makeSemiJoinSelectivityRexNode(rel);
        return NumberUtil.multiply(RelMetadataQuery.getSelectivity(rel.getLeft(), semiJoinSelectivity), RelMetadataQuery.getRowCount(rel.getLeft()));
    }

    public Double getRowCount(Aggregate rel) {
        ImmutableBitSet groupKey = ImmutableBitSet.range(rel.getGroupCount());
        Double distinctRowCount = RelMetadataQuery.getDistinctRowCount(rel.getInput(), groupKey, null);
        if (distinctRowCount == null) {
            return RelMetadataQuery.getRowCount(rel.getInput()) / 10.0;
        }
        return distinctRowCount;
    }

    public Double getRowCount(RelNode rel) {
        return rel.getRows();
    }
}

